/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fusesource.scalate.util.IOUtil$;
import org.fusesource.scalate.util.Logging;
import org.fusesource.scalate.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil$
implements Logging,
ScalaObject {
    public static final IOUtil$ MODULE$;

    static {
        new IOUtil$();
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    public void error(Function0 fn) {
        Logging$class.error((Logging)this, fn);
    }

    @Override
    public void error(Throwable e) {
        Logging$class.error((Logging)this, e);
    }

    public void error(Function0 message, Throwable e) {
        Logging$class.error(this, message, e);
    }

    public void warn(Function0 fn) {
        Logging$class.warn(this, fn);
    }

    public void warn(Function0 fn, Throwable e) {
        Logging$class.warn(this, fn, e);
    }

    public void info(Function0 fn) {
        Logging$class.info(this, fn);
    }

    public void info(Function0 fn, Throwable e) {
        Logging$class.info(this, fn, e);
    }

    public void debug(Function0 fn) {
        Logging$class.debug(this, fn);
    }

    public void debug(Function0 fn, Throwable e) {
        Logging$class.debug(this, fn, e);
    }

    public void trace(Function0 fn) {
        Logging$class.trace(this, fn);
    }

    public void trace(Function0 fn, Throwable e) {
        Logging$class.trace(this, fn, e);
    }

    public /* synthetic */ Function1 recursiveDelete$default$2() {
        return new anonfun.recursiveDelete.default.2.1();
    }

    public /* synthetic */ Function1 unjar$default$3() {
        return new anonfun.unjar.default.3.1();
    }

    public /* synthetic */ String loadText$default$2() {
        return "UTF-8";
    }

    public /* synthetic */ String loadTextFile$default$2() {
        return "UTF-8";
    }

    public void makeParentDirs(String fileName) {
        this.makeParentDirs(new File(fileName));
    }

    public void makeParentDirs(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public boolean rdelete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                Predef$.MODULE$.refArrayOps((Object[])children).foreach((Function1)new anonfun.rdelete.1());
            }
        }
        return file.delete();
    }

    public String loadText(InputStream in, String encoding) {
        return new String(this.loadBytes(in), encoding);
    }

    public String loadTextFile(File path, String encoding) {
        return new String(this.loadBinaryFile(path), encoding);
    }

    public byte[] loadBinaryFile(File path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(path);
        long exceptionResult1 = 0L;
        exceptionResult1 = this.copy(in, baos);
        return baos.toByteArray();
        finally {
            in.close();
        }
    }

    public byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long exceptionResult2 = 0L;
        exceptionResult2 = this.copy(in, baos);
        return baos.toByteArray();
        finally {
            in.close();
        }
    }

    public void writeText(String path, String text2) {
        this.writeText(new File(path), text2);
    }

    public void writeText(File path, String text2) {
        FileWriter out = new FileWriter(path);
        try {
            out.write(text2);
            return;
        }
        finally {
            out.close();
        }
    }

    public void writeBinaryFile(String path, byte[] contents) {
        this.writeBinaryFile(new File(path), contents);
    }

    public void writeBinaryFile(File path, byte[] contents) {
        FileOutputStream out = new FileOutputStream(path);
        try {
            out.write(contents);
            return;
        }
        finally {
            out.close();
        }
    }

    public long copy(File in, File out) {
        out.getParentFile().mkdirs();
        return this.copy(new FileInputStream(in), new FileOutputStream(out));
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(Reader in, Writer out) {
        void var3_3;
        long charsCopied = 0L;
        char[] buffer = new char[8192];
        int chars = in.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * Loose catch block
     */
    public void unjar(File outputDir, InputStream input, Function1<ZipEntry, Boolean> filter) {
        ZipInputStream zip = new ZipInputStream(input);
        try {
            FileOutputStream bos;
            byte[] buffer = new byte[65536];
            boolean ok = true;
            while (ok) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    ok = false;
                    continue;
                }
                String name$1 = entry.getName();
                if (!entry.isDirectory() && BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)entry))) {
                    this.debug((Function0<String>)new anonfun.unjar.1(name$1));
                    File file = new File(new StringBuilder().append((Object)outputDir.getCanonicalPath()).append((Object)"/").append((Object)name$1).toString());
                    file.getParentFile().mkdirs();
                    bos = new FileOutputStream(file);
                    int bytes = 1;
                    while (bytes > 0) {
                        bytes = zip.read(buffer);
                        if (bytes <= 0) continue;
                        bos.write(buffer, 0, bytes);
                    }
                    bos.close();
                }
                zip.closeEntry();
            }
            return;
            catch (Throwable throwable) {
                bos.close();
                throw throwable;
            }
        }
        finally {
            zip.close();
        }
    }

    public void recursiveDelete(File file, Function1<File, Boolean> filter) {
        if (file.exists()) {
            if (file.isDirectory()) {
                Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new anonfun.recursiveDelete.1());
            }
            if (BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)file))) {
                file.delete();
            }
        }
    }

    public boolean allZipEntries(ZipEntry entry) {
        return true;
    }

    public boolean allFiles(File file) {
        return true;
    }

    private IOUtil$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

