/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.db.jpa.JPA;
import play.db.jpa.JPASupport;
import play.db.jpa.Model;
import play.exceptions.UnexpectedException;
import play.modules.search.Field;
import play.modules.search.Indexed;

public class Search {
    private static Map<String, IndexWriter> indexWriters = new HashMap<String, IndexWriter>();
    private static Map<String, IndexSearcher> indexReaders = new HashMap<String, IndexSearcher>();
    public static String DATA_PATH;
    private static String ANALYSER_CLASS;
    public static boolean sync;

    public static void init() {
        try {
            Search.shutdown();
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error while shutting down search module", (Object[])new Object[0]);
        }
        ANALYSER_CLASS = Play.configuration.getProperty("play.search.analyser", "org.apache.lucene.analysis.standard.StandardAnalyzer");
        DATA_PATH = Play.configuration.containsKey("play.search.path") ? Play.configuration.getProperty("play.search.path") : Play.applicationPath.getAbsolutePath() + "/data/search/";
        Logger.trace((String)("Search module repository is in " + DATA_PATH), (Object[])new Object[0]);
        Logger.trace((String)("Write operations synch: " + sync), (Object[])new Object[0]);
        sync = Boolean.parseBoolean(Play.configuration.getProperty("play.search.synch", "true"));
    }

    private static Analyzer getAnalyser() {
        try {
            Class<?> clazz = Class.forName(ANALYSER_CLASS);
            return (Analyzer)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Query search(String query, Class clazz) {
        return new Query(query, clazz);
    }

    public static void unIndex(Object object) {
        try {
            if (!(object instanceof Model)) {
                return;
            }
            if (object.getClass().getAnnotation(Indexed.class) == null) {
                return;
            }
            Model jpaModel = (Model)object;
            String index = object.getClass().getName();
            Search.getIndexWriter(index).deleteDocuments(new Term("_docID", jpaModel.id + ""));
            if (sync) {
                Search.getIndexWriter(index).flush();
                Search.dirtyReader(index);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static void index(Object object) {
        try {
            if (!(object instanceof Model)) {
                return;
            }
            Model jpaModel = (Model)object;
            String index = object.getClass().getName();
            Document document = Search.toDocument(object);
            if (document == null) {
                return;
            }
            Search.getIndexWriter(index).deleteDocuments(new Term("_docID", jpaModel.id + ""));
            Search.getIndexWriter(index).addDocument(document);
            if (sync) {
                Search.getIndexWriter(index).flush();
                Search.dirtyReader(index);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static Document toDocument(Object object) throws Exception {
        Indexed indexed = object.getClass().getAnnotation(Indexed.class);
        if (indexed == null) {
            return null;
        }
        if (!(object instanceof JPASupport)) {
            return null;
        }
        Model jpaModel = (Model)object;
        Document document = new Document();
        document.add((Fieldable)new org.apache.lucene.document.Field("_docID", jpaModel.id + "", Field.Store.YES, Field.Index.UN_TOKENIZED));
        for (java.lang.reflect.Field field : object.getClass().getFields()) {
            Field index = field.getAnnotation(Field.class);
            if (index == null || field.getType().isArray() || field.getType().isAssignableFrom(Collection.class)) continue;
            String name = field.getName();
            String value = Search.valueOf(object, field);
            if (value == null) continue;
            document.add((Fieldable)new org.apache.lucene.document.Field(name, value, index.stored() ? Field.Store.YES : Field.Store.NO, index.tokenize() ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED));
        }
        return document;
    }

    private static String valueOf(Object object, java.lang.reflect.Field field) throws Exception {
        if (field.getType().equals(String.class)) {
            return (String)field.get(object);
        }
        return "" + field.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexSearcher getIndexReader(String name) {
        try {
            if (indexReaders.containsKey(name)) return indexReaders.get(name);
            Class<Search> clazz = Search.class;
            synchronized (Search.class) {
                File root = new File(DATA_PATH, name);
                if (!root.exists()) {
                    throw new UnexpectedException("Could not find " + name + " index. Please re-index");
                }
                IndexSearcher reader = new IndexSearcher((Directory)FSDirectory.getDirectory((File)root));
                indexReaders.put(name, reader);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return indexReaders.get(name);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("Cannot open index", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dirtyReader(String name) {
        Class<Search> clazz = Search.class;
        synchronized (Search.class) {
            try {
                if (indexReaders.containsKey(name)) {
                    IndexReader rd = indexReaders.get(name).getIndexReader().reopen();
                    indexReaders.get(name).close();
                    indexReaders.remove(name);
                    indexReaders.put(name, new IndexSearcher(rd));
                }
            }
            catch (IOException e) {
                throw new UnexpectedException("Can't reopen reader", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IndexWriter getIndexWriter(String name) {
        try {
            if (indexWriters.containsKey(name)) return indexWriters.get(name);
            Class<Search> clazz = Search.class;
            synchronized (Search.class) {
                File root = new File(DATA_PATH, name);
                if (!root.exists()) {
                    root.mkdirs();
                }
                if (new File(root, "write.lock").exists()) {
                    new File(root, "write.lock").delete();
                }
                IndexWriter writer = new IndexWriter((Directory)FSDirectory.getDirectory((File)root), true, Search.getAnalyser());
                indexWriters.put(name, writer);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return indexWriters.get(name);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static void reindex() throws Exception {
        Search.shutdown();
        File fl = new File(DATA_PATH);
        FileUtils.deleteDirectory((File)fl);
        fl.mkdirs();
        List classes = Play.classes.getAnnotatedClasses(Indexed.class);
        for (ApplicationClasses.ApplicationClass applicationClass : classes) {
            List objects = JPA.em().createQuery("select e from " + applicationClass.javaClass.getCanonicalName() + " as e").getResultList();
            for (Model model : objects) {
                Search.index(model);
            }
        }
        Logger.info((String)"Rebuild index finished", (Object[])new Object[0]);
    }

    public static void shutdown() throws Exception {
        for (IndexWriter writer : indexWriters.values()) {
            writer.close();
        }
        for (IndexSearcher searcher : indexReaders.values()) {
            searcher.close();
        }
        indexWriters.clear();
        indexReaders.clear();
    }

    static {
        sync = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query {
        private Class clazz;
        private String query;
        private String[] order = new String[0];
        private int offset = 0;
        private int pageSize = 10;
        private boolean reverse = false;
        private Hits hits = null;

        protected Query(String query, Class clazz) {
            this.query = query;
            this.clazz = clazz;
        }

        public Query page(int offset, int pageSize) {
            this.offset = offset;
            this.pageSize = pageSize;
            return this;
        }

        public Query all() {
            this.pageSize = -1;
            return this;
        }

        public Query reverse() {
            this.reverse = true;
            return this;
        }

        public Query orderBy(String ... order) {
            this.order = order;
            return this;
        }

        private Sort getSort() {
            Sort sort = new Sort();
            if (this.order.length > 0) {
                if (this.reverse) {
                    if (this.order.length != 1) {
                        throw new SearchException("reverse can be used while sorting only one field with oderBy");
                    }
                    sort.setSort(this.order[0], this.reverse);
                } else {
                    sort.setSort(this.order);
                }
            }
            return sort;
        }

        public <T extends JPASupport> List<T> fetch() throws SearchException {
            try {
                List<QueryResult> results = this.executeQuery(true);
                ArrayList<Model> objects = new ArrayList<Model>();
                for (QueryResult queryResult : results) {
                    objects.add(queryResult.object);
                }
                return objects;
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }

        public List<Long> fetchIds() throws SearchException {
            try {
                List<QueryResult> results = this.executeQuery(false);
                ArrayList<Long> objects = new ArrayList<Long>();
                for (QueryResult queryResult : results) {
                    objects.add(Long.parseLong(queryResult.id));
                }
                return objects;
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }

        public long count() throws SearchException {
            try {
                org.apache.lucene.search.Query luceneQuery = new QueryParser("_docID", Search.getAnalyser()).parse(this.query);
                this.hits = Search.getIndexReader(this.clazz.getName()).search(luceneQuery, this.getSort());
                return this.hits.length();
            }
            catch (ParseException e) {
                throw new SearchException(e);
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }

        public List<QueryResult> executeQuery(boolean fetch) throws SearchException {
            try {
                if (this.hits == null) {
                    org.apache.lucene.search.Query luceneQuery = new QueryParser("_docID", Search.getAnalyser()).parse(this.query);
                    this.hits = Search.getIndexReader(this.clazz.getName()).search(luceneQuery, this.getSort());
                }
                ArrayList<QueryResult> results = new ArrayList<QueryResult>();
                if (this.hits == null) {
                    return results;
                }
                int l = this.hits.length();
                if (this.offset > l) {
                    return results;
                }
                ArrayList ids = new ArrayList();
                if (this.pageSize > 0) {
                    for (int i = this.offset; i < (this.offset + this.pageSize > l ? l : this.offset + this.pageSize); ++i) {
                        QueryResult qresult = new QueryResult();
                        qresult.score = this.hits.score(i);
                        qresult.id = this.hits.doc(i).get("_docID");
                        if (fetch) {
                            qresult.object = (Model)JPA.em().find(this.clazz, (Object)Long.parseLong(qresult.id));
                            if (qresult.object == null) {
                                throw new SearchException("Please re-index");
                            }
                        }
                        results.add(qresult);
                    }
                } else {
                    for (int i = 0; i < l; ++i) {
                        QueryResult qresult = new QueryResult();
                        qresult.score = this.hits.score(i);
                        qresult.id = this.hits.doc(i).get("_docID");
                        if (fetch) {
                            qresult.object = (Model)JPA.em().find(this.clazz, (Object)Long.parseLong(qresult.id));
                            if (qresult.object == null) {
                                throw new SearchException("Please re-index");
                            }
                        }
                        results.add(qresult);
                    }
                }
                return results;
            }
            catch (ParseException e) {
                throw new SearchException(e);
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
    }

    public static class QueryResult {
        public String id;
        public float score;
        public Model object;
    }

    public static class SearchException
    extends RuntimeException {
        public SearchException(String message, Throwable cause) {
            super(message, cause);
        }

        public SearchException(Throwable cause) {
            super(cause);
        }

        public SearchException(String message) {
            super(message);
        }
    }
}

