/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search;

import org.apache.lucene.analysis.Analyzer;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.search.Query;
import play.modules.search.store.Store;

public class Search {
    private static String ANALYSER_CLASS;
    private static Store store;

    public static void init() {
        try {
            Search.shutdown();
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error while shutting down search module", (Object[])new Object[0]);
        }
        ANALYSER_CLASS = Play.configuration.getProperty("play.search.analyser", "org.apache.lucene.analysis.standard.StandardAnalyzer");
        String storeClassName = Play.configuration.getProperty("play.search.store", "play.modules.search.store.FilesystemStore");
        try {
            store = (Store)Class.forName(storeClassName).newInstance();
            store.start();
        }
        catch (Exception e) {
            throw new UnexpectedException("Could not intialize store", (Throwable)e);
        }
    }

    public static Analyzer getAnalyser() {
        try {
            Class<?> clazz = Class.forName(ANALYSER_CLASS);
            return (Analyzer)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Store getCurrentStore() {
        return store;
    }

    public static Query search(String query, Class clazz) {
        return new Query(query, clazz, store);
    }

    public static void unIndex(Object object) {
        store.unIndex(object);
    }

    public static void index(Object object) {
        store.index(object, object.getClass().getName());
    }

    public static void rebuildAllIndexes() throws Exception {
        store.rebuildAllIndexes();
    }

    public static void shutdown() throws Exception {
        if (store != null) {
            store.stop();
        }
    }
}

