/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search;

import play.Play;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.search.Search;
import play.mvc.Router;

public class SearchPlugin
extends PlayPlugin {
    public void onApplicationStart() {
        Search.init();
    }

    public void onApplicationStop() {
        try {
            Search.shutdown();
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void onEvent(String message, Object context) {
        if (!message.startsWith("JPASupport")) {
            return;
        }
        if (message.equals("JPASupport.objectPersisted") || message.equals("JPASupport.objectUpdated")) {
            Search.index(context);
        } else if (message.equals("JPASupport.objectDeleted")) {
            Search.unIndex(context);
        }
    }

    public void onRoutesLoaded() {
        if (Play.mode == Play.Mode.DEV) {
            Router.addRoute((String)"GET", (String)"/@search/?", (String)"modules.search.Administration.index");
            Router.addRoute((String)"GET", (String)"/@search/optimize/{name}", (String)"modules.search.Administration.optimize");
            Router.addRoute((String)"GET", (String)"/@search/reindex/{name}", (String)"modules.search.Administration.reindex");
            Router.addRoute((String)"GET", (String)"/@search/reopen/{name}", (String)"modules.search.Administration.reopen");
        }
    }
}

