/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search.store;

import java.util.ArrayList;
import java.util.List;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.db.jpa.FileAttachment;
import play.modules.search.store.extractors.TextExtractor;
import play.modules.search.store.mime.ExtensionGuesser;
import play.modules.search.store.mime.MimeGuesser;

public class FileExtractor {
    public static List<TextExtractor> extractors = new ArrayList<TextExtractor>();
    public static MimeGuesser mimeGuesser = new ExtensionGuesser();

    public static String getText(FileAttachment file) {
        String mime = mimeGuesser.guess(file);
        for (TextExtractor extractor : extractors) {
            if (!extractor.handles(mime)) continue;
            Logger.debug((String)"Using %s extractor to handle file %s, mime=%s", (Object[])new Object[]{extractor.getClass().getName(), file.filename, mime});
            return extractor.extract(file);
        }
        Logger.warn((String)"No handlers able to index %s mime type, file was %s", (Object[])new Object[]{mime, file.filename});
        return null;
    }

    static {
        List classes = Play.classes.getAssignableClasses(TextExtractor.class);
        for (ApplicationClasses.ApplicationClass applicationClass : classes) {
            try {
                extractors.add((TextExtractor)applicationClass.javaClass.newInstance());
            }
            catch (Exception e) {
                Logger.warn((Throwable)e, (String)"Could not instanciate text extractor %s", (Object[])new Object[]{applicationClass.javaClass.getName()});
            }
        }
    }
}

