/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Sort;
import play.Play;
import play.db.jpa.JPA;
import play.db.jpa.JPASupport;
import play.exceptions.UnexpectedException;
import play.modules.search.Search;
import play.modules.search.store.ConvertionUtils;
import play.modules.search.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private Class clazz;
    private String query;
    private Store store;
    private String[] order = new String[0];
    private int offset = 0;
    private int pageSize = 10;
    private boolean reverse = false;
    private Hits hits = null;

    protected Query(String query, Class clazz, Store store) {
        this.query = query;
        this.clazz = clazz;
        this.store = store;
    }

    public Query page(int offset, int pageSize) {
        this.offset = offset;
        this.pageSize = pageSize;
        return this;
    }

    public Query all() {
        this.pageSize = -1;
        return this;
    }

    public Query reverse() {
        this.reverse = true;
        return this;
    }

    public Query orderBy(String ... order) {
        this.order = new String[order.length];
        for (int i = 0; i < order.length; ++i) {
            this.order[i] = order[i] + (ConvertionUtils.isForcedUntokenized(this.clazz, order[i]) ? "_untokenized" : "");
        }
        return this;
    }

    private Sort getSort() {
        Sort sort = new Sort();
        if (this.order.length > 0) {
            if (this.reverse) {
                if (this.order.length != 1) {
                    throw new SearchException("reverse can be used while sorting only one field with oderBy");
                }
                sort.setSort(this.order[0], this.reverse);
            } else {
                sort.setSort(this.order);
            }
        }
        return sort;
    }

    public <T extends JPASupport> List<T> fetch() throws SearchException {
        try {
            List<QueryResult> results = this.executeQuery(true);
            ArrayList<JPASupport> objects = new ArrayList<JPASupport>();
            for (QueryResult queryResult : results) {
                objects.add(queryResult.object);
            }
            return objects;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public List<Long> fetchIds() throws SearchException {
        try {
            List<QueryResult> results = this.executeQuery(false);
            ArrayList<Long> objects = new ArrayList<Long>();
            for (QueryResult queryResult : results) {
                objects.add(Long.parseLong(queryResult.id));
            }
            return objects;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public long count() throws SearchException {
        try {
            org.apache.lucene.search.Query luceneQuery = new QueryParser("_docID", Search.getAnalyser()).parse(this.query);
            this.hits = this.store.getIndexSearcher(this.clazz.getName()).search(luceneQuery, this.getSort());
            return this.hits.length();
        }
        catch (ParseException e) {
            throw new SearchException(e);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public List<QueryResult> executeQuery(boolean fetch) throws SearchException {
        try {
            if (this.hits == null) {
                org.apache.lucene.search.Query luceneQuery = new QueryParser("_docID", Search.getAnalyser()).parse(this.query);
                BooleanQuery.setMaxClauseCount((int)Integer.parseInt(Play.configuration.getProperty("play.search.maxClauseCount", "1024")));
                this.hits = this.store.getIndexSearcher(this.clazz.getName()).search(luceneQuery, this.getSort());
            }
            ArrayList<QueryResult> results = new ArrayList<QueryResult>();
            if (this.hits == null) {
                return results;
            }
            int l = this.hits.length();
            if (this.offset > l) {
                return results;
            }
            ArrayList ids = new ArrayList();
            if (this.pageSize > 0) {
                for (int i = this.offset; i < (this.offset + this.pageSize > l ? l : this.offset + this.pageSize); ++i) {
                    QueryResult qresult = new QueryResult();
                    qresult.score = this.hits.score(i);
                    qresult.id = this.hits.doc(i).get("_docID");
                    if (fetch) {
                        Object objectId = ConvertionUtils.getIdValueFromIndex(this.clazz, qresult.id);
                        qresult.object = (JPASupport)JPA.em().find(this.clazz, objectId);
                        if (qresult.object == null) {
                            throw new SearchException("Please re-index");
                        }
                    }
                    results.add(qresult);
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    QueryResult qresult = new QueryResult();
                    qresult.score = this.hits.score(i);
                    qresult.id = this.hits.doc(i).get("_docID");
                    if (fetch) {
                        Object objectId = ConvertionUtils.getIdValueFromIndex(this.clazz, qresult.id);
                        qresult.object = (JPASupport)JPA.em().find(this.clazz, objectId);
                        if (qresult.object == null) {
                            throw new SearchException("Please re-index");
                        }
                    }
                    results.add(qresult);
                }
            }
            return results;
        }
        catch (ParseException e) {
            throw new SearchException(e);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static class SearchException
    extends RuntimeException {
        public SearchException(String message, Throwable cause) {
            super(message, cause);
        }

        public SearchException(Throwable cause) {
            super(cause);
        }

        public SearchException(String message) {
            super(message);
        }
    }

    public static class QueryResult {
        public String id;
        public float score;
        public JPASupport object;
    }
}

