/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.search.Query;
import play.modules.search.store.Store;

public class Search {
    private static String ANALYSER_CLASS;
    private static Version LUCENE_VERSION;
    private static Store store;

    public static void init() {
        try {
            Search.shutdown();
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error while shutting down search module", (Object[])new Object[0]);
        }
        ANALYSER_CLASS = Play.configuration.getProperty("play.search.analyser", "org.apache.lucene.analysis.standard.StandardAnalyzer");
        LUCENE_VERSION = Version.valueOf((String)("LUCENE_" + Play.configuration.getProperty("play.search.lucene.version", "30")));
        String storeClassName = Play.configuration.getProperty("play.search.store", "play.modules.search.store.FilesystemStore");
        try {
            store = (Store)Class.forName(storeClassName).newInstance();
            store.start();
        }
        catch (Exception e) {
            throw new UnexpectedException("Could not intialize store", (Throwable)e);
        }
    }

    public static Analyzer getAnalyser() {
        Class clazz = null;
        try {
            clazz = Play.classloader.loadClass(ANALYSER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException("The analyzer class '" + ANALYSER_CLASS + "' could not be found!", (Throwable)e);
        }
        try {
            try {
                return (Analyzer)clazz.getConstructor(Version.class).newInstance(Search.getLuceneVersion());
            }
            catch (NoSuchMethodException e) {
                Logger.debug((String)"getAnalyser(): not versioned constructor for class '%s', trying default constructor...", (Object[])new Object[]{ANALYSER_CLASS});
                return (Analyzer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("The analyzer class '" + ANALYSER_CLASS + "' could not be instanciated!", (Throwable)e);
        }
    }

    public static Version getLuceneVersion() {
        return LUCENE_VERSION;
    }

    public static Store getCurrentStore() {
        return store;
    }

    public static Query search(String query, Class clazz) {
        return new Query(query, clazz, store);
    }

    public static void unIndex(Object object) {
        store.unIndex(object);
    }

    public static void index(Object object) {
        store.index(object, object.getClass().getName());
    }

    public static void rebuildAllIndexes() throws Exception {
        store.rebuildAllIndexes();
    }

    public static void shutdown() throws Exception {
        if (store != null) {
            store.stop();
        }
    }
}

