/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search.store;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.db.jpa.JPA;
import play.db.jpa.JPABase;
import play.exceptions.UnexpectedException;
import play.libs.Files;
import play.modules.search.Indexed;
import play.modules.search.Search;
import play.modules.search.store.ConvertionUtils;
import play.modules.search.store.ManagedIndex;
import play.modules.search.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemStore
implements Store {
    protected Map<String, IndexWriter> indexWriters = new HashMap<String, IndexWriter>();
    protected Map<String, IndexSearcher> indexSearchers = new HashMap<String, IndexSearcher>();
    public static String DATA_PATH;
    public static boolean sync;

    @Override
    public void unIndex(Object object) {
        try {
            if (!(object instanceof JPABase)) {
                return;
            }
            if (object.getClass().getAnnotation(Indexed.class) == null) {
                return;
            }
            JPABase jpaBase = (JPABase)object;
            String index = object.getClass().getName();
            this.getIndexWriter(index).deleteDocuments(new Term("_docID", ConvertionUtils.getIdValueFor(jpaBase) + ""));
            if (sync) {
                this.getIndexWriter(index).commit();
                this.dirtyReader(index);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @Override
    public void index(Object object, String index) {
        try {
            if (!(object instanceof JPABase)) {
                Logger.warn((String)("Unable to index " + object + ", unsupported class type. Only play.db.jpa.JPABase classes are supported."), (Object[])new Object[0]);
                return;
            }
            JPABase jpaABase = (JPABase)object;
            Document document = ConvertionUtils.toDocument(object);
            if (document == null) {
                return;
            }
            this.getIndexWriter(index).deleteDocuments(new Term("_docID", ConvertionUtils.getIdValueFor(jpaABase) + ""));
            this.getIndexWriter(index).addDocument(document);
            if (sync) {
                this.getIndexWriter(index).commit();
                this.dirtyReader(index);
            } else if (this.getIndexWriter(index).ramSizeInBytes() > 0x3000000L) {
                this.getIndexWriter(index).commit();
                this.dirtyReader(index);
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexSearcher getIndexSearcher(String name) {
        try {
            if (!this.indexSearchers.containsKey(name)) {
                FilesystemStore filesystemStore = this;
                synchronized (filesystemStore) {
                    File root = new File(DATA_PATH, name);
                    if (!root.exists()) {
                        this.getIndexWriter(name);
                    }
                    IndexSearcher reader = new IndexSearcher((Directory)FSDirectory.open((File)root));
                    reader.setDefaultFieldSortScoring(true, true);
                    this.indexSearchers.put(name, reader);
                }
            }
            return this.indexSearchers.get(name);
        }
        catch (Exception e) {
            throw new UnexpectedException("Cannot open index", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirtyReader(String name) {
        FilesystemStore filesystemStore = this;
        synchronized (filesystemStore) {
            try {
                if (this.indexSearchers.containsKey(name)) {
                    IndexReader rd = this.indexSearchers.get(name).getIndexReader();
                    this.indexSearchers.get(name).close();
                    this.indexSearchers.remove(name);
                }
            }
            catch (Exception e) {
                throw new UnexpectedException("Can't reopen reader", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(String name) {
        try {
            if (!this.indexWriters.containsKey(name)) {
                FilesystemStore filesystemStore = this;
                synchronized (filesystemStore) {
                    File root = new File(DATA_PATH, name);
                    if (!root.exists()) {
                        root.mkdirs();
                    }
                    if (new File(root, "write.lock").exists()) {
                        new File(root, "write.lock").delete();
                    }
                    IndexWriter writer = new IndexWriter((Directory)FSDirectory.open((File)root), Search.getAnalyser(), IndexWriter.MaxFieldLength.UNLIMITED);
                    this.indexWriters.put(name, writer);
                }
            }
            return this.indexWriters.get(name);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @Override
    public void rebuildAllIndexes() throws Exception {
        this.stop();
        File fl = new File(DATA_PATH);
        Files.deleteDirectory((File)fl);
        fl.mkdirs();
        List classes = Play.classes.getAnnotatedClasses(Indexed.class);
        for (ApplicationClasses.ApplicationClass applicationClass : classes) {
            this.rebuild(applicationClass.javaClass.getName());
        }
        Logger.info((String)"Rebuild index finished", (Object[])new Object[0]);
    }

    @Override
    public List<ManagedIndex> listIndexes() {
        ArrayList<ManagedIndex> indexes = new ArrayList<ManagedIndex>();
        List classes = Play.classes.getAnnotatedClasses(Indexed.class);
        for (ApplicationClasses.ApplicationClass applicationClass : classes) {
            ManagedIndex index = new ManagedIndex();
            index.name = applicationClass.javaClass.getName();
            index.optimized = this.getIndexSearcher(index.name).getIndexReader().isOptimized();
            index.documentCount = this.getIndexSearcher(index.name).getIndexReader().numDocs();
            index.jpaCount = (Long)JPA.em().createQuery("select count (*) from " + applicationClass.javaClass.getCanonicalName() + ")").getSingleResult();
            indexes.add(index);
        }
        return indexes;
    }

    @Override
    public void start() {
        DATA_PATH = Play.configuration.containsKey("play.search.path") ? Play.configuration.getProperty("play.search.path") : Play.applicationPath.getAbsolutePath() + "/data/search/";
        Logger.trace((String)("Search module repository is in " + DATA_PATH), (Object[])new Object[0]);
        sync = Boolean.parseBoolean(Play.configuration.getProperty("play.search.synch", "true"));
        Logger.trace((String)("Write operations sync: " + sync), (Object[])new Object[0]);
    }

    @Override
    public void stop() throws Exception {
        for (IndexWriter writer : this.indexWriters.values()) {
            writer.close();
        }
        for (IndexSearcher searcher : this.indexSearchers.values()) {
            searcher.close();
        }
        this.indexWriters.clear();
        this.indexSearchers.clear();
    }

    @Override
    public void optimize(String name) {
        try {
            this.getIndexWriter(name).optimize(true);
            this.getIndexWriter(name).commit();
            this.dirtyReader(name);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @Override
    public void rebuild(String name) {
        String id = UUID.randomUUID().toString();
        File oldFolder = new File(DATA_PATH, name);
        File newFolder = new File(DATA_PATH, name + id);
        Class cl = Play.classes.getApplicationClass((String)name).javaClass;
        List objects = JPA.em().createQuery("select e from " + cl.getCanonicalName() + " as e").getResultList();
        String index = cl.getName() + id;
        IndexWriter indexWriter = this.getIndexWriter(index);
        try {
            for (JPABase jpaBase : objects) {
                Document document = ConvertionUtils.toDocument(jpaBase);
                if (document == null) {
                    return;
                }
                indexWriter.addDocument(document);
            }
            this.getIndexWriter(index).commit();
            this.dirtyReader(index);
            this.getIndexSearcher(name).close();
            this.indexSearchers.remove(name);
            this.getIndexWriter(name).close();
            this.indexWriters.remove(name);
            Files.deleteDirectory((File)oldFolder);
            newFolder.renameTo(oldFolder);
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @Override
    public void reopen(String name) {
        this.dirtyReader(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) {
        FilesystemStore filesystemStore = this;
        synchronized (filesystemStore) {
            try {
                File target;
                if (this.indexSearchers.containsKey(name)) {
                    IndexReader rd = this.indexSearchers.get(name).getIndexReader();
                    this.indexSearchers.get(name).close();
                    this.indexSearchers.remove(name);
                }
                if (this.indexWriters.containsKey(name)) {
                    this.indexWriters.get(name).close();
                    this.indexWriters.remove(name);
                }
                if ((target = new File(DATA_PATH, name)).exists() && target.isDirectory()) {
                    Files.deleteDirectory((File)target);
                }
            }
            catch (Exception e) {
                throw new UnexpectedException("Can't reopen reader", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteAll() {
        File root = new File(DATA_PATH);
        if (root.exists() && root.isDirectory()) {
            File[] indexes;
            for (File file : indexes = root.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                this.delete(file.getName());
            }
        }
    }

    @Override
    public boolean hasIndex(String name) {
        return new File(DATA_PATH, name).exists();
    }

    static {
        sync = true;
    }
}

