/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.brl;

import java.util.List;
import org.drools.guvnor.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.IPattern;

public class FactPattern
implements IPattern {
    public CompositeFieldConstraint constraintList;
    public String factType;
    public String boundName;

    public FactPattern() {
    }

    public FactPattern(String factType) {
        this.factType = factType;
    }

    public void addConstraint(FieldConstraint constraint) {
        if (this.constraintList == null) {
            this.constraintList = new CompositeFieldConstraint();
        }
        this.constraintList.addConstraint(constraint);
    }

    public void removeConstraint(int idx) {
        this.constraintList.removeConstraint(idx);
    }

    public boolean isBound() {
        return this.boundName != null && !"".equals(this.boundName);
    }

    public FieldConstraint[] getFieldConstraints() {
        if (this.constraintList == null) {
            return new FieldConstraint[0];
        }
        return this.constraintList.constraints;
    }

    public void setFieldConstraints(List sortedConstraints) {
        if (sortedConstraints != null) {
            if (this.constraintList != null) {
                this.constraintList.constraints = new FieldConstraint[sortedConstraints.size()];
                for (int i = 0; i < sortedConstraints.size(); ++i) {
                    this.constraintList.constraints[i] = (FieldConstraint)sortedConstraints.get(i);
                }
            } else if (sortedConstraints.size() > 0) {
                throw new IllegalStateException("Cannot have constraints if constraint list is null.");
            }
        } else {
            this.constraintList.constraints = null;
        }
    }
}

