/*
 * Decompiled with CFR 0.152.
 */
package play.modules.securePermissions;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.DefaultAgendaEventListener;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatelessKnowledgeSession;
import play.Logger;
import play.Play;
import play.modules.securePermissions.PermissionCheck;
import play.modules.securePermissions.Role;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permissions {
    private static final String RULES_FILE_NAME = "permissions.drl";
    private static KnowledgeBase knowledgeBase;
    private static String rulesFileName;
    private static Long rulesLastModified;
    private static String rulesMD5;

    private Permissions() {
    }

    static void maybeLoadKnowledgeBase() {
        VirtualFile rulesFile;
        String newRulesFileName = Play.configuration.getProperty("secure.rules");
        boolean defaultUsed = false;
        if (newRulesFileName == null) {
            newRulesFileName = RULES_FILE_NAME;
            defaultUsed = true;
        }
        if ((rulesFile = Play.getVirtualFile((String)("conf/" + newRulesFileName))) == null || !rulesFile.exists()) {
            if (defaultUsed) {
                Logger.warn((String)"No permissions file specified and none found: all permissions checks will be denied.", (Object[])new Object[0]);
                knowledgeBase = null;
                return;
            }
            throw new RuntimeException("Rules file conf/" + newRulesFileName + " does not exist");
        }
        if (Play.mode == Play.Mode.PROD) {
            rulesFileName = newRulesFileName;
            Permissions.loadKnowledgeBase(rulesFile.content());
        } else {
            Long newLastModified = rulesFile.lastModified();
            byte[] content = rulesFile.content();
            String newMD5 = DigestUtils.md5Hex((byte[])content);
            if (!(rulesFileName != null && rulesFileName.equals(newRulesFileName) && rulesLastModified != null && newLastModified.equals(rulesLastModified) && rulesMD5 != null && newMD5.equals(rulesMD5))) {
                Logger.info((String)"old file: %s, new file: %s, old modified: %s, new modified: %s, old md5: %s, new md5: %s", (Object[])new Object[]{rulesFileName, newRulesFileName, rulesLastModified, newLastModified, rulesMD5, newMD5});
                rulesFileName = newRulesFileName;
                rulesLastModified = newLastModified;
                rulesMD5 = newMD5;
                Permissions.loadKnowledgeBase(content);
            }
        }
    }

    private static void loadKnowledgeBase(byte[] rulesContent) {
        Logger.info((String)"Loading rules from %s", (Object[])new Object[]{rulesFileName});
        Properties properties = new Properties();
        properties.put("drools.dialect.java.compiler", "JANINO");
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        KnowledgeBuilderConfiguration configuration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)properties, (ClassLoader)Play.classloader);
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)configuration);
        builder.add(ResourceFactory.newByteArrayResource((byte[])rulesContent), ResourceType.DRL);
        if (builder.hasErrors()) {
            Logger.error((String)builder.getErrors().toString(), (Object[])new Object[0]);
            throw new RuntimeException("Drools compilation failed: " + builder.getErrors().size() + " errors");
        }
        knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
    }

    public static boolean check(PermissionCheck check, String user, Collection<String> roles) {
        Logger.debug((String)"%s, user=%s, roles=%s)", (Object[])new Object[]{check, user, roles});
        if (knowledgeBase == null) {
            Logger.debug((String)"DENIED (no permissions file specified)", (Object[])new Object[0]);
            return false;
        }
        StatelessKnowledgeSession session = knowledgeBase.newStatelessKnowledgeSession();
        session.addEventListener((AgendaEventListener)new AgendaLogger());
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)check));
        commands.add(CommandFactory.newInsert((Object)check.getTarget()));
        commands.add(CommandFactory.newInsert((Object)Permissions.asPrincipal(user)));
        commands.add(CommandFactory.newInsertElements(Permissions.asRoles(roles)));
        session.execute(CommandFactory.newBatchExecution(commands));
        Logger.debug((String)((check.isGranted() ? "GRANTED" : "DENIED") + "\n"), (Object[])new Object[0]);
        return check.isGranted();
    }

    private static Principal asPrincipal(final String user) {
        Principal principal = new Principal(){

            public String getName() {
                return user;
            }
        };
        return principal;
    }

    private static Collection<Role> asRoles(Collection<String> names) {
        HashSet<Role> roles = new HashSet<Role>();
        for (String name : names) {
            roles.add(new Role(name));
        }
        return roles;
    }

    private static class AgendaLogger
    extends DefaultAgendaEventListener {
        private AgendaLogger() {
        }

        public void afterActivationFired(AfterActivationFiredEvent event) {
            Logger.debug((String)"RULE '%s' %s", (Object[])new Object[]{event.getActivation().getRule().getName(), event.getActivation().getFactHandles()});
        }
    }
}

