/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import siena.Filter;
import siena.Model;
import siena.PersistenceManager;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.SienaException;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    public void initModel(Model model) {
        Field[] fields;
        Class<?> clazz = model.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() != Query.class) continue;
            Filter filter = field.getAnnotation(Filter.class);
            if (filter == null) {
                throw new SienaException("Found Query<T> field without @Filter annotation at " + clazz.getName() + "." + field.getName());
            }
            ParameterizedType pt = (ParameterizedType)field.getGenericType();
            Class c = (Class)pt.getActualTypeArguments()[0];
            try {
                field.set(model, new ProxyQuery(c, filter.value(), model));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyQuery<T extends Model>
    implements Query<T> {
        private String filter;
        private Class<T> clazz;
        private PersistenceManager pm;
        private Model obj;

        public ProxyQuery(Class<T> clazz, String filter, Model obj) {
            this.filter = filter;
            this.clazz = clazz;
            this.pm = PersistenceManagerFactory.getPersistenceManager(clazz);
            this.obj = obj;
        }

        private Query<T> createQuery() {
            return this.pm.createQuery(this.clazz).filter(this.filter, this.obj);
        }

        @Override
        public int count() {
            return this.createQuery().count();
        }

        @Override
        public int count(int limit) {
            return this.createQuery().count(limit);
        }

        @Override
        public int count(int limit, int offset) {
            return this.createQuery().count(limit, offset);
        }

        @Override
        public List<T> fetch() {
            return this.createQuery().fetch();
        }

        @Override
        public List<T> fetch(int limit) {
            return this.createQuery().fetch(limit);
        }

        @Override
        public List<T> fetch(int limit, int offset) {
            return this.createQuery().fetch(limit, offset);
        }

        @Override
        public Query<T> filter(String fieldName, Object value) {
            return this.createQuery().filter(fieldName, value);
        }

        @Override
        public T get() {
            return this.createQuery().get();
        }

        @Override
        public Iterable<T> iter(String field, int max) {
            return this.createQuery().iter(field, max);
        }

        @Override
        public Query<T> order(String fieldName) {
            return this.createQuery().order(fieldName);
        }

        @Override
        public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
            return this.createQuery().search(match, inBooleanMode, fieldNames);
        }

        @Override
        public ProxyQuery<T> clone() {
            return new ProxyQuery<T>(this.clazz, this.filter, this.obj);
        }
    }
}

