/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import siena.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json
implements Iterable<Json> {
    private Object object;
    private Map<String, Json> map;
    private List<Json> list;

    public Json(Object object) {
        this.object = object;
        if (object == null) {
            return;
        }
        if (object instanceof Number) {
            return;
        }
        if (object instanceof String) {
            return;
        }
        if (object instanceof Boolean) {
            return;
        }
        if (object instanceof Collection) {
            object = ((Collection)object).toArray();
        }
        if (object instanceof Object[]) {
            this.list = new ArrayList<Json>();
            this.add(object);
            this.object = null;
            return;
        }
        if (object instanceof Map) {
            this.map = new HashMap<String, Json>();
            Map m = (Map)object;
            for (Map.Entry entry : m.entrySet()) {
                this.put(entry.getKey().toString(), entry.getValue());
            }
            this.object = null;
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
    }

    private Json() {
    }

    public static Json map() {
        Json json = new Json();
        json.map = new HashMap<String, Json>();
        return json;
    }

    public static Json sortedMap() {
        Json json = new Json();
        json.map = new TreeMap<String, Json>();
        return json;
    }

    public static Json list(Object ... objects) {
        Json json = new Json();
        json.list = new ArrayList<Json>();
        json.add(objects);
        return json;
    }

    private Json wrap(Object object) {
        if (object instanceof Json) {
            return (Json)object;
        }
        return new Json(object);
    }

    public Json add(Object ... objects) {
        for (Object object : objects) {
            this.list.add(this.wrap(object));
        }
        return this;
    }

    public Json addAt(int index, Object object) {
        this.list.add(index, this.wrap(object));
        return this;
    }

    public Json removeAt(int index) {
        this.list.remove(index);
        return this;
    }

    public int indexOf(Object value) {
        return this.list.indexOf(this.wrap(value));
    }

    public Json get(String key) {
        return this.map.get(key);
    }

    public Json put(String key, Object value) {
        this.map.put(key, this.wrap(value));
        return this;
    }

    public Json putAll(Json json) {
        Set<String> keys = json.keys();
        for (String key : keys) {
            this.put(key, json.get(key));
        }
        return this;
    }

    public Json addAll(Json json) {
        for (Json js : json) {
            this.add(js);
        }
        return this;
    }

    public Json at(int index) {
        return this.list.get(index);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object obj) {
        return this.map.containsValue(this.wrap(obj));
    }

    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    public Collection<Json> values() {
        return this.map.values();
    }

    public boolean remove(Object obj) {
        if (this.list != null) {
            return this.list.remove(this.wrap(obj));
        }
        if (this.map != null) {
            return this.map.remove(obj) != null;
        }
        return false;
    }

    public int size() {
        if (this.map != null) {
            return this.map.size();
        }
        if (this.list != null) {
            return this.list.size();
        }
        return 1;
    }

    @Override
    public Iterator<Json> iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        if (this.map != null) {
            return this.map.values().iterator();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void formatString(Writer writer, String s) throws IOException {
        writer.write(34);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block8;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block8;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block8;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block8;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block8;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block8;
                }
                default: {
                    writer.write(c);
                }
            }
        }
        writer.write("\"");
    }

    public void format(Writer writer, Object o) throws IOException {
        if (o instanceof String) {
            this.formatString(writer, (String)o);
        } else {
            writer.write(o.toString());
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public void write(Writer writer) throws IOException {
        if (this.object != null) {
            this.format(writer, this.object);
            return;
        }
        if (this.map != null) {
            if (this.map.isEmpty()) {
                writer.write("{}");
                return;
            }
            writer.write("{");
            boolean first = true;
            for (Map.Entry<String, Json> entry : this.map.entrySet()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                this.formatString(writer, entry.getKey());
                writer.write(": ");
                entry.getValue().write(writer);
            }
            writer.write("}");
            return;
        }
        if (this.list != null) {
            if (this.list.isEmpty()) {
                writer.write("[]");
                return;
            }
            writer.write("[");
            boolean first = true;
            for (Json obj : this.list) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                obj.write(writer);
            }
            writer.write("]");
            return;
        }
        writer.write("null");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : ((Object)this.list).hashCode());
        result = 31 * result + (this.map == null ? 0 : ((Object)this.map).hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Json other = (Json)obj;
        if (this.list == null ? other.list != null : !((Object)this.list).equals(other.list)) {
            return false;
        }
        if (this.map == null ? other.map != null : !((Object)this.map).equals(other.map)) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    public String str() {
        return this.asString();
    }

    public String asString() {
        return this.object.toString();
    }

    public boolean bool() {
        return this.asBoolean();
    }

    public boolean asBoolean() {
        return (Boolean)this.object;
    }

    public int asInt() {
        return ((Number)this.object).intValue();
    }

    public short asShort() {
        return ((Number)this.object).shortValue();
    }

    public byte asByte() {
        return ((Number)this.object).byteValue();
    }

    public long asLong() {
        return ((Number)this.object).longValue();
    }

    public Double asDouble() {
        return ((Number)this.object).doubleValue();
    }

    public float asFloat() {
        return ((Number)this.object).floatValue();
    }

    public boolean isNull() {
        return this.object == null && this.list == null && this.map == null;
    }

    public boolean isNumber() {
        return this.object != null && this.object instanceof Number;
    }

    public boolean isBoolean() {
        return this.object != null && this.object instanceof Boolean;
    }

    public boolean isString() {
        return this.object != null && this.object instanceof String;
    }

    public boolean isMap() {
        return this.map != null;
    }

    public boolean isList() {
        return this.list != null;
    }

    public static Json loads(String s) {
        return new Parser(s).parse();
    }

    public static Json load(BufferedReader reader) {
        return new Parser(reader).parse();
    }
}

