/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import siena.Model;
import siena.PersistenceManager;
import siena.SienaException;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerFactory {
    private static PersistenceManagerFactory singleton;
    protected static SienaLogger logger;
    private Map<String, PersistenceManager> configuration = new HashMap<String, PersistenceManager>();

    public static PersistenceManager getPersistenceManager(Class<? extends Model> clazz) {
        return PersistenceManagerFactory.getInstance().get(clazz);
    }

    private static PersistenceManagerFactory getInstance() {
        if (singleton == null) {
            singleton = new PersistenceManagerFactory();
        }
        return singleton;
    }

    private PersistenceManager get(Class<? extends Model> clazz) {
        String pack = PersistenceManagerFactory.getPackage(clazz);
        PersistenceManager pm = this.configuration.get(pack);
        if (pm != null) {
            return pm;
        }
        URL url = clazz.getResource("siena.properties");
        if (url == null) {
            throw new SienaException("Cannot load siena.properties file for package: " + pack);
        }
        Properties p = new Properties();
        try {
            p.load(url.openStream());
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
        String impl = p.getProperty("implementation");
        if (impl == null) {
            throw new SienaException("key 'implementation' not found at " + url);
        }
        try {
            pm = (PersistenceManager)Class.forName(impl).newInstance();
            pm.init(p);
        }
        catch (Exception e) {
            throw new SienaException("Error while creating instance of: " + impl, e);
        }
        this.configuration.put(pack, pm);
        return pm;
    }

    public static void install(PersistenceManager pm, Class<? extends Model> clazz) {
        PersistenceManagerFactory.getInstance().put(pm, PersistenceManagerFactory.getPackage(clazz));
    }

    private void put(PersistenceManager pm, String pack) {
        this.configuration.put(pack, pm);
    }

    private static String getPackage(Class<?> clazz) {
        String clazzName = clazz.getName();
        return clazzName.substring(0, clazzName.lastIndexOf(46));
    }

    static {
        logger = SienaLoggerFactory.getLogger(PersistenceManagerFactory.class);
    }
}

