/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import siena.Model;
import siena.Query;
import siena.SienaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterator<T extends Model>
implements Iterator<T> {
    private Query<T> query;
    private int max;
    private List<T> current;
    private int index;
    private String field;
    private T last;

    public QueryIterator(Query<T> query, int max, String field) {
        this.query = query.clone().order(field);
        this.max = max;
        this.index = 0;
        this.field = field;
        this.current = this.query.fetch(max);
        this.last = null;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.current == null) {
                Field f = this.last.getClass().getDeclaredField(this.field);
                f.setAccessible(true);
                this.current = this.query.clone().filter(this.field + ">", f.get(this.last)).fetch(this.max);
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return !this.current.isEmpty();
    }

    @Override
    public T next() {
        Model next = (Model)this.current.get(this.index);
        ++this.index;
        if (this.index == this.current.size()) {
            this.index = 0;
            this.last = next;
            this.current = null;
        }
        return (T)next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

