/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import siena.PersistenceManager;
import siena.SienaException;
import siena.dbslayer.Connector;
import siena.dbslayer.JsonSerializer;
import siena.dbslayer.ReflectionUtil;
import siena.dbslayer.RequestMethod;
import siena.dbslayer.Serializer;
import siena.dbslayer.URLConnector;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

public abstract class AbstractRemotePersistenceManager
implements PersistenceManager {
    private Connector connector = null;
    private Serializer serializerInput = null;
    private Serializer serializerOutput = null;
    private boolean useMethodTunnelingByDefault = false;
    protected SienaLogger logger = SienaLoggerFactory.getLogger(AbstractRemotePersistenceManager.class);

    public AbstractRemotePersistenceManager(Properties properties) {
        String connectorImpl = properties.getProperty("connector");
        String serializerImplIN = null == properties.getProperty("serializer.input") ? properties.getProperty("serializer") : properties.getProperty("serializer.input");
        String serializerImplOUT = null == properties.getProperty("serializer.output") ? properties.getProperty("serializer") : properties.getProperty("serializer.output");
        this.connector = (Connector)Connector.class.cast(ReflectionUtil.getInstance(connectorImpl, URLConnector.class));
        this.connector.configure(properties);
        this.serializerInput = (Serializer)Serializer.class.cast(ReflectionUtil.getInstance(serializerImplIN, JsonSerializer.class));
        this.serializerOutput = null == properties.getProperty("serializer.output") ? (Serializer)Serializer.class.cast(ReflectionUtil.getInstance(serializerImplOUT, JsonSerializer.class)) : this.serializerInput;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setSerializerInput(Serializer serializerInput) {
        this.serializerInput = serializerInput;
    }

    public void setSerializerOutput(Serializer serializerOutput) {
        this.serializerOutput = serializerOutput;
    }

    protected Object send(Object request) {
        return this.sendPost(request);
    }

    protected Object sendMessageWithBody(Object request, Serializer serializerIN, Serializer serializerOUT, RequestMethod method, boolean useMethodTunneling) {
        Object response = null;
        try {
            this.connector.connect(method, useMethodTunneling);
            serializerIN.serialize(request, this.connector.getOutputStream());
            response = serializerOUT.deserialize(this.connector.getInputStream());
        }
        catch (IOException e) {
            this.logger.severe(e, e);
            throw new SienaException(e);
        }
        finally {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                this.logger.severe(e, e);
                throw new SienaException(e);
            }
        }
        return response;
    }

    protected Object sendMessageWithoutBody(Object request, Serializer serializerIN, Serializer serializerOUT, RequestMethod method, boolean useMethodTunneling) {
        Object response = null;
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        try {
            serializerIN.serialize(request, arrayOutputStream);
            this.connector.connect(method, useMethodTunneling, arrayOutputStream.toString().trim());
            response = serializerOUT.deserialize(this.connector.getInputStream());
        }
        catch (IOException e) {
            this.logger.severe(e, e);
            throw new SienaException(e);
        }
        finally {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                this.logger.severe(e, e);
                throw new SienaException(e);
            }
        }
        return response;
    }

    protected Object sendPost(Object request) {
        return this.sendPost(request, this.serializerInput, this.serializerOutput);
    }

    protected Object sendPost(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithBody(request, serializerIN, serializerOUT, RequestMethod.POST, this.isUseMethodTunnelingByDefault());
    }

    protected Object sendPut(Object request) {
        return this.sendPut(request, this.serializerInput, this.serializerOutput);
    }

    protected Object sendPut(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithBody(request, serializerIN, serializerOUT, RequestMethod.POST, this.isUseMethodTunnelingByDefault());
    }

    protected Object sendGet(Object request) {
        return this.sendGet(request, this.serializerInput, this.serializerOutput);
    }

    protected Object sendGet(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithoutBody(request, serializerIN, serializerOUT, RequestMethod.GET, this.isUseMethodTunnelingByDefault());
    }

    protected Object sendDelete(Object request) {
        return this.sendDelete(request, this.serializerInput, this.serializerOutput);
    }

    protected Object sendDelete(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithoutBody(request, serializerIN, serializerOUT, RequestMethod.DELETE, this.isUseMethodTunnelingByDefault());
    }

    public boolean isUseMethodTunnelingByDefault() {
        return this.useMethodTunnelingByDefault;
    }

    public void setUseMethodTunnelingByDefault(boolean useMethodTunnelingByDefault) {
        this.useMethodTunnelingByDefault = useMethodTunnelingByDefault;
    }
}

