/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import siena.AbstractPersistenceManager;
import siena.Model;
import siena.Query;
import siena.dbslayer.GenericSQLPlainStatementBuilder;
import siena.dbslayer.ModelHelper;
import siena.dbslayer.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSlayerPersistenceManager
extends AbstractPersistenceManager {
    private GenericSQLPlainStatementBuilder statementBuilder = new GenericSQLPlainStatementBuilder();
    private Map<Class<?>, ClassInfo> infoClasses = new HashMap();

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    public ClassInfo getClassInfo(Model model) {
        ClassInfo ci = this.infoClasses.get(model);
        if (ci == null) {
            ci = new ClassInfo(model);
            this.infoClasses.put(model.getClass(), ci);
        }
        return ci;
    }

    @Override
    public <T extends Model> Query<T> createQuery(Class<T> clazz) {
        return null;
    }

    @Override
    public void delete(Model model) {
        Map<String, String> fieldColumnIds = this.getClassInfo(model).getFieldColumnIds();
        List<String> keyColumns = this.createKeyColumns(model, fieldColumnIds);
        String deleteSQL = this.statementBuilder.createDelete(model, keyColumns);
    }

    private List<String> createKeyColumns(Model model, Map<String, String> fieldColumnIds) {
        ArrayList<String> keyColumns = new ArrayList<String>();
        Field field = null;
        StringBuilder builder = null;
        Object value = null;
        for (Map.Entry<String, String> fieldColumnIdEntry : fieldColumnIds.entrySet()) {
            field = ReflectionUtil.getField(model.getClass(), fieldColumnIdEntry.getKey());
            builder = new StringBuilder();
            builder.append(fieldColumnIdEntry.getValue()).append("=");
            value = ReflectionUtil.getValue(field, model);
            builder = field.getType() == CharSequence.class ? builder.append("'").append(value).append("'") : builder.append(value);
            keyColumns.add(builder.toString());
        }
        return keyColumns;
    }

    @Override
    public void get(Model obj) {
    }

    @Override
    public void init(Properties p) {
    }

    @Override
    public void insert(Model obj) {
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void update(Model obj) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassInfo {
        private Map<String, String> fieldColumnIds = new HashMap<String, String>();

        public ClassInfo(Model model) {
            this.fieldColumnIds = ModelHelper.getPropertyColumnNameIds(model);
        }

        public Map<String, String> getFieldColumnIds() {
            return this.fieldColumnIds;
        }
    }
}

