/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.util.List;
import siena.Model;
import siena.Util;
import siena.dbslayer.ModelHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSQLPlainStatementBuilder {
    public String createSelectAll(Model model) {
        StringBuilder builder = new StringBuilder();
        List<String> columnNames = null;
        String tableName = ModelHelper.getTableName(model.getClass());
        columnNames = ModelHelper.getColumnNames(model);
        builder.append("SELECT ");
        builder.append(Util.join(columnNames, ", "));
        builder.append(" FROM ").append(tableName);
        return builder.toString();
    }

    public String createSelect(Model model, List<String> keyColumns, String baseSelectSQL) {
        StringBuilder selectSQL = new StringBuilder(null != baseSelectSQL ? baseSelectSQL : this.createSelectAll(model));
        selectSQL.append(" WHERE ");
        selectSQL.append(Util.join(keyColumns, " AND "));
        return selectSQL.toString();
    }

    public String createInsert(Model model, List<String> insertColumns) {
        StringBuilder insertSQL = new StringBuilder("INSERT INTO ");
        String tableName = ModelHelper.getTableName(model.getClass());
        insertSQL.append(tableName).append(" SET ").append(Util.join(insertColumns, ", "));
        return insertSQL.toString();
    }

    public String createDelete(Model model, List<String> keyColumns) {
        String tableName = ModelHelper.getTableName(model.getClass());
        StringBuilder deleteSQL = new StringBuilder("DELETE FROM ");
        deleteSQL.append(tableName).append(" WHERE ").append(Util.join(keyColumns, " AND "));
        return deleteSQL.toString();
    }

    public String createUpdate(Model model, List<String> updateColumns, List<String> keyColumns) {
        String tableName = ModelHelper.getTableName(model.getClass());
        StringBuilder updateSQL = new StringBuilder("UPDATE ");
        updateSQL.append(tableName).append(" SET ");
        updateSQL.append(Util.join(updateColumns, ", "));
        updateSQL.append(" WHERE ");
        updateSQL.append(Util.join(keyColumns, " AND "));
        return updateSQL.toString();
    }
}

