/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import siena.SienaException;
import siena.dbslayer.Connector;
import siena.dbslayer.HttpClient;
import siena.dbslayer.RequestMethod;
import siena.dbslayer.Serializer;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

public class HttpClientImpl
implements HttpClient {
    private Connector connector = null;
    private boolean useMethodTunnelingByDefault = false;
    protected SienaLogger logger = SienaLoggerFactory.getLogger(HttpClientImpl.class);

    public HttpClientImpl(Connector connector) {
        this.connector = connector;
    }

    public Object sendDelete(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithoutBody(request, serializerIN, serializerOUT, RequestMethod.DELETE, this.isUseMethodTunnelingByDefault());
    }

    public Object sendGet(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithoutBody(request, serializerIN, serializerOUT, RequestMethod.GET, this.isUseMethodTunnelingByDefault());
    }

    public Object sendPost(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithBody(request, serializerIN, serializerOUT, RequestMethod.POST, this.isUseMethodTunnelingByDefault());
    }

    public Object sendPut(Object request, Serializer serializerIN, Serializer serializerOUT) {
        return this.sendMessageWithBody(request, serializerIN, serializerOUT, RequestMethod.POST, this.isUseMethodTunnelingByDefault());
    }

    protected Object sendMessageWithoutBody(Object request, Serializer serializerIN, Serializer serializerOUT, RequestMethod method, boolean useMethodTunneling) {
        Object response = null;
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        try {
            serializerIN.serialize(request, arrayOutputStream);
            this.connector.connect(method, useMethodTunneling, arrayOutputStream.toString().trim());
            response = serializerOUT.deserialize(this.connector.getInputStream());
        }
        catch (IOException e) {
            this.logger.severe(e, e);
            throw new SienaException(e);
        }
        finally {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                this.logger.severe(e, e);
                throw new SienaException(e);
            }
        }
        return response;
    }

    protected Object sendMessageWithBody(Object request, Serializer serializerIN, Serializer serializerOUT, RequestMethod method, boolean useMethodTunneling) {
        Object response = null;
        try {
            this.connector.connect(method, useMethodTunneling);
            serializerIN.serialize(request, this.connector.getOutputStream());
            response = serializerOUT.deserialize(this.connector.getInputStream());
        }
        catch (IOException e) {
            this.logger.severe(e, e);
            throw new SienaException(e);
        }
        finally {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                this.logger.severe(e, e);
                throw new SienaException(e);
            }
        }
        return response;
    }

    public boolean isUseMethodTunnelingByDefault() {
        return this.useMethodTunnelingByDefault;
    }

    public void setUseMethodTunnelingByDefault(boolean useMethodTunnelingByDefault) {
        this.useMethodTunnelingByDefault = useMethodTunnelingByDefault;
    }
}

