/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import siena.Json;
import siena.dbslayer.Serializer;

public class JsonSerializer
implements Serializer {
    public Object deserialize(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Json json = Json.load(reader);
        return JsonSerializer.fromJson(json);
    }

    public void serialize(Object object, OutputStream out) throws IOException {
        Document document = (Document)Document.class.cast(object);
        Json json = JsonSerializer.toJson(document);
        json.write(new OutputStreamWriter(out));
    }

    private static Json toJson(Document doc) {
        Json json = Json.map();
        Element root = doc.getRootElement();
        Json map = Json.map();
        json.put(root.getName(), map);
        JsonSerializer.toJson(root, map);
        return json;
    }

    private static void toJson(Element element, Json e) {
        List elements = element.elements();
        if (elements.isEmpty()) {
            if (element.hasContent()) {
                e.put("@", element.getText());
            }
        } else {
            Json map = Json.map();
            e.put("@", map);
            for (Element elem : elements) {
                Json j = Json.map();
                map.put(elem.getName(), j);
                JsonSerializer.toJson(elem, j);
            }
        }
        List attributes = element.attributes();
        for (Attribute attr : attributes) {
            e.put(attr.getName(), attr.getValue());
        }
    }

    private static Document fromJson(Json json) {
        String root = json.keys().iterator().next();
        Document doc = DocumentHelper.createDocument();
        JsonSerializer.fromJson(json.get(root), doc.addElement(root));
        return doc;
    }

    private static void fromJson(Json json, Element element) {
        Set<String> keys = json.keys();
        for (String key : keys) {
            if ("@".equals(key)) {
                Json value = json.get(key);
                if (value.isString()) {
                    element.setText(value.str());
                    continue;
                }
                Set<String> ks = value.keys();
                for (String k : ks) {
                    Element child = element.addElement(k);
                    JsonSerializer.fromJson(value.get(k), child);
                }
                continue;
            }
            element.addAttribute(key, json.get(key).str());
        }
    }

    public static void main(String[] args) {
        Document doc = DocumentHelper.createDocument();
        doc.addElement("root").addAttribute("foo", "bar").addAttribute("foobar", "baz").addElement("child").addAttribute("x", "y").addElement("grandchild").addAttribute("a", "b").setText("foo bar");
        System.out.println("Original document");
        System.out.println(doc.asXML());
        System.out.println();
        Json json = JsonSerializer.toJson(doc);
        System.out.println("As Json");
        System.out.println(json);
        System.out.println();
        Document result = JsonSerializer.fromJson(json);
        System.out.println("Back to document");
        System.out.println(result.asXML());
        System.out.println();
    }
}

