/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import siena.Column;
import siena.Id;
import siena.Model;
import siena.Table;
import siena.dbslayer.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHelper {
    public static boolean isId(Field field) {
        return ReflectionUtil.hasAnnotation(field, Id.class);
    }

    public static Map<String, String> getPropertyColumnNameIds(Model model) {
        HashMap<String, String> propColumns = new HashMap<String, String>();
        Collection<Field> fields = ReflectionUtil.getFields(model.getClass());
        for (Field field : fields) {
            if (!ModelHelper.isId(field)) continue;
            propColumns.put(field.getName(), ModelHelper.getColumnName(field));
        }
        return propColumns;
    }

    public static String getColumnName(Field field) {
        String columnName = field.getName();
        Column column = field.getAnnotation(Column.class);
        if (null != column) {
            columnName = column.value()[0];
        }
        return columnName;
    }

    public static String getTableName(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        return t == null ? clazz.getName() : t.value();
    }

    public static Collection<String> getColumnNames(Field field) {
        List<String> columnNames = null;
        Column c = field.getAnnotation(Column.class);
        if (c != null) {
            columnNames = Arrays.asList(c.value());
        }
        return columnNames;
    }

    public static List<String> getColumnNames(Model model) {
        ArrayList<String> fieldList = new ArrayList<String>();
        Collection<Field> fields = ReflectionUtil.getFields(model.getClass());
        Collection<String> columnNames = null;
        for (Field field : fields) {
            columnNames = ModelHelper.getColumnNames(field);
            if (null != columnNames) {
                fieldList.addAll(columnNames);
                continue;
            }
            fieldList.add(field.getName());
        }
        return fieldList;
    }
}

