/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import siena.SienaException;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static ClassLoader classLoader = null;
    private static SienaLogger logger = SienaLoggerFactory.getLogger(ReflectionUtil.class);

    public static void setClassLoader(ClassLoader classLoader) {
        if (null != classLoader) {
            ReflectionUtil.classLoader = classLoader;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new SienaException(e);
        }
        catch (NoSuchFieldException e) {
            throw new SienaException(e);
        }
        return field;
    }

    public static Collection<Field> getFields(Class<?> clazz) {
        Field[] fields;
        HashSet<Field> fieldSet = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() == Class.class) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }

    public static Object getValue(Field field, Object bean) {
        Object value = null;
        if (null != bean) {
            try {
                field.setAccessible(true);
                value = field.get(bean);
            }
            catch (Exception e) {
                logger.severe(e, e);
                throw new SienaException(e);
            }
        }
        return value;
    }

    public static <T extends Annotation> boolean hasAnnotation(Field field, Class<T> annotationClass) {
        return null != field.getAnnotation(annotationClass);
    }

    public static boolean hasSuperClass(Class<?> clazz, Class<?> superClass) {
        return clazz.getSuperclass() == superClass;
    }

    public static Object getInstance(String className, Class<?> defaultClass) {
        Object instance = null;
        try {
            Object object;
            if (null != className) {
                instance = ReflectionUtil.getInstance(className);
                object = instance;
            } else {
                object = defaultClass.newInstance();
            }
            instance = object;
        }
        catch (InstantiationException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
        catch (IllegalAccessException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
        return instance;
    }

    public static Object getInstance(String className) {
        Class<?> clazz = null;
        Object object = null;
        try {
            clazz = ReflectionUtil.loadClass(className);
            object = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
        catch (InstantiationException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
        catch (IllegalAccessException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
        return object;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return classLoader == null ? Class.forName(className) : Class.forName(className, true, classLoader);
    }
}

