/*
 * Decompiled with CFR 0.152.
 */
package siena.dbslayer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import siena.SienaException;
import siena.dbslayer.Connector;
import siena.dbslayer.RequestMethod;

public class URLConnector
implements Connector {
    private URL backend;
    private HttpURLConnection connection;

    public void configure(Properties p) {
        try {
            this.backend = new URL(p.getProperty("backend"));
        }
        catch (MalformedURLException e) {
            throw new SienaException(e);
        }
    }

    public void close() throws IOException {
    }

    public void connect(RequestMethod method, boolean useMethodTunneling) throws IOException {
        this.connect(method, useMethodTunneling, "");
    }

    public void connect(RequestMethod method, boolean useMethodTunneling, Object addionalParameters) throws IOException {
        URL url = this.backend;
        if (null != addionalParameters && addionalParameters.toString().trim().length() > 0) {
            url = new URL(url, addionalParameters.toString());
        }
        this.connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
        this.connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setInstanceFollowRedirects(true);
        if (useMethodTunneling) {
            this.connection.setRequestMethod(RequestMethod.POST.getName());
            this.connection.setRequestProperty("X-HTTP-Method-Override", method.getName());
        } else {
            this.connection.setRequestMethod(method.getName());
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public void connect() throws IOException {
        this.connect(RequestMethod.POST, false);
    }
}

