/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.gae.GaeQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaePersistenceManager
extends AbstractPersistenceManager {
    private DatastoreService ds;

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public <T extends Model> Query<T> createQuery(Class<T> clazz) {
        return new GaeQuery<T>(this, clazz);
    }

    @Override
    public void delete(Model obj) {
        this.ds.delete(new Key[]{this.getKey(obj)});
    }

    @Override
    public void get(Model obj) {
        Key key = this.getKey(obj);
        try {
            Entity entity = this.ds.get(key);
            this.fillModel(obj, entity);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void init(Properties p) {
        this.ds = DatastoreServiceFactory.getDatastoreService();
    }

    @Override
    public void insert(Model obj) {
        Class<?> clazz = obj.getClass();
        Entity entity = new Entity(ClassInfo.getClassInfo(clazz).tableName);
        this.fillEntity(obj, entity);
        this.ds.put(entity);
        try {
            ClassInfo.getIdField(clazz).set(obj, entity.getKey().getId());
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void update(Model obj) {
        try {
            Entity entity = this.ds.get(this.getKey(obj));
            this.fillEntity(obj, entity);
            this.ds.put(entity);
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public Long getIdValue(Model obj) {
        try {
            return (Long)ClassInfo.getIdField(obj.getClass()).get(obj);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public Key getKey(Model obj) {
        return KeyFactory.createKey((String)ClassInfo.getClassInfo(obj.getClass()).tableName, (long)this.getIdValue(obj));
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private void fillEntity(Model obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            String s;
            String property = ClassInfo.getColumnNames(field)[0];
            Object value = this.readField(obj, field);
            Class<?> fieldClass = field.getType();
            if (ClassInfo.isModel(fieldClass)) {
                if (value == null) {
                    entity.setProperty(property, null);
                    continue;
                }
                Key key = this.getKey((Model)value);
                entity.setProperty(property, (Object)key);
                continue;
            }
            if (value instanceof String && value != null && (s = (String)value).length() > 500) {
                value = new Text(s);
            }
            entity.setProperty(property, value);
        }
    }

    private void fillModel(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            field.setAccessible(true);
            String property = ClassInfo.getColumnNames(field)[0];
            try {
                Class<?> fieldClass = field.getType();
                if (ClassInfo.isModel(fieldClass)) {
                    Key key = (Key)entity.getProperty(property);
                    if (key == null) continue;
                    Object value = fieldClass.newInstance();
                    Field id = ClassInfo.getIdField(fieldClass);
                    id.set(value, key.getId());
                    field.set(obj, value);
                    continue;
                }
                this.setFromObject(obj, field, entity.getProperty(property));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    private void setFromObject(Object object, Field f, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (value instanceof Text) {
            value = ((Text)value).getValue();
        }
        Util.setFromObject(object, f, value);
    }

    protected DatastoreService getDatastoreService() {
        return this.ds;
    }

    protected <T> List<T> mapEntities(List<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>(entities.size());
        for (Entity entity : entities) {
            try {
                T obj = clazz.newInstance();
                this.fillModel(obj, entity);
                list.add(obj);
                id.set(obj, entity.getKey().getId());
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }
}

