/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import siena.ClassInfo;
import siena.DateTime;
import siena.IterableQuery;
import siena.Model;
import siena.Query;
import siena.QueryListener;
import siena.SienaException;
import siena.SimpleDate;
import siena.Time;
import siena.Util;
import siena.jdbc.JdbcPersistenceManager;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcQuery<T extends Model>
implements Query<T> {
    protected static SienaLogger logger = SienaLoggerFactory.getLogger(JdbcQuery.class);
    private Class<T> clazz;
    private JdbcPersistenceManager pm;
    private List<String> filter;
    private List<String> order;
    private List<Object> parameters;
    private QueryListener listener;
    private PreparedStatement statement = null;
    private String sql;
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "="};

    private JdbcQuery() {
    }

    public JdbcQuery(Class<T> clazz, JdbcPersistenceManager pm, QueryListener listener) {
        this.clazz = clazz;
        this.pm = pm;
        this.listener = listener;
        if (listener != null) {
            listener.kind(clazz);
        }
    }

    @Override
    public List<T> fetch() {
        return this.fetch("", "");
    }

    @Override
    public List<T> fetch(int limit) {
        return this.fetch("", " LIMIT " + limit);
    }

    @Override
    public List<T> fetch(int limit, int offset) {
        return this.fetch("", " LIMIT " + offset + ", " + limit);
    }

    @Override
    public Iterable<T> iter(String field, int max) {
        return new IterableQuery(this, max, field);
    }

    @Override
    public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
        if (this.listener != null) {
            // empty if block
        }
        if (this.filter == null) {
            this.filter = new ArrayList<String>();
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        try {
            ArrayList<String> cols = new ArrayList<String>();
            for (String field : fieldNames) {
                String[] columns;
                Field f = this.clazz.getDeclaredField(field);
                for (String string : columns = ClassInfo.getColumnNames(f)) {
                    cols.add(string);
                }
            }
            if (inBooleanMode) {
                this.filter.add("MATCH(" + Util.join(cols, ",") + ") AGAINST(? IN BOOLEAN MODE)");
            } else {
                this.filter.add("MATCH(" + Util.join(cols, ",") + ") AGAINST(?)");
            }
            this.parameters.add(match);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return this;
    }

    @Override
    public JdbcQuery<T> filter(String field, Object value) {
        if (this.listener != null) {
            this.listener.filter(field, value);
        }
        if (this.filter == null) {
            this.filter = new ArrayList<String>();
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        String op = "=";
        for (String operator : supportedOperators) {
            if (!field.endsWith(operator)) continue;
            op = operator;
            field = field.substring(0, field.length() - operator.length());
            break;
        }
        field = field.trim();
        try {
            Field f = this.clazz.getDeclaredField(field);
            String[] columns = ClassInfo.getColumnNames(f);
            if (this.pm.isModel(f.getType())) {
                if (!op.equals("=")) {
                    throw new SienaException("Unsuuported operator for relationship: " + op);
                }
                JdbcPersistenceManager.JdbcClassInfo classInfo = this.pm.getClassInfo(f.getType());
                int i = 0;
                this.pm.checkForeignKeyMapping(classInfo.keys, columns, this.clazz, f);
                for (Field key : classInfo.keys) {
                    if (value == null) {
                        this.filter.add(columns[i++] + " IS NULL");
                        continue;
                    }
                    this.filter.add(columns[i++] + "=?");
                    key.setAccessible(true);
                    Object o = key.get(value);
                    this.parameters.add(o);
                }
            } else if (value == null && op.equals("=")) {
                this.filter.add(columns[0] + " IS NULL");
            } else {
                this.filter.add(columns[0] + op + "?");
                if (value == null) {
                    this.parameters.add(0);
                } else {
                    if (value instanceof java.util.Date) {
                        value = this.translateDate(f, (java.util.Date)value);
                    }
                    this.parameters.add(value);
                }
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return this;
    }

    private Object translateDate(Field f, java.util.Date value) {
        long t = value.getTime();
        SimpleDate simpleDate = f.getAnnotation(SimpleDate.class);
        if (simpleDate != null) {
            return new Date(t);
        }
        DateTime dateTime = f.getAnnotation(DateTime.class);
        if (dateTime != null) {
            return new Timestamp(t);
        }
        Time time = f.getAnnotation(Time.class);
        if (time != null) {
            return new java.sql.Time(t);
        }
        return new Timestamp(t);
    }

    @Override
    public T get() {
        List<T> list = this.fetch("", " LIMIT 1");
        if (list.isEmpty()) {
            return null;
        }
        return (T)((Model)list.get(0));
    }

    @Override
    public JdbcQuery<T> order(String field) {
        if (this.listener != null) {
            this.listener.order(field);
        }
        if (this.order == null) {
            this.order = new ArrayList<String>();
        }
        if (field.startsWith("-")) {
            String[] columns;
            field = field.substring(1);
            for (String column : columns = this.pm.getColumnNames(this.clazz, field)) {
                this.order.add(column + " DESC");
            }
        } else {
            String[] columns;
            for (String column : columns = this.pm.getColumnNames(this.clazz, field)) {
                this.order.add(column);
            }
        }
        return this;
    }

    private List<T> fetch(String prefix, String suffix) {
        if (this.listener != null) {
            this.listener.execute();
        }
        this.buildSql(prefix, suffix);
        try {
            this.createStatement();
            return this.processResultSet();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    private void buildSql(String prefix, String suffix) {
        JdbcPersistenceManager.JdbcClassInfo classInfo = this.pm.getClassInfo(this.clazz);
        this.buildSql(prefix, suffix, classInfo.baseSelectSQL);
    }

    private void buildSql(String prefix, String suffix, String baseSql) {
        this.sql = prefix + baseSql;
        if (this.filter != null && !this.filter.isEmpty()) {
            this.sql = this.sql + " WHERE ";
            this.sql = this.sql + Util.join(this.filter, " AND ");
        }
        if (this.order != null && !this.order.isEmpty()) {
            this.sql = this.sql + " ORDER BY ";
            this.sql = this.sql + Util.join(this.order, ", ");
        }
        this.sql = this.sql + suffix;
    }

    private void createStatement() throws SQLException {
        this.statement = this.pm.getConnection().prepareStatement(this.sql);
        if (this.parameters == null || this.parameters.isEmpty()) {
            return;
        }
        int i = 1;
        for (Object parameter : this.parameters) {
            this.statement.setObject(i++, parameter);
        }
    }

    private List<T> processResultSet() throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.statement.executeQuery();
            List<T> list = this.pm.mapList(this.clazz, rs);
            return list;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
        finally {
            this.pm.closeResultSet(rs);
            this.pm.closeStatement(this.statement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readInt(String prefix, String suffix, String baseSql) {
        this.buildSql(prefix, suffix, baseSql);
        try {
            this.createStatement();
            ResultSet rs = null;
            try {
                rs = this.statement.executeQuery();
                rs.next();
                int n = rs.getInt(1);
                return n;
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
            finally {
                this.pm.closeResultSet(rs);
                this.pm.closeStatement(this.statement);
            }
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public int count() {
        return this.readInt("", "", "SELECT COUNT(*) FROM " + ClassInfo.getClassInfo(this.clazz).tableName);
    }

    @Override
    public int count(int limit) {
        return this.fetch(limit).size();
    }

    @Override
    public int count(int limit, int offset) {
        return this.fetch(limit, offset).size();
    }

    @Override
    public JdbcQuery<T> clone() {
        JdbcQuery<T> t = new JdbcQuery<T>();
        t.clazz = this.clazz;
        t.pm = this.pm;
        if (this.filter != null) {
            t.filter = new ArrayList<String>(this.filter);
        }
        if (this.order != null) {
            t.order = new ArrayList<String>(this.order);
        }
        if (this.parameters != null) {
            t.parameters = new ArrayList<Object>(this.parameters);
        }
        t.listener = null;
        return t;
    }
}

