/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import siena.SienaException;
import siena.jdbc.AbstractConnectionManager;

public class ThreadedConnectionManager
extends AbstractConnectionManager {
    private String url;
    private String user;
    private String pass;
    private String jndi;
    private DataSource dataSource;
    private ThreadLocal<Connection> currentConnection = new ThreadLocal();

    public void init(Properties p) {
        String driver = p.getProperty("driver");
        this.url = p.getProperty("url");
        this.user = p.getProperty("user");
        this.pass = p.getProperty("password");
        this.jndi = p.getProperty("jndi");
        if (this.jndi == null) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new SienaException("Error while loading JDBC driver", e);
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndi);
        }
        catch (Exception e) {
            throw new SienaException("Error while looking up for JNDI resource: " + this.jndi, e);
        }
    }

    public Connection getConnection() {
        if (this.dataSource != null) {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        Connection c = this.currentConnection.get();
        if (c == null) {
            try {
                c = DriverManager.getConnection(this.url, this.user, this.pass);
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
            this.currentConnection.set(c);
        }
        return c;
    }

    public void closeConnection() {
        try {
            Connection c = this.currentConnection.get();
            if (c != null) {
                this.currentConnection.remove();
                c.close();
            }
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

