/*
 * Decompiled with CFR 0.152.
 */
package siena.remote;

import java.io.IOException;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import siena.AbstractPersistenceManager;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.remote.Common;
import siena.remote.Connector;
import siena.remote.RemoteQuery;
import siena.remote.Serializer;
import siena.remote.URLConnector;
import siena.remote.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePersistenceManager
extends AbstractPersistenceManager {
    private Connector connector;
    private Serializer serializer;
    private String key;

    @Override
    public void init(Properties p) {
        String connectorImpl = p.getProperty("connector");
        if (connectorImpl != null) {
            try {
                this.connector = (Connector)Class.forName(connectorImpl).newInstance();
            }
            catch (Exception e) {
                throw new SienaException("Error while instantiating connector: " + connectorImpl, e);
            }
        } else {
            this.connector = new URLConnector();
        }
        String serializerImpl = p.getProperty("serializer");
        if (serializerImpl != null) {
            try {
                this.serializer = (Serializer)Class.forName(serializerImpl).newInstance();
            }
            catch (Exception e) {
                throw new SienaException("Error while instantiating serializer: " + serializerImpl, e);
            }
        } else {
            this.serializer = new XmlSerializer();
        }
        this.key = p.getProperty("key");
        this.connector.configure(p);
    }

    @Override
    public <T extends Model> Query<T> createQuery(Class<T> clazz) {
        return new RemoteQuery(this, clazz);
    }

    @Override
    public void delete(Model obj) {
        this.simpleRequest("delete", obj, true);
    }

    @Override
    public void get(Model obj) {
        this.simpleRequest("get", obj, true);
    }

    @Override
    public void insert(Model obj) {
        this.simpleRequest("insert", obj, false);
    }

    @Override
    public void update(Model obj) {
        this.simpleRequest("update", obj, false);
    }

    protected Document createRequest(String name) {
        Document d = DocumentHelper.createDocument();
        Element root = d.addElement(name);
        if (this.key != null) {
            String time = Long.toString(System.currentTimeMillis());
            root.addAttribute("time", time);
            root.addAttribute("hash", Util.sha1(time + this.key));
        }
        return d;
    }

    private Document createRequest(String name, Model entity, boolean ids) {
        Document d = this.createRequest(name);
        Common.fillRequestElement(entity, d.getRootElement(), ids);
        return d;
    }

    private void simpleRequest(String name, Model entity, boolean ids) {
        Document request = this.createRequest(name, entity, ids);
        Document response = this.send(request);
        Element root = response.getRootElement();
        String rootName = root.getName();
        if ("error".equals(rootName)) {
            throw new SienaException(root.attributeValue("class") + " " + root.getText());
        }
        if ("object".equals(rootName)) {
            Common.parseEntity(entity, root, entity.getClass().getClassLoader());
        }
    }

    protected Document send(Document request) {
        try {
            this.connector.connect();
            this.serializer.serialize(request, this.connector.getOutputStream());
            Document response = this.serializer.deserialize(this.connector.getInputStream());
            this.connector.close();
            return response;
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }
}

