/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.sdb.ws.Item;
import siena.sdb.ws.SimpleDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdbPersistenceManager
extends AbstractPersistenceManager {
    private SimpleDB ws;

    @Override
    public void init(Properties p) {
        String awsAccessKeyId = p.getProperty("awsAccessKeyId");
        String awsSecretAccessKey = p.getProperty("awsSecretAccessKey");
        if (awsAccessKeyId == null || awsSecretAccessKey == null) {
            throw new SienaException("Both awsAccessKeyId and awsSecretAccessKey properties must be set");
        }
        this.ws = new SimpleDB(awsAccessKeyId, awsSecretAccessKey);
    }

    @Override
    public <T extends Model> Query<T> createQuery(Class<T> clazz) {
        return null;
    }

    @Override
    public void delete(Model obj) {
        this.ws.deleteAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void get(Model obj) {
        Item item = this.ws.getAttributes((String)this.getDomainName(obj.getClass()), (String)this.getIdValue((Model)obj)).item;
        this.fillModel(item, obj);
    }

    @Override
    public void insert(Model obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void update(Model obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    public String getIdValue(Model obj) {
        try {
            return (String)ClassInfo.getIdField(obj.getClass()).get(obj);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected String getDomainName(Class<?> clazz) {
        return ClassInfo.getClassInfo(clazz).tableName;
    }

    private String getAttributeName(Field field) {
        return ClassInfo.getColumnNames(field)[0];
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private Item toItem(Model obj) {
        Item item = new Item();
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            item.add(this.getAttributeName(field), Util.toString(field, obj));
        }
        Field id = ClassInfo.getIdField(clazz);
        String name = (String)this.readField(obj, id);
        if (name == null) {
            try {
                name = UUID.randomUUID().toString();
                id.set(obj, name);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        item.name = name;
        return item;
    }

    private void fillModel(Item item, Model obj) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            List<String> values = item.attributes.get(this.getAttributeName(field));
            if (values == null || values.isEmpty()) continue;
            try {
                Util.setFromString(obj, field, values.get(0));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Field id = ClassInfo.getIdField(clazz);
        item.name = (String)this.readField(obj, id);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public void rollbackTransaction() {
    }
}

