/*
 * Decompiled with CFR 0.152.
 */
package siena.base.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import siena.Json;
import siena.PersistenceManager;
import siena.Query;
import siena.base.test.Address;
import siena.base.test.AutoInc;
import siena.base.test.Contact;
import siena.base.test.DataTypes;
import siena.base.test.Discovery;
import siena.base.test.MultipleKeys;
import siena.base.test.Person;

public abstract class BaseTest
extends TestCase {
    private PersistenceManager pm;
    private static Person TESLA = new Person("Nikola", "Tesla", "Smiljam", 1);
    private static Person CURIE = new Person("Marie", "Curie", "Warsaw", 2);
    private static Person EINSTEIN = new Person("Albert", "Einstein", "Ulm", 3);

    public abstract PersistenceManager createPersistenceManager(List<Class<?>> var1) throws Exception;

    public abstract boolean supportsAutoincrement();

    public abstract boolean supportsMultipleKeys();

    public abstract boolean mustFilterToOrder();

    public Query<Person> queryPersonOrderBy(String order, Object value, boolean desc) {
        Query<Person> query = this.pm.createQuery(Person.class);
        if (this.mustFilterToOrder()) {
            query = query.filter(String.valueOf(order) + ">", value);
        }
        return query.order(desc ? "-" + order : order);
    }

    public void testCount() {
        BaseTest.assertEquals((int)3, (int)this.pm.createQuery(Person.class).count());
    }

    public void testFetch() {
        List<Person> people = this.queryPersonOrderBy("n", 0, false).fetch();
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)3, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(1));
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(2));
    }

    public void testFetchOrder() {
        List<Person> people = this.queryPersonOrderBy("firstName", "", false).fetch();
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)3, (int)people.size());
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(0));
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(1));
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(2));
    }

    public void testFetchOrderDesc() {
        List<Person> people = this.queryPersonOrderBy("lastName", "", true).fetch();
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)3, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(1));
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(2));
    }

    public void testFilterEqual() {
        Person person = this.pm.createQuery(Person.class).filter("firstName", "Albert").get();
        BaseTest.assertNotNull((Object)person);
        BaseTest.assertEquals((Object)EINSTEIN, (Object)person);
    }

    public void testFilterOperator() {
        List<Person> people = this.pm.createQuery(Person.class).filter("n<", 3).order("n").fetch();
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)2, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(1));
    }

    public void testCountFilter() {
        BaseTest.assertEquals((int)2, (int)this.pm.createQuery(Person.class).filter("n<", 3).count());
    }

    public void testFetchLimit() {
        List<Person> people = this.queryPersonOrderBy("n", 0, false).fetch(1);
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)1, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
    }

    public void testCountLimit() {
        BaseTest.assertEquals((int)1, (int)this.pm.createQuery(Person.class).filter("n<", 3).count(1));
    }

    public void testFetchLimitOffset() {
        Query<Person> query = this.queryPersonOrderBy("n", 0, false);
        query.fetch(1);
        List<Person> people = query.fetch(2, query.nextOffset());
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)2, (int)people.size());
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(0));
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(1));
    }

    public void testCountLimitOffset() {
        Query<Person> query = this.queryPersonOrderBy("n", 0, false);
        query.fetch(1);
        BaseTest.assertEquals((int)2, (int)query.count(2, query.nextOffset()));
    }

    public void testInsert() {
        Person maxwell = new Person();
        maxwell.firstName = "James Clerk";
        maxwell.lastName = "Maxwell";
        maxwell.city = "Edinburgh";
        maxwell.n = 4;
        this.pm.insert(maxwell);
        BaseTest.assertNotNull((Object)maxwell.id);
        List<Person> people = this.queryPersonOrderBy("n", 0, false).fetch();
        BaseTest.assertEquals((int)4, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
        BaseTest.assertEquals((Object)CURIE, (Object)people.get(1));
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(2));
        BaseTest.assertEquals((Object)maxwell, (Object)people.get(3));
    }

    public void testGet() {
        Person curie = this.getPerson(BaseTest.CURIE.id);
        BaseTest.assertEquals((Object)CURIE, (Object)curie);
    }

    public void testUpdate() {
        Person curie = this.getPerson(BaseTest.CURIE.id);
        curie.lastName = "Sklodowska\u2013Curie";
        this.pm.update(curie);
        Person curie2 = this.getPerson(BaseTest.CURIE.id);
        BaseTest.assertEquals((Object)curie2, (Object)curie);
    }

    public void testDelete() {
        Person curie = this.getPerson(BaseTest.CURIE.id);
        this.pm.delete(curie);
        List<Person> people = this.queryPersonOrderBy("n", 0, false).fetch();
        BaseTest.assertNotNull(people);
        BaseTest.assertEquals((int)2, (int)people.size());
        BaseTest.assertEquals((Object)TESLA, (Object)people.get(0));
        BaseTest.assertEquals((Object)EINSTEIN, (Object)people.get(1));
    }

    public void testIter1() {
        Iterable<Person> people = this.pm.createQuery(Person.class).iter("n", 1);
        BaseTest.assertNotNull(people);
        Person[] array = new Person[]{TESLA, CURIE, EINSTEIN};
        int i = 0;
        for (Person PersonIntKey : people) {
            BaseTest.assertEquals((Object)array[i], (Object)PersonIntKey);
            ++i;
        }
    }

    public void testIter2() {
        Iterable<Person> people = this.pm.createQuery(Person.class).iter("n", 2);
        BaseTest.assertNotNull(people);
        Person[] array = new Person[]{TESLA, CURIE, EINSTEIN};
        int i = 0;
        for (Person PersonIntKey : people) {
            BaseTest.assertEquals((Object)array[i], (Object)PersonIntKey);
            ++i;
        }
    }

    public void testOrderId() {
        List<Person> people = this.queryPersonOrderBy("id", "", false).fetch();
        BaseTest.assertEquals((int)3, (int)people.size());
    }

    public void testGetObjectNotFound() {
        try {
            this.getPerson("");
            BaseTest.fail();
        }
        catch (Exception e) {
            System.out.println("Everything is OK");
        }
        BaseTest.assertNull((Object)this.pm.createQuery(Person.class).filter("firstName", "John").get());
    }

    public void testDeleteObjectNotFound() {
        try {
            Person p = new Person();
            this.pm.delete(p);
            BaseTest.fail();
        }
        catch (Exception e) {
            System.out.println("Everything is OK");
        }
    }

    public void testAutoincrement() {
        if (!this.supportsAutoincrement()) {
            return;
        }
        AutoInc first = new AutoInc();
        first.name = "first";
        this.pm.insert(first);
        BaseTest.assertTrue((first.id > 0L ? 1 : 0) != 0);
        AutoInc second = new AutoInc();
        second.name = "second";
        this.pm.insert(second);
        BaseTest.assertTrue((second.id > 0L ? 1 : 0) != 0);
        BaseTest.assertTrue((second.id > first.id ? 1 : 0) != 0);
    }

    public void testRelationship() {
        Discovery radioactivity = new Discovery("Radioactivity", CURIE);
        Discovery relativity = new Discovery("Relativity", EINSTEIN);
        Discovery teslaCoil = new Discovery("Tesla Coil", TESLA);
        Discovery foo = new Discovery(null, TESLA);
        this.pm.insert(radioactivity);
        this.pm.insert(relativity);
        this.pm.insert(teslaCoil);
        this.pm.insert(foo);
        Discovery relativity2 = this.pm.createQuery(Discovery.class).filter("discoverer", EINSTEIN).get();
        BaseTest.assertTrue((boolean)relativity.name.equals(relativity2.name));
        Discovery foo2 = this.pm.createQuery(Discovery.class).filter("name", null).get();
        BaseTest.assertTrue((boolean)foo.id.equals(foo2.id));
    }

    public void testMultipleKeys() {
        if (!this.supportsMultipleKeys()) {
            return;
        }
        MultipleKeys a = new MultipleKeys();
        a.id1 = "aid1";
        a.id2 = "aid2";
        a.name = "first";
        a.parent = null;
        this.pm.insert(a);
        MultipleKeys b = new MultipleKeys();
        b.id1 = "bid1";
        b.id2 = "bid2";
        b.name = "second";
        b.parent = null;
        this.pm.insert(b);
        b.parent = a;
        this.pm.update(b);
    }

    public void testDataTypesNull() {
        DataTypes dataTypes = new DataTypes();
        this.pm.insert(dataTypes);
        this.assertEqualsDataTypes(dataTypes, this.pm.createQuery(DataTypes.class).get());
    }

    public void testDataTypesNotNull() {
        char[] c = new char[501];
        Arrays.fill(c, 'x');
        DataTypes dataTypes = new DataTypes();
        dataTypes.typeByte = 1;
        dataTypes.typeShort = (short)2;
        dataTypes.typeInt = 3;
        dataTypes.typeLong = 4L;
        dataTypes.typeFloat = 5.0f;
        dataTypes.typeDouble = 6.0;
        dataTypes.typeDate = new Date();
        dataTypes.typeString = "hello";
        dataTypes.typeLargeString = new String(c);
        dataTypes.typeJson = Json.map().put("foo", "bar");
        dataTypes.addresses = new ArrayList<Address>();
        dataTypes.addresses.add(new Address("Castellana", "Madrid"));
        dataTypes.addresses.add(new Address("Diagonal", "Barcelona"));
        dataTypes.contacts = new HashMap<String, Contact>();
        dataTypes.contacts.put("id1", new Contact("Somebody", Arrays.asList("foo", "bar")));
        this.pm.insert(dataTypes);
        this.pm.createQuery(DataTypes.class).filter("id", dataTypes.id).get();
        DataTypes same = this.pm.createQuery(DataTypes.class).get();
        this.assertEqualsDataTypes(dataTypes, same);
    }

    private void assertEqualsDataTypes(DataTypes dataTypes, DataTypes same) {
        BaseTest.assertEquals((String)dataTypes.id, (String)same.id);
        BaseTest.assertEquals((byte)dataTypes.typeByte, (byte)same.typeByte);
        BaseTest.assertEquals((short)dataTypes.typeShort, (short)same.typeShort);
        BaseTest.assertEquals((int)dataTypes.typeInt, (int)same.typeInt);
        BaseTest.assertEquals((long)dataTypes.typeLong, (long)same.typeLong);
        BaseTest.assertEquals((Object)Float.valueOf(dataTypes.typeFloat), (Object)Float.valueOf(same.typeFloat));
        BaseTest.assertEquals((Object)dataTypes.typeDouble, (Object)same.typeDouble);
        if (dataTypes.typeDate != null && same.typeDate != null) {
            BaseTest.assertEquals((long)(dataTypes.typeDate.getTime() / 1000L), (long)(same.typeDate.getTime() / 1000L));
        } else {
            BaseTest.assertNull((Object)dataTypes.typeDate);
            BaseTest.assertNull((Object)same.typeDate);
        }
        BaseTest.assertEquals((String)dataTypes.typeString, (String)same.typeString);
        BaseTest.assertEquals((String)dataTypes.typeLargeString, (String)same.typeLargeString);
        BaseTest.assertEquals((Object)dataTypes.typeJson, (Object)same.typeJson);
        if (dataTypes.addresses != null && same.addresses != null) {
            BaseTest.assertEquals((int)dataTypes.addresses.size(), (int)same.addresses.size());
            int size = dataTypes.addresses.size();
            int i = 0;
            while (i < size) {
                BaseTest.assertEquals((Object)dataTypes.addresses.get(i), (Object)same.addresses.get(i));
                ++i;
            }
        } else {
            BaseTest.assertNull(dataTypes.addresses);
            BaseTest.assertNull(same.addresses);
        }
        if (dataTypes.contacts != null && same.contacts != null) {
            BaseTest.assertEquals((int)dataTypes.contacts.size(), (int)same.contacts.size());
            for (String key : dataTypes.contacts.keySet()) {
                BaseTest.assertEquals((String)dataTypes.contacts.get((Object)key).name, (String)same.contacts.get((Object)key).name);
                List<String> a = dataTypes.contacts.get((Object)key).tags;
                List<String> b = same.contacts.get((Object)key).tags;
                BaseTest.assertEquals((int)a.size(), (int)b.size());
                for (String string : b) {
                    BaseTest.assertTrue((boolean)a.contains(string));
                }
            }
        } else {
            BaseTest.assertNull(dataTypes.contacts);
            BaseTest.assertNull(same.contacts);
        }
    }

    private Person getPerson(String id) {
        Person p = new Person();
        p.id = id;
        this.pm.get(p);
        return p;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArrayList classes = new ArrayList();
        classes.add(Person.class);
        if (this.supportsAutoincrement()) {
            classes.add(AutoInc.class);
        }
        if (this.supportsMultipleKeys()) {
            classes.add(MultipleKeys.class);
        }
        classes.add(Discovery.class);
        classes.add(DataTypes.class);
        this.pm = this.createPersistenceManager(classes);
        for (Class clazz : classes) {
            List items = this.pm.createQuery(clazz).fetch();
            for (Object object : items) {
                this.pm.delete(object);
            }
        }
        this.pm.insert(TESLA);
        this.pm.insert(CURIE);
        this.pm.insert(EINSTEIN);
    }
}

