/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.Json;
import siena.PersistenceManager;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcQuery;
import siena.jdbc.ThreadedConnectionManager;

public class JdbcPersistenceManager
implements PersistenceManager {
    private Map<Class<?>, JdbcClassInfo> infoClasses = new ConcurrentHashMap();
    private ConnectionManager connectionManager;

    public JdbcPersistenceManager() {
    }

    public JdbcPersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        this();
        this.connectionManager = connectionManager;
    }

    @Override
    public void init(Properties p) {
        String cm = p.getProperty("transactions");
        if (cm != null) {
            try {
                this.connectionManager = (ConnectionManager)Class.forName(cm).newInstance();
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        } else {
            this.connectionManager = new ThreadedConnectionManager();
        }
        this.connectionManager.init(p);
    }

    public Connection getConnection() throws SQLException {
        return this.connectionManager.getConnection();
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new JdbcQuery<T>(clazz, this);
    }

    public JdbcClassInfo getClassInfo(Class<?> clazz) {
        JdbcClassInfo ci = this.infoClasses.get(clazz);
        if (ci == null) {
            ci = new JdbcClassInfo(clazz);
            this.infoClasses.put(clazz, ci);
        }
        return ci;
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void delete(Object obj) {
        JdbcClassInfo classInfo = this.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
                this.addParameters(obj, classInfo.keys, ps, 1);
                int n = ps.executeUpdate();
                if (n == 0) {
                    throw new SienaException("No updated rows");
                }
                if (n > 1) {
                    throw new SienaException(String.valueOf(n) + " rows deleted");
                }
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
    }

    @Override
    public void get(Object obj) {
        JdbcClassInfo classInfo = this.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.selectSQL);
                this.addParameters(obj, classInfo.keys, ps, 1);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new SienaException("No such object");
                }
                this.mapObject(obj, rs);
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
    }

    public int addParameters(Object obj, List<Field> fields, PreparedStatement ps, int i) throws SQLException {
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (ClassInfo.isModel(type)) {
                JdbcClassInfo ci = this.getClassInfo(type);
                Object rel = this.readField(obj, field);
                for (Field f : ci.keys) {
                    if (rel != null) {
                        Object value = this.readField(rel, f);
                        if (value instanceof Json) {
                            value = ((Json)value).toString();
                        }
                        ps.setObject(i++, value);
                        continue;
                    }
                    ps.setObject(i++, null);
                }
                continue;
            }
            Object value = this.readField(obj, field);
            if (value instanceof Json) {
                value = ((Json)value).toString();
            } else if (field.getAnnotation(Embedded.class) != null) {
                value = JsonSerializer.serialize(value).toString();
            }
            ps.setObject(i++, value);
        }
        return i;
    }

    @Override
    public void insert(Object obj) {
        JdbcClassInfo classInfo = this.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        ResultSet gk = null;
        try {
            try {
                ps = !classInfo.generatedKeys.isEmpty() ? this.getConnection().prepareStatement(classInfo.insertSQL, 1) : this.getConnection().prepareStatement(classInfo.insertSQL);
                for (Field field : classInfo.keys) {
                    Id id = field.getAnnotation(Id.class);
                    if (id.value() != Generator.UUID) continue;
                    field.set(obj, UUID.randomUUID().toString());
                }
                this.addParameters(obj, classInfo.insertFields, ps, 1);
                ps.executeUpdate();
                if (!classInfo.generatedKeys.isEmpty()) {
                    gk = ps.getGeneratedKeys();
                    if (!gk.next()) {
                        throw new SienaException("No such generated keys");
                    }
                    int i = 1;
                    for (Field field : classInfo.generatedKeys) {
                        field.setAccessible(true);
                        Util.setFromObject(obj, field, gk.getObject(i));
                        ++i;
                    }
                }
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(gk);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(gk);
        this.closeStatement(ps);
    }

    @Override
    public void update(Object obj) {
        JdbcClassInfo classInfo = this.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.updateSQL);
                int i = 1;
                i = this.addParameters(obj, classInfo.updateFields, ps, i);
                this.addParameters(obj, classInfo.keys, ps, i);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
    }

    public String[] getColumnNames(Class<?> clazz, String field) {
        try {
            return ClassInfo.getColumnNames(clazz.getDeclaredField(field));
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public <T> T mapObject(Class<T> clazz, ResultSet rs) {
        try {
            T obj = clazz.newInstance();
            this.mapObject(obj, rs);
            return obj;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public void mapObject(Object obj, ResultSet rs) {
        Class<?> clazz = obj.getClass();
        for (Field field : this.getClassInfo(clazz).allFields) {
            this.mapField(obj, field, rs);
        }
    }

    public <T> List<T> mapList(Class<T> clazz, ResultSet rs) {
        try {
            ArrayList<T> objects = new ArrayList<T>();
            while (rs.next()) {
                objects.add(this.mapObject(clazz, rs));
            }
            return objects;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private void mapField(Object obj, Field field, ResultSet rs) {
        Class<?> type = field.getType();
        field.setAccessible(true);
        try {
            if (ClassInfo.isModel(type)) {
                String[] fks = ClassInfo.getColumnNames(field);
                Object rel = type.newInstance();
                JdbcClassInfo classInfo = this.getClassInfo(type);
                boolean none = false;
                int i = 0;
                this.checkForeignKeyMapping(classInfo.keys, fks, obj.getClass(), field);
                for (Field f : classInfo.keys) {
                    Object o;
                    if ((o = rs.getObject(fks[i++])) == null) {
                        none = true;
                        break;
                    }
                    Util.setFromObject(rel, f, o);
                }
                if (!none) {
                    field.set(obj, rel);
                }
            } else {
                Object val = rs.getObject(ClassInfo.getColumnNames(field)[0]);
                Util.setFromObject(obj, field, val);
            }
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public void checkForeignKeyMapping(List<Field> keys, String[] columns, Class<?> clazz, Field field) {
        if (keys.size() != columns.length) {
            throw new SienaException("Bad mapping for field '" + field.getName() + "'. " + "Related class " + field.getType().getName() + " has " + keys.size() + " primary keys, " + "but '" + clazz.getName() + "' only has mappings for " + columns.length + " foreign keys");
        }
    }

    public void closeStatement(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void beginTransaction(int isolationLevel) {
        this.connectionManager.beginTransaction(isolationLevel);
    }

    @Override
    public void commitTransaction() {
        this.connectionManager.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.connectionManager.rollbackTransaction();
    }

    @Override
    public void closeConnection() {
        this.connectionManager.closeConnection();
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    class JdbcClassInfo {
        public String tableName;
        public String insertSQL;
        public String updateSQL;
        public String deleteSQL;
        public String selectSQL;
        public String baseSelectSQL;
        public List<Field> keys = null;
        public List<Field> insertFields = null;
        public List<Field> updateFields = null;
        public List<Field> generatedKeys = null;
        public List<Field> allFields = null;

        public JdbcClassInfo(Class<?> clazz) {
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            this.keys = info.keys;
            this.insertFields = info.insertFields;
            this.updateFields = info.updateFields;
            this.generatedKeys = info.generatedKeys;
            this.allFields = info.allFields;
            this.tableName = info.tableName;
            ArrayList<String> keyColumns = new ArrayList<String>();
            ArrayList<String> insertColumns = new ArrayList<String>();
            ArrayList<String> updateColumns = new ArrayList<String>();
            ArrayList<String> allColumns = new ArrayList<String>();
            this.calculateColumns(this.insertFields, insertColumns, "=?");
            this.calculateColumns(this.updateFields, updateColumns, "=?");
            this.calculateColumns(this.keys, keyColumns, "=?");
            this.calculateColumns(this.allFields, allColumns, "");
            this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + Util.join(keyColumns, " AND ");
            this.insertSQL = "INSERT INTO " + this.tableName + " SET " + Util.join(insertColumns, ", ");
            this.updateSQL = "UPDATE " + this.tableName + " SET ";
            this.updateSQL = String.valueOf(this.updateSQL) + Util.join(updateColumns, ", ");
            this.updateSQL = String.valueOf(this.updateSQL) + " WHERE ";
            this.updateSQL = String.valueOf(this.updateSQL) + Util.join(keyColumns, " AND ");
            this.baseSelectSQL = "SELECT " + Util.join(allColumns, ", ") + " FROM " + this.tableName;
            this.selectSQL = String.valueOf(this.baseSelectSQL) + " WHERE " + Util.join(keyColumns, " AND ");
        }

        private void calculateColumns(List<Field> fields, List<String> columns, String suffix) {
            for (Field field : fields) {
                String[] columnNames;
                String[] stringArray = columnNames = ClassInfo.getColumnNames(field);
                int n = columnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String columnName = stringArray[n2];
                    columns.add(String.valueOf(columnName) + suffix);
                    ++n2;
                }
            }
        }
    }
}

