/*
 * Decompiled with CFR 0.152.
 */
package siena.json.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import siena.Json;

public class JsonTest
extends TestCase {
    public void testBuildEmptyList() {
        Json json = Json.list(new Object[0]);
        JsonTest.assertTrue((boolean)json.isList());
        JsonTest.assertTrue((boolean)json.isEmpty());
        JsonTest.assertFalse((boolean)json.isBoolean());
        JsonTest.assertFalse((boolean)json.isMap());
        JsonTest.assertFalse((boolean)json.isNumber());
        JsonTest.assertFalse((boolean)json.isString());
        JsonTest.assertEquals((int)0, (int)json.size());
        JsonTest.assertEquals((String)"[]", (String)json.toString());
    }

    public void testBuildEmptyMap() {
        Json json = Json.map();
        JsonTest.assertTrue((boolean)json.isMap());
        JsonTest.assertTrue((boolean)json.isEmpty());
        JsonTest.assertFalse((boolean)json.isBoolean());
        JsonTest.assertFalse((boolean)json.isList());
        JsonTest.assertFalse((boolean)json.isNumber());
        JsonTest.assertFalse((boolean)json.isString());
        JsonTest.assertEquals((int)0, (int)json.size());
        JsonTest.assertEquals((String)"{}", (String)json.toString());
    }

    public void testBuildString() {
        Json json = new Json("foobar");
        JsonTest.assertTrue((boolean)json.isString());
        JsonTest.assertFalse((boolean)json.isBoolean());
        JsonTest.assertFalse((boolean)json.isList());
        JsonTest.assertFalse((boolean)json.isMap());
        JsonTest.assertFalse((boolean)json.isEmpty());
        JsonTest.assertEquals((int)1, (int)json.size());
        JsonTest.assertEquals((String)"\"foobar\"", (String)json.toString());
    }

    public void testBuildComplex() {
        Json json = Json.list(1, 2, 3, 4, true, false, null, Json.map().put("foo", 1).put("bar", 2));
        JsonTest.assertEquals((int)1, (int)json.at(0).asInt());
        JsonTest.assertEquals((int)2, (int)json.at(1).asInt());
        JsonTest.assertEquals((int)3, (int)json.at(2).asInt());
        JsonTest.assertEquals((int)4, (int)json.at(3).asInt());
        JsonTest.assertTrue((boolean)json.at(4).asBoolean());
        JsonTest.assertFalse((boolean)json.at(5).asBoolean());
        JsonTest.assertTrue((boolean)json.at(6).isNull());
        JsonTest.assertTrue((boolean)json.at(7).isMap());
        JsonTest.assertEquals((int)2, (int)json.at(7).size());
        JsonTest.assertEquals((int)1, (int)json.at(7).get("foo").asInt());
        JsonTest.assertEquals((int)2, (int)json.at(7).get("bar").asInt());
    }

    public void testParseList() {
        Json json = Json.loads("[true, false, null, 1234, \"foobar\"]");
        JsonTest.assertTrue((boolean)json.isList());
        JsonTest.assertEquals((int)5, (int)json.size());
        JsonTest.assertTrue((boolean)json.at(0).isBoolean());
        JsonTest.assertTrue((boolean)json.at(0).asBoolean());
        JsonTest.assertTrue((boolean)json.at(1).isBoolean());
        JsonTest.assertFalse((boolean)json.at(1).asBoolean());
        JsonTest.assertTrue((boolean)json.at(2).isNull());
        JsonTest.assertTrue((boolean)json.at(3).isNumber());
        JsonTest.assertEquals((int)1234, (int)json.at(3).asInt());
        JsonTest.assertTrue((boolean)json.at(4).isString());
        JsonTest.assertEquals((String)"foobar", (String)json.at(4).asString());
    }

    public void testEscapeCharacters() {
        Json json = Json.loads("[\"\\b\\f\\n\\r\\t\\\"\\/\\u0041\"]");
        JsonTest.assertTrue((boolean)json.isList());
        JsonTest.assertEquals((int)1, (int)json.size());
        JsonTest.assertTrue((boolean)json.at(0).isString());
        JsonTest.assertEquals((String)"[\"\\b\\f\\n\\r\\t\\\"\\/A\"]", (String)json.toString());
    }

    public void testParseMap() {
        Json json = Json.loads("{\"foo\": 1234, \"bar\": true}");
        JsonTest.assertTrue((boolean)json.isMap());
        JsonTest.assertEquals((int)2, (int)json.size());
        Json foo = json.get("foo");
        JsonTest.assertTrue((boolean)foo.isNumber());
        JsonTest.assertEquals((int)1234, (int)foo.asInt());
        Json bar = json.get("bar");
        JsonTest.assertTrue((boolean)bar.isBoolean());
        JsonTest.assertEquals((boolean)true, (boolean)bar.asBoolean());
    }

    public void testParseComplex() {
        Json json = null;
        json = Json.loads("{}");
        JsonTest.assertEquals((String)"{}", (String)json.toString());
        json = Json.loads("[{}]");
        JsonTest.assertEquals((String)"[{}]", (String)json.toString());
        json = Json.loads("{}");
        JsonTest.assertEquals((String)"{}", (String)json.toString());
        json = Json.loads("[{}, {}, {}]");
        JsonTest.assertEquals((String)"[{}, {}, {}]", (String)json.toString());
        json = Json.loads("{\"foo\": 1234, \"bar\": [1, 2, 3, [{}], true, false, null, {}]}");
        JsonTest.assertTrue((boolean)json.isMap());
        JsonTest.assertEquals((int)2, (int)json.size());
        JsonTest.assertEquals((int)1234, (int)json.get("foo").asInt());
        Json list = json.get("bar");
        JsonTest.assertTrue((boolean)list.isList());
        JsonTest.assertEquals((int)8, (int)list.size());
        JsonTest.assertEquals((int)1, (int)list.at(0).asInt());
        JsonTest.assertEquals((int)2, (int)list.at(1).asInt());
        JsonTest.assertEquals((int)3, (int)list.at(2).asInt());
        JsonTest.assertTrue((boolean)list.at(3).isList());
        JsonTest.assertEquals((int)1, (int)list.at(3).size());
        JsonTest.assertTrue((boolean)list.at(3).at(0).isMap());
        JsonTest.assertTrue((boolean)list.at(3).at(0).isEmpty());
        JsonTest.assertTrue((boolean)list.at(4).asBoolean());
        JsonTest.assertFalse((boolean)list.at(5).asBoolean());
        JsonTest.assertTrue((boolean)list.at(6).isNull());
        JsonTest.assertTrue((boolean)list.at(7).isMap());
        JsonTest.assertTrue((boolean)list.at(7).isEmpty());
    }

    public void testPutAll() {
        Json map = Json.map().put("foo", 1).put("bar", 2);
        Json other = Json.map().put("baz", 3);
        other.putAll(map);
        JsonTest.assertEquals((int)3, (int)other.size());
        JsonTest.assertEquals((int)3, (int)other.get("baz").asInt());
        JsonTest.assertEquals((int)2, (int)other.get("bar").asInt());
        JsonTest.assertEquals((int)1, (int)other.get("foo").asInt());
    }

    public void testArray() {
        Json list = new Json(new Object[]{1, 2, 3});
        JsonTest.assertEquals((int)3, (int)list.size());
        JsonTest.assertEquals((int)1, (int)list.at(0).asInt());
        JsonTest.assertEquals((int)2, (int)list.at(1).asInt());
        JsonTest.assertEquals((int)3, (int)list.at(2).asInt());
        JsonTest.assertEquals((String)"[1, 2, 3]", (String)list.toString());
    }

    public void testCollection() {
        Json list = new Json(Arrays.asList(1, 2, 3));
        JsonTest.assertEquals((int)3, (int)list.size());
        JsonTest.assertEquals((int)1, (int)list.at(0).asInt());
        JsonTest.assertEquals((int)2, (int)list.at(1).asInt());
        JsonTest.assertEquals((int)3, (int)list.at(2).asInt());
        JsonTest.assertEquals((String)"[1, 2, 3]", (String)list.toString());
    }

    public void testMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("foo", 1);
        Json map = new Json(m);
        JsonTest.assertTrue((boolean)map.isMap());
        JsonTest.assertEquals((int)1, (int)map.size());
        JsonTest.assertEquals((int)1, (int)map.get("foo").asInt());
        JsonTest.assertEquals((String)"{\"foo\": 1}", (String)map.toString());
    }

    public void testPutComplex() {
        List<Integer> list1 = Arrays.asList(1, 2, 3);
        List<String> list2 = Arrays.asList("foo", "bar", "baz");
        ArrayList<List<Object>> objects = new ArrayList<List<Object>>();
        objects.add(list1);
        objects.add(list2);
        Json map = Json.map().put("foo", objects);
        Json list = map.get("foo");
        JsonTest.assertEquals((int)2, (int)list.size());
        JsonTest.assertEquals((int)3, (int)list.at(0).size());
        JsonTest.assertEquals((int)1, (int)list.at(0).at(0).asInt());
        JsonTest.assertEquals((int)2, (int)list.at(0).at(1).asInt());
        JsonTest.assertEquals((int)3, (int)list.at(0).at(2).asInt());
        JsonTest.assertEquals((int)3, (int)list.at(1).size());
        JsonTest.assertEquals((String)"foo", (String)list.at(1).at(0).str());
        JsonTest.assertEquals((String)"bar", (String)list.at(1).at(1).str());
        JsonTest.assertEquals((String)"baz", (String)list.at(1).at(2).str());
    }

    public void testAddAll() {
        Json json = Json.list(1, 2, 3);
        json.addAll(Json.list(4, 5, 6));
        JsonTest.assertEquals((int)6, (int)json.size());
    }

    public void testAddAt() {
        Json json = Json.list(1, 3);
        json.addAt(1, 2);
        JsonTest.assertEquals((int)3, (int)json.size());
        JsonTest.assertEquals((int)1, (int)json.at(0).asInt());
        JsonTest.assertEquals((int)2, (int)json.at(1).asInt());
        JsonTest.assertEquals((int)3, (int)json.at(2).asInt());
    }

    public void testRemoveAt() {
        Json json = Json.list(1, 2, 3);
        json.removeAt(1);
        JsonTest.assertEquals((int)2, (int)json.size());
        JsonTest.assertEquals((int)1, (int)json.at(0).asInt());
        JsonTest.assertEquals((int)3, (int)json.at(1).asInt());
    }

    public void testIndexOf() {
        Json json = Json.list(1, 2, 3, "hello", true, false, null);
        JsonTest.assertEquals((int)0, (int)json.indexOf(1));
        JsonTest.assertEquals((int)1, (int)json.indexOf(2));
        JsonTest.assertEquals((int)2, (int)json.indexOf(3));
        JsonTest.assertEquals((int)3, (int)json.indexOf("hello"));
        JsonTest.assertEquals((int)4, (int)json.indexOf(true));
        JsonTest.assertEquals((int)5, (int)json.indexOf(false));
        JsonTest.assertEquals((int)6, (int)json.indexOf(null));
    }

    public void testRemoveKey() {
        Json json = Json.map().put("foo", "bar");
        json.remove("foo");
        JsonTest.assertTrue((boolean)json.isEmpty());
    }

    public void testSortedMap() {
        Json json = Json.sortedMap().put("1", 1).put("400", 400).put("3", 3).put("2", 2);
        Iterator<String> keys = json.keys().iterator();
        JsonTest.assertEquals((String)"1", (String)keys.next());
        JsonTest.assertEquals((String)"2", (String)keys.next());
        JsonTest.assertEquals((String)"3", (String)keys.next());
        JsonTest.assertEquals((String)"400", (String)keys.next());
    }

    public void testSortedMap2() {
        Json json = Json.sortedMap().put("2009-01", 1).put("2008-10", 400);
        Iterator<String> keys = json.keys().iterator();
        JsonTest.assertEquals((String)"2008-10", (String)keys.next());
        JsonTest.assertEquals((String)"2009-01", (String)keys.next());
    }

    public void testContains() {
        Json json = Json.list(1, 2, 3);
        JsonTest.assertTrue((boolean)json.contains(1));
        JsonTest.assertTrue((boolean)json.contains(2));
        JsonTest.assertTrue((boolean)json.contains(3));
        JsonTest.assertFalse((boolean)json.contains(4));
    }

    public void testFormatAndParseNumbers() {
        Json json = Json.loads("[1.0, 2.0, 3, 4, 5, 6.1, 1.0e12, 2e12]");
        String s = json.toString();
        JsonTest.assertTrue((boolean)s.contains("1.0"));
        JsonTest.assertTrue((boolean)s.contains("2.0"));
        JsonTest.assertFalse((boolean)s.contains("3.0"));
        JsonTest.assertFalse((boolean)s.contains("4.0"));
        JsonTest.assertFalse((boolean)s.contains("5.0"));
        JsonTest.assertTrue((boolean)s.contains("6.1"));
        JsonTest.assertTrue((boolean)s.contains("1.0E12"));
        JsonTest.assertTrue((boolean)s.contains("2.0E12"));
    }

    public void testRemoveAll() {
        Json list = Json.list(1, 2, 3);
        list.removeAll(Json.list(1, 2));
        JsonTest.assertEquals((int)1, (int)list.size());
        JsonTest.assertEquals((int)3, (int)list.at(0).asInt());
        Json map = Json.map().put("foo", 1).put("bar", 2);
        map.removeAll(Json.map().put("foo", 1));
        JsonTest.assertEquals((int)1, (int)map.size());
        JsonTest.assertEquals((int)2, (int)map.get("bar").asInt());
    }

    public void testSumIntegers() {
        Json map1 = Json.map().put("a", 1);
        Json map2 = Json.map().put("a", 2).put("b", 5);
        map1.sumIntegers(map2);
        JsonTest.assertEquals((int)3, (int)map1.get("a").asInt());
        JsonTest.assertEquals((int)5, (int)map1.get("b").asInt());
    }

    public void testSumDoubles() {
        Json map1 = Json.map().put("a", 1.5);
        Json map2 = Json.map().put("a", 2.5).put("b", 5);
        map1.sumReals(map2);
        JsonTest.assertEquals((int)4, (int)map1.get("a").asInt());
        JsonTest.assertEquals((int)5, (int)map1.get("b").asInt());
    }

    public void sumInteger() {
        Json map1 = Json.map().put("a", 1);
        map1.sumInteger("a", 2L);
        JsonTest.assertEquals((int)3, (int)map1.get("a").asInt());
        map1 = Json.map();
        map1.sumInteger("a", 2L);
        JsonTest.assertEquals((int)2, (int)map1.get("a").asInt());
    }

    public void sumReal() {
        Json map1 = Json.map().put("a", 1.5);
        map1.sumReal("a", 2.5);
        JsonTest.assertEquals((int)4, (int)map1.get("a").asInt());
        map1 = Json.map();
        map1.sumReal("a", 2.5);
        JsonTest.assertEquals((Object)2.5, (Object)map1.get("a").asInt());
    }

    public void testPutDefault() {
        Json map = Json.map();
        map.putDefault("a", 2);
        JsonTest.assertEquals((int)2, (int)map.get("a").asInt());
        map.putDefault("a", 3);
        JsonTest.assertEquals((int)2, (int)map.get("a").asInt());
    }

    public void testEqualsTo() {
        Json a = Json.map();
        Json b = Json.map();
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.list(new Object[0]);
        b = Json.list(new Object[0]);
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.list("foo", "bar");
        b = Json.list("foo", "bar");
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.map().put("foo", "bar");
        b = Json.map().put("foo", "bar");
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.map().put("foo", Json.list("bar"));
        b = Json.map().put("foo", Json.list("bar"));
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.map();
        b = Json.sortedMap();
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = new Json(true);
        b = new Json(true);
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = new Json(1);
        b = new Json(1L);
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = new Json(1.0);
        b = new Json(1L);
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = new Json(null);
        b = new Json(null);
        JsonTest.assertTrue((boolean)a.equalsTo(b));
        a = Json.map();
        b = Json.list(new Object[0]);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = Json.list(new Object[0]);
        b = Json.map();
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = Json.list(1, 2, 3, 4);
        b = Json.list(1, 2, 3);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = Json.map().put("foo", 1);
        b = Json.map().put("bar", 1);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = new Json(1);
        b = new Json(null);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = Json.list(1, 3);
        b = Json.list(1, 2);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        a = Json.map();
        b = Json.map().put("1", 2);
        JsonTest.assertFalse((boolean)a.equalsTo(b));
        b = a = Json.map();
        JsonTest.assertTrue((boolean)a.equalsTo(b));
    }

    public void testFind() {
        Json data = Json.map().put("foo", Json.list(1, 2, Json.list(1, 2, Json.map().put("bar", 1))));
        Json result = data.find("foo", 2, 2, "bar");
        JsonTest.assertNotNull((Object)result);
        JsonTest.assertEquals((int)1, (int)result.asInt());
        result = data.find(1);
        JsonTest.assertNull((Object)result);
        result = data.find("foo", "bar");
        JsonTest.assertNull((Object)result);
        result = data.find("bar", "baz");
        JsonTest.assertNull((Object)result);
        result = data.find("foo", 3);
        JsonTest.assertNull((Object)result);
    }
}

