/*
 * Decompiled with CFR 0.152.
 */
package siena.remote.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import siena.PersistenceManagerFactory;
import siena.SienaException;
import siena.remote.Common;
import siena.remote.RemotePersistenceManager;
import siena.remote.test.DataTypes;
import siena.remote.test.Discovery;
import siena.remote.test.MockConnector;
import siena.remote.test.MockPersistenceManager;
import siena.remote.test.Person;

public class SienaRemoteTest
extends TestCase {
    private static Person TESLA;
    private static Person CURIE;
    private static Person EINSTEIN;
    private static Discovery RADIOACTIVITY;
    private static Discovery RELATIVITY;
    private static Discovery TESLA_COIL;
    private ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();

    protected void setUp() throws Exception {
        super.setUp();
        PersistenceManagerFactory.install(new MockPersistenceManager(), Person.class);
        TESLA = new Person(1L, "Nikola", "Tesla", "Smiljam");
        CURIE = new Person(2L, "Marie", "Curie", "Warsaw");
        EINSTEIN = new Person(3L, "Albert", "Einstein", "Ulm");
        RADIOACTIVITY = new Discovery(1L, "Radioactivity");
        RELATIVITY = new Discovery(2L, "Relativity");
        TESLA_COIL = new Discovery(3L, "Tesla Coil");
        SienaRemoteTest.RADIOACTIVITY.discoverer = CURIE;
        SienaRemoteTest.RELATIVITY.discoverer = EINSTEIN;
        SienaRemoteTest.TESLA_COIL.discoverer = TESLA;
    }

    public void testFillAndParseIds() throws IOException {
        Element root = this.createSimpleDocument();
        Common.fillRequestElement(TESLA, root, true);
        Person person = (Person)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((long)person.id, (long)SienaRemoteTest.TESLA.id);
        SienaRemoteTest.assertNull((Object)person.firstName);
        SienaRemoteTest.assertNull((Object)person.lastName);
        SienaRemoteTest.assertNull((Object)person.city);
    }

    public void testFillAndParse() throws IOException {
        Element root = this.createSimpleDocument();
        Common.fillRequestElement(TESLA, root, false);
        Person person = (Person)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((Object)TESLA, (Object)person);
    }

    public void testFillAndParseDataTypesEmpty() throws IOException {
        Element root = this.createSimpleDocument();
        DataTypes original = new DataTypes();
        Common.fillRequestElement(original, root, false);
        DataTypes parsed = (DataTypes)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((Object)original, (Object)parsed);
    }

    public void testFillAndParseDataTypesFull() throws IOException {
        Element root = this.createSimpleDocument();
        DataTypes original = new DataTypes();
        original.typeByte = 1;
        original.typeShort = (short)2;
        original.typeInt = 3;
        original.typeLong = 4L;
        original.typeFloat = 5.0f;
        original.typeDouble = 6.0;
        original.typeString = "hello";
        original.typeDate = new Date();
        Common.fillRequestElement(original, root, false);
        DataTypes parsed = (DataTypes)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((Object)original, (Object)parsed);
    }

    public void testFillAndParseDataTypesEmptyString() throws IOException {
        Element root = this.createSimpleDocument();
        DataTypes original = new DataTypes();
        original.typeByte = 1;
        original.typeShort = (short)2;
        original.typeInt = 3;
        original.typeLong = 4L;
        original.typeFloat = 5.0f;
        original.typeDouble = 6.0;
        original.typeString = "";
        original.typeDate = new Date();
        Common.fillRequestElement(original, root, false);
        DataTypes parsed = (DataTypes)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((Object)original, (Object)parsed);
    }

    public void testFillAndParseDataTypesNullString() throws IOException {
        Element root = this.createSimpleDocument();
        DataTypes original = new DataTypes();
        original.typeByte = 1;
        original.typeShort = (short)2;
        original.typeInt = 3;
        original.typeLong = 4L;
        original.typeFloat = 5.0f;
        original.typeDouble = 6.0;
        original.typeString = null;
        original.typeDate = new Date();
        Common.fillRequestElement(original, root, false);
        DataTypes parsed = (DataTypes)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((Object)original, (Object)parsed);
    }

    public void testFillAndParseRelationship() throws IOException {
        Element root = this.createSimpleDocument();
        Common.fillRequestElement(RADIOACTIVITY, root, false);
        Discovery parsed = (Discovery)Common.parseEntity(root, this.cl);
        SienaRemoteTest.assertEquals((long)SienaRemoteTest.RADIOACTIVITY.id, (long)parsed.id);
        SienaRemoteTest.assertEquals((String)SienaRemoteTest.RADIOACTIVITY.name, (String)parsed.name);
        SienaRemoteTest.assertNotNull((Object)parsed.discoverer);
        SienaRemoteTest.assertEquals((long)SienaRemoteTest.RADIOACTIVITY.discoverer.id, (long)parsed.discoverer.id);
        SienaRemoteTest.assertNull((Object)parsed.discoverer.firstName);
        SienaRemoteTest.assertNull((Object)parsed.discoverer.lastName);
        SienaRemoteTest.assertNull((Object)parsed.discoverer.city);
    }

    public void testRemote() {
        MockPersistenceManager mock = new MockPersistenceManager();
        PersistenceManagerFactory.install(mock, Person.class);
        RemotePersistenceManager remote = new RemotePersistenceManager();
        Properties properties = new Properties();
        properties.setProperty("connector", MockConnector.class.getName());
        properties.setProperty("serializer", MockConnector.class.getName());
        remote.init(properties);
        remote.insert(TESLA);
        SienaRemoteTest.assertEquals((String)"insert", (String)mock.action);
        SienaRemoteTest.assertEquals((Object)TESLA, (Object)mock.object);
        remote.update(TESLA);
        SienaRemoteTest.assertEquals((String)"update", (String)mock.action);
        SienaRemoteTest.assertEquals((Object)TESLA, (Object)mock.object);
        Person expected = new Person();
        expected.id = SienaRemoteTest.TESLA.id;
        remote.delete(TESLA);
        SienaRemoteTest.assertEquals((String)"delete", (String)mock.action);
        SienaRemoteTest.assertEquals((Object)expected, (Object)mock.object);
        remote.get(TESLA);
        SienaRemoteTest.assertEquals((String)"get", (String)mock.action);
        SienaRemoteTest.assertEquals((Object)expected, (Object)mock.object);
        remote.createQuery(Person.class).fetch();
        SienaRemoteTest.assertEquals((int)0, (int)mock.lastQuery.filters.size());
        SienaRemoteTest.assertEquals((int)0, (int)mock.lastQuery.orders.size());
        remote.createQuery(Person.class).order("firstName").order("lastName").fetch();
        SienaRemoteTest.assertEquals((int)0, (int)mock.lastQuery.filters.size());
        SienaRemoteTest.assertEquals(Arrays.asList("firstName", "lastName"), mock.lastQuery.orders);
        remote.createQuery(Person.class).filter("city", "Ulm").filter("firstName", "Albert").filter("lastName", null).order("firstName").order("lastName").fetch();
        SienaRemoteTest.assertEquals((int)3, (int)mock.lastQuery.filters.size());
        SienaRemoteTest.assertEquals((Object)"city", (Object)mock.lastQuery.filters.get(0)[0]);
        SienaRemoteTest.assertEquals((Object)"Ulm", (Object)mock.lastQuery.filters.get(0)[1]);
        SienaRemoteTest.assertEquals((Object)"firstName", (Object)mock.lastQuery.filters.get(1)[0]);
        SienaRemoteTest.assertEquals((Object)"Albert", (Object)mock.lastQuery.filters.get(1)[1]);
        SienaRemoteTest.assertEquals((Object)"lastName", (Object)mock.lastQuery.filters.get(2)[0]);
        SienaRemoteTest.assertEquals(null, (Object)mock.lastQuery.filters.get(2)[1]);
        SienaRemoteTest.assertEquals(Arrays.asList("firstName", "lastName"), mock.lastQuery.orders);
    }

    public void testSecurity() {
        MockPersistenceManager mock = new MockPersistenceManager();
        PersistenceManagerFactory.install(mock, Person.class);
        RemotePersistenceManager remote = new RemotePersistenceManager();
        Properties properties = new Properties();
        properties.setProperty("connector", MockConnector.class.getName());
        properties.setProperty("serializer", MockConnector.class.getName());
        properties.setProperty("key", "siena");
        remote.init(properties);
        remote.createQuery(Person.class).fetch();
    }

    public void testFailSecurity() {
        MockPersistenceManager mock = new MockPersistenceManager();
        PersistenceManagerFactory.install(mock, Person.class);
        RemotePersistenceManager remote = new RemotePersistenceManager();
        Properties properties = new Properties();
        properties.setProperty("connector", MockConnector.class.getName());
        properties.setProperty("serializer", MockConnector.class.getName());
        properties.setProperty("key", "siena");
        remote.init(properties);
        MockConnector.key = "1234";
        try {
            remote.createQuery(Person.class).fetch();
        }
        catch (SienaException e) {
            return;
        }
        SienaRemoteTest.fail((String)"It should have failed due to invalid hash");
    }

    private Element createSimpleDocument(String rootName) {
        return DocumentHelper.createDocument().addElement(rootName);
    }

    private Element createSimpleDocument() {
        return this.createSimpleDocument("root");
    }
}

