/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.sdb.ws.Item;
import siena.sdb.ws.SelectResponse;
import siena.sdb.ws.SimpleDB;

public class SdbPersistenceManager
implements PersistenceManager {
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "="};
    private static long ioffset = Math.abs(Integer.MIN_VALUE);
    private SimpleDB ws;
    private String prefix;
    private List<String> domains;

    @Override
    public void init(Properties p) {
        String awsAccessKeyId = p.getProperty("awsAccessKeyId");
        String awsSecretAccessKey = p.getProperty("awsSecretAccessKey");
        if (awsAccessKeyId == null || awsSecretAccessKey == null) {
            throw new SienaException("Both awsAccessKeyId and awsSecretAccessKey properties must be set");
        }
        this.prefix = p.getProperty("prefix");
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.ws = new SimpleDB(awsAccessKeyId, awsSecretAccessKey);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new SdbQuery(clazz);
    }

    @Override
    public void delete(Object obj) {
        this.ws.deleteAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void get(Object obj) {
        Item item = this.ws.getAttributes((String)this.getDomainName(obj.getClass()), (String)this.getIdValue((Object)obj)).item;
        this.fillModel(item, obj);
    }

    @Override
    public void insert(Object obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    @Override
    public void update(Object obj) {
        this.ws.putAttributes(this.getDomainName(obj.getClass()), this.toItem(obj));
    }

    public String getIdValue(Object obj) {
        try {
            return (String)ClassInfo.getIdField(obj.getClass()).get(obj);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    protected String getDomainName(Class<?> clazz) {
        String domain = String.valueOf(this.prefix) + ClassInfo.getClassInfo(clazz).tableName;
        if (this.domains == null) {
            this.domains = this.ws.listDomains(null, null).domains;
        }
        if (!this.domains.contains(domain)) {
            this.ws.createDomain(domain);
        }
        return domain;
    }

    private String getAttributeName(Field field) {
        return ClassInfo.getColumnNames(field)[0];
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private Item toItem(Object obj) {
        Item item = new Item();
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            try {
                String value = SdbPersistenceManager.toString(field, field.get(obj));
                if (value == null) continue;
                item.add(this.getAttributeName(field), value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Field id = ClassInfo.getIdField(clazz);
        String name = (String)this.readField(obj, id);
        if (name == null) {
            try {
                name = UUID.randomUUID().toString();
                id.set(obj, name);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        item.name = name;
        return item;
    }

    private static String toString(Field field, Object object) {
        if (object == null) {
            return null;
        }
        Class<?> type = field.getType();
        if (type == Integer.class || type == Integer.TYPE) {
            return SdbPersistenceManager.toString((Integer)object);
        }
        if (ClassInfo.isModel(type)) {
            try {
                return ClassInfo.getIdField(type).get(object).toString();
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return Util.toString(field, object);
    }

    private void fillModel(Item item, Object obj) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            List<String> values = item.attributes.get(this.getAttributeName(field));
            if (values == null || values.isEmpty()) continue;
            try {
                String value = values.get(0);
                if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                    field.set(obj, SdbPersistenceManager.fromString(value));
                    continue;
                }
                Class<?> type = field.getType();
                if (ClassInfo.isModel(type)) {
                    Object rel = type.newInstance();
                    Field id = ClassInfo.getIdField(type);
                    id.set(rel, value);
                    field.set(obj, rel);
                    continue;
                }
                Util.setFromString(obj, field, value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        Field id = ClassInfo.getIdField(clazz);
        try {
            id.set(obj, item.name);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private static String toString(int i) {
        return String.format("%010d", (long)i + ioffset);
    }

    private static int fromString(String s) {
        long l = Long.parseLong(s);
        return (int)(l - ioffset);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public void rollbackTransaction() {
    }

    class SdbQuery<T>
    implements Query<T> {
        private Class<?> clazz;
        private List<String> filter;
        private String order;
        private String nextOffset;

        public SdbQuery(Class<?> clazz) {
            this.clazz = clazz;
        }

        private List<T> query(String suffix, String nextToken) {
            String domain = SdbPersistenceManager.this.getDomainName(this.clazz);
            String q = this.buildQuery("select * from " + domain, suffix);
            SelectResponse response = SdbPersistenceManager.this.ws.select(q, nextToken);
            this.nextOffset = response.nextToken;
            List<Item> items = response.items;
            ArrayList result = new ArrayList(items.size());
            for (Item item : items) {
                try {
                    Object object = this.clazz.newInstance();
                    SdbPersistenceManager.this.fillModel(item, object);
                    result.add(object);
                }
                catch (Exception e) {
                    throw new SienaException(e);
                }
            }
            return result;
        }

        private String buildQuery(String prefix, String suffix) {
            StringBuilder query = new StringBuilder(prefix);
            if (this.filter != null) {
                query.append(" where ");
                query.append(Util.join(this.filter, " and "));
            }
            if (this.order != null) {
                query.append(" order by " + this.order);
            }
            query.append(suffix);
            return query.toString();
        }

        private int count(int limit, String nextToken) {
            String domain = SdbPersistenceManager.this.getDomainName(this.clazz);
            String q = this.buildQuery("select count(*) from " + domain, "");
            SelectResponse response = SdbPersistenceManager.this.ws.select(q, nextToken);
            this.nextOffset = response.nextToken;
            int count = Integer.parseInt(response.items.get((int)0).attributes.get("Count").get(0));
            if (limit >= 0 && count > limit) {
                return limit;
            }
            return count;
        }

        @Override
        public int count() {
            return this.count(-1, null);
        }

        @Override
        public int count(int limit) {
            return this.count(limit, null);
        }

        @Override
        public int count(int limit, Object offset) {
            return this.count(limit, offset.toString());
        }

        @Override
        public List<T> fetch() {
            return this.query("", null);
        }

        @Override
        public List<T> fetch(int limit) {
            return this.query(" limit " + limit, null);
        }

        @Override
        public List<T> fetch(int limit, Object offset) {
            return this.query(" limit " + limit, offset.toString());
        }

        @Override
        public Query<T> filter(String field, Object value) {
            if (this.filter == null) {
                this.filter = new ArrayList<String>();
            }
            String op = "=";
            String[] stringArray = supportedOperators;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String operator = stringArray[n2];
                if (field.endsWith(operator)) {
                    op = operator;
                    field = field.substring(0, field.length() - operator.length());
                    break;
                }
                ++n2;
            }
            field = field.trim();
            try {
                Field f = this.clazz.getDeclaredField(field);
                String column = null;
                column = ClassInfo.isId(f) ? "itemName()" : ClassInfo.getColumnNames(f)[0];
                if (value == null && op.equals("=")) {
                    this.filter.add(String.valueOf(column) + " is null");
                } else {
                    String s = SdbPersistenceManager.toString(f, value);
                    this.filter.add(String.valueOf(column) + op + SimpleDB.quote(s));
                }
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
            return this;
        }

        @Override
        public T get() {
            List<T> result = this.fetch(1);
            if (result.isEmpty()) {
                return null;
            }
            return result.get(0);
        }

        @Override
        public Iterable<T> iter(String field, int max) {
            return null;
        }

        @Override
        public Query<T> order(String field) {
            try {
                boolean desc = false;
                if (field.startsWith("-")) {
                    field = field.substring(1);
                    desc = true;
                }
                this.order = ClassInfo.isId(this.clazz.getField(field)) ? "itemName()" : ClassInfo.getColumnNames(this.clazz.getDeclaredField(field))[0];
                if (desc) {
                    this.order = String.valueOf(this.order) + " desc";
                }
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
            return this;
        }

        @Override
        public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
            return null;
        }

        @Override
        public SdbQuery<T> clone() {
            return null;
        }

        @Override
        public Object nextOffset() {
            return this.nextOffset;
        }

        @Override
        public int delete() {
            return 0;
        }

        @Override
        public List<T> fetchKeys() {
            return null;
        }

        @Override
        public List<T> fetchKeys(int limit) {
            return null;
        }

        @Override
        public List<T> fetchKeys(int limit, Object offset) {
            return null;
        }
    }
}

