/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import siena.ClassInfo;
import siena.Json;
import siena.PersistenceManager;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.gae.GaeQuery;
import siena.gae.Unindexed;

public class GaePersistenceManager
implements PersistenceManager {
    private DatastoreService ds;

    @Override
    public void beginTransaction(int isolationLevel) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new GaeQuery<T>(this, clazz);
    }

    @Override
    public void delete(Object obj) {
        this.ds.delete(new Key[]{this.getKey(obj)});
    }

    @Override
    public void get(Object obj) {
        Key key = this.getKey(obj);
        try {
            Entity entity = this.ds.get(key);
            this.fillModel(obj, entity);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void init(Properties p) {
        this.ds = DatastoreServiceFactory.getDatastoreService();
    }

    @Override
    public void insert(Object obj) {
        Class<?> clazz = obj.getClass();
        Entity entity = new Entity(ClassInfo.getClassInfo(clazz).tableName);
        this.fillEntity(obj, entity);
        this.ds.put(entity);
        this.setKey(ClassInfo.getIdField(clazz), obj, entity.getKey());
    }

    private void setKey(Field f, Object obj, Key key) {
        try {
            Object value = key.getId();
            if (f.getType() == String.class) {
                value = value.toString();
            }
            f.setAccessible(true);
            f.set(obj, value);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public void update(Object obj) {
        try {
            Entity entity = this.ds.get(this.getKey(obj));
            this.fillEntity(obj, entity);
            this.ds.put(entity);
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public Key getKey(Object obj) {
        try {
            Field f = ClassInfo.getIdField(obj.getClass());
            Object value = f.get(obj);
            if (value instanceof String) {
                value = Long.parseLong((String)value);
            }
            return KeyFactory.createKey((String)ClassInfo.getClassInfo(obj.getClass()).tableName, (long)((Long)value));
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private Object readField(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private void fillEntity(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            Unindexed ui;
            String property = ClassInfo.getColumnNames(field)[0];
            Object value = this.readField(obj, field);
            Class<?> fieldClass = field.getType();
            if (ClassInfo.isModel(fieldClass)) {
                if (value == null) {
                    entity.setProperty(property, null);
                    continue;
                }
                Key key = this.getKey(value);
                entity.setProperty(property, (Object)key);
                continue;
            }
            if (value != null) {
                if (field.getType() == Json.class) {
                    value = value.toString();
                } else if (value instanceof String) {
                    String s = (String)value;
                    if (s.length() > 500) {
                        value = new Text(s);
                    }
                } else if (field.getAnnotation(Embedded.class) != null) {
                    value = JsonSerializer.serialize(value).toString();
                }
            }
            if ((ui = field.getAnnotation(Unindexed.class)) == null) {
                entity.setProperty(property, value);
                continue;
            }
            entity.setUnindexedProperty(property, value);
        }
    }

    private void fillModel(Object obj, Entity entity) {
        Class<?> clazz = obj.getClass();
        for (Field field : ClassInfo.getClassInfo(clazz).updateFields) {
            field.setAccessible(true);
            String property = ClassInfo.getColumnNames(field)[0];
            try {
                Class<?> fieldClass = field.getType();
                if (ClassInfo.isModel(fieldClass)) {
                    Key key = (Key)entity.getProperty(property);
                    if (key == null) continue;
                    Object value = fieldClass.newInstance();
                    Field id = ClassInfo.getIdField(fieldClass);
                    this.setKey(id, value, key);
                    field.set(obj, value);
                    continue;
                }
                this.setFromObject(obj, field, entity.getProperty(property));
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
    }

    private void setFromObject(Object object, Field f, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (value instanceof Text) {
            value = ((Text)value).getValue();
        }
        Util.setFromObject(object, f, value);
    }

    protected DatastoreService getDatastoreService() {
        return this.ds;
    }

    protected <T> List<T> mapEntities(List<Entity> entities, Class<T> clazz) {
        Field id = ClassInfo.getIdField(clazz);
        ArrayList<T> list = new ArrayList<T>(entities.size());
        for (Entity entity : entities) {
            try {
                T obj = clazz.newInstance();
                this.fillModel(obj, entity);
                list.add(obj);
                this.setKey(id, obj, entity.getKey());
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return list;
    }
}

