/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import siena.ClassInfo;
import siena.IterableQuery;
import siena.Query;
import siena.SienaException;
import siena.gae.GaePersistenceManager;

public class GaeQuery<T>
implements Query<T> {
    private static final Map<String, Query.FilterOperator> supportedOperators = new HashMap<String, Query.FilterOperator>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("=", Query.FilterOperator.EQUAL);
            this.put("<", Query.FilterOperator.LESS_THAN);
            this.put(">", Query.FilterOperator.GREATER_THAN);
            this.put("<=", Query.FilterOperator.LESS_THAN_OR_EQUAL);
            this.put(">=", Query.FilterOperator.GREATER_THAN_OR_EQUAL);
            this.put("IN", Query.FilterOperator.IN);
        }
    };
    private GaePersistenceManager pm;
    private com.google.appengine.api.datastore.Query q;
    private Class<T> clazz;
    private int nextOffset;

    public GaeQuery(GaePersistenceManager pm, Class<T> clazz) {
        this.clazz = clazz;
        this.pm = pm;
        this.q = new com.google.appengine.api.datastore.Query(ClassInfo.getClassInfo(clazz).tableName);
    }

    @Override
    public int count() {
        return this.fetch().size();
    }

    @Override
    public int count(int limit) {
        return this.fetch(limit).size();
    }

    @Override
    public int count(int limit, Object offset) {
        return this.fetch(limit, offset).size();
    }

    private List<T> map(int offset, List<Entity> entities) {
        List<T> result = this.pm.mapEntities(entities, this.clazz);
        this.nextOffset = offset + result.size();
        return result;
    }

    @Override
    public List<T> fetch() {
        return this.map(0, this.prepare().asList(FetchOptions.Builder.withChunkSize((int)20)));
    }

    @Override
    public List<T> fetch(int limit) {
        return this.map(0, this.prepare().asList(FetchOptions.Builder.withLimit((int)limit)));
    }

    @Override
    public List<T> fetch(int limit, Object offset) {
        return this.map((Integer)offset, this.prepare().asList(FetchOptions.Builder.withLimit((int)limit).offset(((Integer)offset).intValue())));
    }

    private PreparedQuery prepare() {
        return this.pm.getDatastoreService().prepare(this.q);
    }

    @Override
    public Query<T> filter(String field, Object value) {
        Query.FilterOperator op = Query.FilterOperator.EQUAL;
        for (String operator : supportedOperators.keySet()) {
            if (!field.endsWith(operator)) continue;
            op = supportedOperators.get(operator);
            field = field.substring(0, field.length() - operator.length());
            break;
        }
        field = field.trim();
        Field f = null;
        try {
            f = this.clazz.getDeclaredField(field);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        String propertyName = ClassInfo.getColumnNames(f)[0];
        if (value != null && ClassInfo.isModel(value.getClass())) {
            Key key = this.pm.getKey(value);
            this.q.addFilter(propertyName, op, (Object)key);
        } else if (ClassInfo.isId(f)) {
            if (value instanceof String) {
                value = Long.parseLong(value.toString());
            }
            Key key = KeyFactory.createKey((String)ClassInfo.getClassInfo(this.clazz).tableName, (long)((Long)value));
            this.q.addFilter("__key__", op, (Object)key);
        } else {
            this.q.addFilter(propertyName, op, value);
        }
        return this;
    }

    @Override
    public T get() {
        List<T> list = this.fetch(1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Iterable<T> iter(String field, int max) {
        return new IterableQuery(this, max, field);
    }

    @Override
    public Query<T> order(String field) {
        Field f;
        Query.SortDirection dir = Query.SortDirection.ASCENDING;
        if (field.startsWith("-")) {
            field = field.substring(1);
            dir = Query.SortDirection.DESCENDING;
        }
        try {
            f = this.clazz.getDeclaredField(field);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        if (ClassInfo.isId(f)) {
            this.q.addSort("__key__");
        } else {
            this.q.addSort(ClassInfo.getColumnNames(f)[0], dir);
        }
        return this;
    }

    @Override
    public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
        return null;
    }

    @Override
    public GaeQuery<T> clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object nextOffset() {
        return this.nextOffset;
    }

    @Override
    public int delete() {
        return 0;
    }

    @Override
    public List<T> fetchKeys() {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit) {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit, Object offset) {
        return null;
    }
}

