/*
 * Decompiled with CFR 0.152.
 */
package siena.embed;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import siena.Json;
import siena.SienaException;
import siena.embed.At;
import siena.embed.EmbeddedList;
import siena.embed.EmbeddedMap;
import siena.embed.Format;
import siena.embed.Key;

public class JsonSerializer {
    public static Json serialize(Object obj) {
        return JsonSerializer.serialize(obj, null);
    }

    public static Json serialize(Object obj, Field f) {
        Format format;
        if (obj == null) {
            return new Json(null);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            Json result = Json.map();
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Json value = JsonSerializer.serialize(entry.getValue(), null);
                result.put(key, value);
            }
            return result;
        }
        if (obj instanceof Collection) {
            Json result = Json.list(new Object[0]);
            Collection col = (Collection)obj;
            for (Object object : col) {
                result.add(JsonSerializer.serialize(object));
            }
            return result;
        }
        try {
            EmbeddedList list = obj.getClass().getAnnotation(EmbeddedList.class);
            if (list != null) {
                return JsonSerializer.serializeList(obj);
            }
            EmbeddedMap map = obj.getClass().getAnnotation(EmbeddedMap.class);
            if (map != null) {
                return JsonSerializer.serializeMap(obj);
            }
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        if (f != null && (format = f.getAnnotation(Format.class)) != null && obj.getClass() == Date.class) {
            Date date = (Date)obj;
            SimpleDateFormat sdf = new SimpleDateFormat(format.value());
            return new Json(sdf.format(date));
        }
        return new Json(obj);
    }

    private static Json serializeMap(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        Json result = Json.map();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!JsonSerializer.mustIgnore(f)) {
                Key k = f.getAnnotation(Key.class);
                if (k != null) {
                    result.put(k.value(), JsonSerializer.serialize(f.get(obj), f));
                } else {
                    result.put(f.getName(), JsonSerializer.serialize(f.get(obj), f));
                }
            }
            ++n2;
        }
        return result;
    }

    private static Json serializeList(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        Json result = Json.list(new Object[0]);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!JsonSerializer.mustIgnore(f)) {
                At at = f.getAnnotation(At.class);
                if (at == null) {
                    throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                }
                result.addAt(at.value(), JsonSerializer.serialize(f.get(obj), f));
            }
            ++n2;
        }
        return result;
    }

    private static Class<?> getGenericClass(Field f, int n) {
        Type genericFieldType = f.getGenericType();
        if (genericFieldType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            return (Class)fieldArgTypes[n];
        }
        return null;
    }

    public static Object deserialize(Class<?> clazz, Json data) {
        try {
            EmbeddedList list = clazz.getAnnotation(EmbeddedList.class);
            if (list != null) {
                Field[] fields;
                if (!data.isList()) {
                    throw new SienaException("Error while deserializating class " + clazz + ". A Json list is needed but found: " + data);
                }
                Object obj = clazz.newInstance();
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (!JsonSerializer.mustIgnore(f)) {
                        At at = f.getAnnotation(At.class);
                        if (at == null) {
                            throw new SienaException("Field " + obj.getClass() + "." + f.getName() + " must be annotated with @At(n)");
                        }
                        Json value = data.at(at.value());
                        f.set(obj, JsonSerializer.deserialize(f, value));
                    }
                    ++n2;
                }
                return obj;
            }
            EmbeddedMap map = clazz.getAnnotation(EmbeddedMap.class);
            if (map != null) {
                Field[] fields;
                if (!data.isMap()) {
                    throw new SienaException("Error while deserializating class " + clazz + ". A Json map is needed but found: " + data);
                }
                Object obj = clazz.newInstance();
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n3 = 0;
                while (n3 < n) {
                    Field f = fieldArray[n3];
                    if (!JsonSerializer.mustIgnore(f)) {
                        Key key = f.getAnnotation(Key.class);
                        if (key != null) {
                            f.set(obj, JsonSerializer.deserialize(f, data.get(key.value())));
                        } else {
                            f.set(obj, JsonSerializer.deserialize(f, data.get(f.getName())));
                        }
                    }
                    ++n3;
                }
                return obj;
            }
            return JsonSerializer.deserializePlain(clazz, data);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    private static boolean mustIgnore(Field field) {
        boolean b;
        boolean bl = b = (field.getModifiers() & 0x80) == 128 || (field.getModifiers() & 8) == 8;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return b;
    }

    public static Object deserialize(Field f, Json data) {
        if (data == null || data.isNull()) {
            return null;
        }
        Class<?> clazz = f.getType();
        if (clazz == Map.class) {
            if (!data.isMap()) {
                throw new SienaException("Error while deserializating field " + f.getDeclaringClass() + "." + f.getName() + " of type " + clazz + ". A Json map is needed but found: " + data);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : data.keys()) {
                map.put(key, JsonSerializer.deserialize(JsonSerializer.getGenericClass(f, 1), data.get(key)));
            }
            return map;
        }
        if (clazz == Collection.class || clazz == List.class || clazz == Set.class) {
            if (!data.isList()) {
                throw new SienaException("Error while deserializating field " + f.getDeclaringClass() + "." + f.getName() + " of type " + clazz + ". A Json list is needed but found: " + data);
            }
            AbstractCollection collection = null;
            collection = clazz == List.class ? new ArrayList(data.size()) : new HashSet();
            for (Json value : data) {
                collection.add(JsonSerializer.deserialize(JsonSerializer.getGenericClass(f, 0), value));
            }
            return collection;
        }
        Format format = f.getAnnotation(Format.class);
        if (format != null && f.getType() == Date.class) {
            SimpleDateFormat sdf = new SimpleDateFormat(format.value());
            try {
                return sdf.parse(data.str());
            }
            catch (ParseException e) {
                throw new SienaException(e);
            }
        }
        return JsonSerializer.deserialize(clazz, data);
    }

    private static Object deserializePlain(Class<?> type, Json data) {
        if (Boolean.class == type || Boolean.TYPE == type) {
            return data.asBoolean();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return data.asBoolean();
        }
        if (type == Short.class || type == Short.TYPE) {
            return data.asShort();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return data.asInt();
        }
        if (type == Long.class || type == Long.TYPE) {
            return data.asLong();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(data.asFloat());
        }
        if (type == Double.class || type == Double.TYPE) {
            return data.asDouble();
        }
        if (type == String.class) {
            return data.str();
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, data.str());
        }
        return null;
    }
}

