/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import siena.ClassInfo;
import siena.Filter;
import siena.PersistenceManager;
import siena.PersistenceManagerFactory;
import siena.Query;
import siena.SienaException;

public abstract class Model {
    private PersistenceManager persistenceManager;

    public Model() {
        this.init();
    }

    public void get() {
        this.getPersistenceManager().get(this);
    }

    public void delete() {
        this.getPersistenceManager().delete(this);
    }

    public void insert() {
        this.getPersistenceManager().insert(this);
    }

    public void update() {
        this.getPersistenceManager().update(this);
    }

    public final PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = PersistenceManagerFactory.getPersistenceManager(this.getClass());
        }
        return this.persistenceManager;
    }

    public static <R> Query<R> all(Class<R> clazz) {
        return PersistenceManagerFactory.getPersistenceManager(clazz).createQuery(clazz);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object a = field.get(this);
                Object b = field.get(that);
                if (!(a == null ? b != null : !a.equals(b))) continue;
                return false;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        List<Field> keys = ClassInfo.getClassInfo(this.getClass()).keys;
        for (Field field : keys) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                result = 31 * result + (value == null ? 0 : value.hashCode());
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        return result;
    }

    private void init() {
        Field[] fields;
        Class<?> clazz = this.getClass();
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Query.class) {
                Filter filter = field.getAnnotation(Filter.class);
                if (filter == null) {
                    throw new SienaException("Found Query<T> field without @Filter annotation at " + clazz.getName() + "." + field.getName());
                }
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class c = (Class)pt.getActualTypeArguments()[0];
                try {
                    field.set(this, new ProxyQuery(c, filter.value(), this));
                }
                catch (Exception e) {
                    throw new SienaException(e);
                }
            }
            ++n2;
        }
    }

    class ProxyQuery<T extends Model>
    implements Query<T> {
        private String filter;
        private Class<T> clazz;
        private Model obj;

        public ProxyQuery(Class<T> clazz, String filter, Model obj) {
            this.filter = filter;
            this.clazz = clazz;
            this.obj = obj;
        }

        private Query<T> createQuery() {
            return Model.this.getPersistenceManager().createQuery(this.clazz).filter(this.filter, this.obj);
        }

        @Override
        public int count() {
            return this.createQuery().count();
        }

        @Override
        public int count(int limit) {
            return this.createQuery().count(limit);
        }

        @Override
        public int count(int limit, Object offset) {
            return this.createQuery().count(limit, offset);
        }

        @Override
        public List<T> fetch() {
            return this.createQuery().fetch();
        }

        @Override
        public List<T> fetch(int limit) {
            return this.createQuery().fetch(limit);
        }

        @Override
        public List<T> fetch(int limit, Object offset) {
            return this.createQuery().fetch(limit, offset);
        }

        @Override
        public Query<T> filter(String fieldName, Object value) {
            return this.createQuery().filter(fieldName, value);
        }

        @Override
        public T get() {
            return (T)((Model)this.createQuery().get());
        }

        @Override
        public Iterable<T> iter(String field, int max) {
            return this.createQuery().iter(field, max);
        }

        @Override
        public Query<T> order(String fieldName) {
            return this.createQuery().order(fieldName);
        }

        @Override
        public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
            return this.createQuery().search(match, inBooleanMode, fieldNames);
        }

        @Override
        public ProxyQuery<T> clone() {
            return new ProxyQuery<T>(this.clazz, this.filter, this.obj);
        }

        @Override
        public Object nextOffset() {
            return null;
        }

        @Override
        public int delete() {
            return this.createQuery().delete();
        }

        @Override
        public List<T> fetchKeys() {
            return this.createQuery().fetchKeys();
        }

        @Override
        public List<T> fetchKeys(int limit) {
            return this.createQuery().fetchKeys(limit);
        }

        @Override
        public List<T> fetchKeys(int limit, Object offset) {
            return this.createQuery().fetchKeys(limit, offset);
        }
    }
}

