/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import siena.ClassInfo;
import siena.DateTime;
import siena.IterableQuery;
import siena.Query;
import siena.SienaException;
import siena.SimpleDate;
import siena.Time;
import siena.Util;
import siena.jdbc.JdbcPersistenceManager;

public class JdbcQuery<T>
implements Query<T> {
    private Class<T> clazz;
    private JdbcPersistenceManager pm;
    private List<String> filter;
    private List<String> order;
    private List<Object> parameters;
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "=", "IN"};
    private int nextOffset;

    private JdbcQuery() {
    }

    public JdbcQuery(Class<T> clazz, JdbcPersistenceManager pm) {
        this.clazz = clazz;
        this.pm = pm;
    }

    @Override
    public List<T> fetch() {
        List<T> result = this.pm.fetch(this.clazz, this.filter, this.parameters, this.order);
        this.nextOffset = result.size();
        return result;
    }

    @Override
    public List<T> fetch(int limit) {
        List<T> result = this.pm.fetch(this.clazz, this.filter, this.parameters, this.order, limit);
        this.nextOffset = result.size();
        return result;
    }

    @Override
    public List<T> fetch(int limit, Object offset) {
        this.nextOffset = (Integer)offset;
        List<T> result = this.pm.fetch(this.clazz, this.filter, this.parameters, this.order, limit, offset);
        this.nextOffset += result.size();
        return result;
    }

    @Override
    public Iterable<T> iter(String field, int max) {
        return new IterableQuery(this, max, field);
    }

    @Override
    public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
        if (this.filter == null) {
            this.filter = new ArrayList<String>();
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        try {
            ArrayList<String> cols = new ArrayList<String>();
            String[] stringArray = fieldNames;
            int n = fieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                String[] columns;
                String field = stringArray[n2];
                Field f = this.clazz.getDeclaredField(field);
                String[] stringArray2 = columns = ClassInfo.getColumnNames(f);
                int n3 = columns.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray2[n4];
                    cols.add(string);
                    ++n4;
                }
                ++n2;
            }
            if (inBooleanMode) {
                this.filter.add("MATCH(" + Util.join(cols, ",") + ") AGAINST(? IN BOOLEAN MODE)");
            } else {
                this.filter.add("MATCH(" + Util.join(cols, ",") + ") AGAINST(?)");
            }
            this.parameters.add(match);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return this;
    }

    @Override
    public JdbcQuery<T> filter(String field, Object value) {
        if (this.filter == null) {
            this.filter = new ArrayList<String>();
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        String op = "=";
        String[] stringArray = supportedOperators;
        int n = supportedOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String operator = stringArray[n2];
            if (field.endsWith(operator)) {
                op = operator;
                field = field.substring(0, field.length() - operator.length());
                break;
            }
            ++n2;
        }
        field = field.trim();
        try {
            Field f = this.clazz.getDeclaredField(field);
            String[] columns = ClassInfo.getColumnNames(f);
            if (op.equals("IN")) {
                if (!(value instanceof Collection)) {
                    throw new SienaException("Collection needed when using IN operator in filter() query");
                }
                StringBuilder s = new StringBuilder();
                Collection col = (Collection)value;
                for (Object object : col) {
                    this.parameters.add(object);
                    s.append(",?");
                }
                this.filter.add(String.valueOf(columns[0]) + " IN(" + s.toString().substring(1) + ")");
            } else if (ClassInfo.isModel(f.getType())) {
                if (!op.equals("=")) {
                    throw new SienaException("Unsupported operator for relationship: " + op);
                }
                JdbcPersistenceManager.JdbcClassInfo classInfo = this.pm.getClassInfo(f.getType());
                int i = 0;
                this.pm.checkForeignKeyMapping(classInfo.keys, columns, this.clazz, f);
                for (Field key : classInfo.keys) {
                    if (value == null) {
                        this.filter.add(String.valueOf(columns[i++]) + " IS NULL");
                        continue;
                    }
                    this.filter.add(String.valueOf(columns[i++]) + "=?");
                    key.setAccessible(true);
                    Object o = key.get(value);
                    this.parameters.add(o);
                }
            } else if (value == null && op.equals("=")) {
                this.filter.add(String.valueOf(columns[0]) + " IS NULL");
            } else {
                this.filter.add(String.valueOf(columns[0]) + op + "?");
                if (value == null) {
                    this.parameters.add(0);
                } else {
                    if (value instanceof java.util.Date) {
                        value = this.translateDate(f, (java.util.Date)value);
                    }
                    this.parameters.add(value);
                }
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        return this;
    }

    private Object translateDate(Field f, java.util.Date value) {
        long t = value.getTime();
        SimpleDate simpleDate = f.getAnnotation(SimpleDate.class);
        if (simpleDate != null) {
            return new Date(t);
        }
        DateTime dateTime = f.getAnnotation(DateTime.class);
        if (dateTime != null) {
            return new Timestamp(t);
        }
        Time time = f.getAnnotation(Time.class);
        if (time != null) {
            return new java.sql.Time(t);
        }
        return new Timestamp(t);
    }

    @Override
    public T get() {
        List<T> list = this.fetch(1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public JdbcQuery<T> order(String field) {
        if (this.order == null) {
            this.order = new ArrayList<String>();
        }
        if (field.startsWith("-")) {
            String[] columns;
            field = field.substring(1);
            String[] stringArray = columns = this.pm.getColumnNames(this.clazz, field);
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                this.order.add(String.valueOf(column) + " DESC");
                ++n2;
            }
        } else {
            String[] columns;
            String[] stringArray = columns = this.pm.getColumnNames(this.clazz, field);
            int n = columns.length;
            int n3 = 0;
            while (n3 < n) {
                String column = stringArray[n3];
                this.order.add(column);
                ++n3;
            }
        }
        return this;
    }

    @Override
    public int count() {
        return this.pm.count(this.clazz, this.filter, this.parameters);
    }

    @Override
    public int count(int limit) {
        return this.pm.count(this.clazz, this.filter, this.parameters, limit);
    }

    @Override
    public int count(int limit, Object offset) {
        return this.pm.count(this.clazz, this.filter, this.parameters, limit, offset);
    }

    @Override
    public JdbcQuery<T> clone() {
        JdbcQuery<T> t = new JdbcQuery<T>();
        t.clazz = this.clazz;
        t.pm = this.pm;
        if (this.filter != null) {
            t.filter = new ArrayList<String>(this.filter);
        }
        if (this.order != null) {
            t.order = new ArrayList<String>(this.order);
        }
        if (this.parameters != null) {
            t.parameters = new ArrayList<Object>(this.parameters);
        }
        return t;
    }

    @Override
    public Object nextOffset() {
        return this.nextOffset;
    }

    @Override
    public int delete() {
        return this.pm.delete(this.clazz, this.filter, this.parameters);
    }

    @Override
    public List<T> fetchKeys() {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit) {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit, Object offset) {
        return null;
    }
}

