/*
 * Decompiled with CFR 0.152.
 */
package play.modules.siena;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;
import play.Play;
import play.PlayPlugin;
import play.vfs.VirtualFile;
import siena.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SienaFixture {
    static Pattern keyPattern = Pattern.compile("([^(]+)\\(([^)]+)\\)");

    public static void deleteAll() throws Exception {
        File modelDir = new File("app/models");
        if (modelDir.isDirectory()) {
            File[] listFiles;
            for (File file : listFiles = modelDir.listFiles()) {
                String name = "models." + file.getName().substring(0, file.getName().indexOf(".java"));
                Class modelClass = Play.classloader.loadClass(name);
                Model cfr_ignored_0 = (Model)modelClass.newInstance();
                List models = Model.all((Class)modelClass).fetch();
                for (Model model : models) {
                    model.delete();
                }
            }
        }
    }

    public static void load(String name) throws Exception {
        VirtualFile vf;
        VirtualFile yamlFile = null;
        Iterator i$ = Play.javaPath.iterator();
        while (i$.hasNext() && ((yamlFile = (vf = (VirtualFile)i$.next()).child(name)) == null || !yamlFile.exists())) {
        }
        InputStream is = Play.classloader.getResourceAsStream(name);
        if (is == null) {
            throw new RuntimeException("Cannot load fixture " + name + ", the file was not found");
        }
        Yaml yaml = new Yaml();
        Object o = yaml.load(is);
        if (o instanceof LinkedHashMap) {
            LinkedHashMap objects = (LinkedHashMap)o;
            HashMap<String, Model> idCache = new HashMap<String, Model>();
            for (Object key : objects.keySet()) {
                Matcher matcher = keyPattern.matcher(key.toString().trim());
                if (!matcher.matches()) continue;
                String type = matcher.group(1);
                String id = matcher.group(2);
                if (!type.startsWith("models.")) {
                    type = "models." + type;
                }
                if (idCache.containsKey(type + "-" + id)) {
                    throw new RuntimeException("Cannot load fixture " + name + ", duplicate id '" + id + "' for type " + type);
                }
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                if (objects.get(key) == null) {
                    objects.put(key, new HashMap());
                }
                SienaFixture.serialize((Map)objects.get(key), "object", params);
                Class cType = Play.classloader.loadClass(type);
                Model model = (Model)cType.newInstance();
                for (Field f : model.getClass().getFields()) {
                    if (f.getName().equals("id")) continue;
                    if (f.getType().isAssignableFrom(Map.class)) {
                        f.set(model, ((Map)objects.get(key)).get(f.getName()));
                        continue;
                    }
                    if (Model.class.isAssignableFrom(f.getType())) {
                        String k = f.getType().getName() + "-" + ((Map)objects.get(key)).get(f.getName());
                        Object value = null;
                        Object v = idCache.get(k);
                        value = v;
                        if (v != null) {
                            f.set(model, value);
                            continue;
                        }
                        throw new RuntimeException("Cannot load fixture " + name + ", can not find reference id '" + k + "' for type " + type);
                    }
                    Object value = ((Map)objects.get(key)).get(f.getName());
                    if (value == null) continue;
                    if (f.getType().isAssignableFrom(Long.class)) {
                        if (value.getClass().isAssignableFrom(Integer.class)) {
                            f.set(model, ((Integer)value).longValue());
                            continue;
                        }
                        if (value.getClass().isAssignableFrom(Long.class)) {
                            f.set(model, (Long)value);
                            continue;
                        }
                        throw new RuntimeException("Cannot load fixture " + name + ", type " + value.getClass().getName() + " not compatible for field of type " + f.getType().getName());
                    }
                    if (f.getType().isAssignableFrom(Integer.class)) {
                        if (value.getClass().isAssignableFrom(Integer.class)) {
                            f.set(model, (Integer)value);
                            continue;
                        }
                        throw new RuntimeException("Cannot load fixture " + name + ", type " + value.getClass().getName() + " not compatible for field of type " + f.getType().getName());
                    }
                    if (f.getType().isAssignableFrom(Short.class)) {
                        if (value.getClass().isAssignableFrom(Integer.class)) {
                            f.set(model, ((Integer)value).shortValue());
                            continue;
                        }
                        if (value.getClass().isAssignableFrom(Short.class)) {
                            f.set(model, (Short)value);
                            continue;
                        }
                        throw new RuntimeException("Cannot load fixture " + name + ", type " + value.getClass().getName() + " not compatible for field of type " + f.getType().getName());
                    }
                    f.set(model, value);
                }
                model.insert();
                idCache.put(cType.getName() + "-" + id, model);
            }
        }
        for (PlayPlugin plugin : Play.plugins) {
            plugin.afterFixtureLoad();
        }
    }

    static void serialize(Map<?, ?> values, String prefix, Map<String, String[]> serialized) {
        for (Object key : values.keySet()) {
            Object value = values.get(key);
            if (value == null) continue;
            if (value instanceof Map) {
                SienaFixture.serialize((Map)value, prefix + "." + key, serialized);
                continue;
            }
            if (value instanceof Date) {
                serialized.put(prefix + "." + key.toString(), new String[]{new SimpleDateFormat("'ISO8601:'yyyy-MM-dd'T'HH:mm:ssZ").format((Date)value)});
                continue;
            }
            if (value instanceof List) {
                List l = (List)value;
                String[] r = new String[l.size()];
                int i = 0;
                for (Object el : l) {
                    r[i++] = el.toString();
                }
                serialized.put(prefix + "." + key.toString(), r);
                continue;
            }
            if (value instanceof String && value.toString().matches("<<<\\s*\\{[^}]+}\\s*")) {
                Matcher m = Pattern.compile("<<<\\s*\\{([^}]+)}\\s*").matcher(value.toString());
                m.find();
                String file = m.group(1);
                VirtualFile f = Play.getVirtualFile((String)file);
                if (f == null || !f.exists()) continue;
                serialized.put(prefix + "." + key.toString(), new String[]{f.contentAsString()});
                continue;
            }
            serialized.put(prefix + "." + key.toString(), new String[]{value.toString()});
        }
    }
}

