/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc.ddl;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import siena.ClassInfo;
import siena.DateTime;
import siena.Generator;
import siena.Id;
import siena.Index;
import siena.Json;
import siena.Max;
import siena.NotNull;
import siena.SienaException;
import siena.SimpleDate;
import siena.Text;
import siena.Time;
import siena.Unique;
import siena.embed.Embedded;

public class DdlGenerator {
    private Map<String, Table> tables = new HashMap<String, Table>();
    private Database database = new Database();

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public Database getDatabase() {
        return this.database;
    }

    public Table addTable(Class<?> clazz) {
        Table table = new Table();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        table.setName(info.tableName);
        this.database.addTable(table);
        for (Field field : info.allFields) {
            String[] columns = ClassInfo.getColumnNames(field);
            boolean notNull = field.getAnnotation(NotNull.class) != null;
            Class<?> type = field.getType();
            if (!ClassInfo.isModel(type)) {
                Id id;
                Column column = this.createColumn(clazz, field, columns[0]);
                if (notNull || type.isPrimitive()) {
                    column.setRequired(true);
                    if (type.isPrimitive() && !ClassInfo.isId(field)) {
                        if (type == Boolean.TYPE) {
                            column.setDefaultValue("false");
                        } else {
                            column.setDefaultValue("0");
                        }
                    }
                }
                if ((id = field.getAnnotation(Id.class)) != null) {
                    column.setPrimaryKey(true);
                    column.setRequired(true);
                    if (id.value() == Generator.AUTO_INCREMENT) {
                        column.setAutoIncrement(true);
                    }
                }
                table.addColumn(column);
                continue;
            }
            List<Field> keys = ClassInfo.getClassInfo(type).keys;
            int i = 0;
            while (i < columns.length) {
                Field f = keys.get(i);
                Column column = this.createColumn(clazz, f, columns[i]);
                if (notNull) {
                    column.setRequired(true);
                }
                table.addColumn(column);
                ++i;
            }
        }
        HashMap<String, UniqueIndex> uniques = new HashMap<String, UniqueIndex>();
        HashMap<String, NonUniqueIndex> indexes = new HashMap<String, NonUniqueIndex>();
        for (Field field : info.updateFields) {
            String[] names;
            Unique unique;
            Index index = field.getAnnotation(Index.class);
            if (index != null) {
                String[] names2;
                String[] stringArray = names2 = index.value();
                int n = names2.length;
                int f = 0;
                while (f < n) {
                    String name = stringArray[f];
                    NonUniqueIndex i = (NonUniqueIndex)indexes.get(name);
                    if (i == null) {
                        i = new NonUniqueIndex();
                        i.setName(name);
                        indexes.put(name, i);
                        table.addIndex((org.apache.ddlutils.model.Index)i);
                    }
                    this.fillIndex((org.apache.ddlutils.model.Index)i, field);
                    ++f;
                }
            }
            if ((unique = field.getAnnotation(Unique.class)) == null) continue;
            String[] stringArray = names = unique.value();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                UniqueIndex i = (UniqueIndex)uniques.get(name);
                if (i == null) {
                    i = new UniqueIndex();
                    i.setName(name);
                    uniques.put(name, i);
                    table.addIndex((org.apache.ddlutils.model.Index)i);
                }
                this.fillIndex((org.apache.ddlutils.model.Index)i, field);
                ++n2;
            }
        }
        this.tables.put(table.getName(), table);
        return table;
    }

    private void fillIndex(org.apache.ddlutils.model.Index i, Field field) {
        String[] columns;
        String[] stringArray = columns = ClassInfo.getColumnNames(field);
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IndexColumn ic = new IndexColumn(string);
            i.addColumn(ic);
            ++n2;
        }
    }

    private Column createColumn(Class<?> clazz, Field field, String col) {
        int columnType;
        Class<?> type = field.getType();
        Column column = new Column();
        column.setName(col);
        if (type == Byte.class || type == Byte.TYPE) {
            columnType = -6;
        } else if (type == Short.class || type == Short.TYPE) {
            columnType = 5;
        } else if (type == Integer.class || type == Integer.TYPE) {
            columnType = 4;
        } else if (type == Long.class || type == Long.TYPE) {
            columnType = -5;
        } else if (type == Float.class || type == Float.TYPE) {
            columnType = 6;
        } else if (type == Double.class || type == Double.TYPE) {
            columnType = 8;
        } else if (type == String.class) {
            if (field.getAnnotation(Text.class) != null) {
                columnType = -1;
            } else {
                columnType = 12;
                Max max = field.getAnnotation(Max.class);
                if (max == null) {
                    throw new SienaException("Field " + field.getName() + " in class " + clazz.getName() + " doesn't have a @Max annotation");
                }
                column.setSize("" + max.value());
            }
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            columnType = 16;
        } else if (type == Date.class) {
            columnType = field.getAnnotation(DateTime.class) != null ? 93 : (field.getAnnotation(Time.class) != null ? 92 : (field.getAnnotation(SimpleDate.class) != null ? 91 : 93));
        } else if (type == Json.class) {
            columnType = -1;
        } else {
            Embedded embedded = field.getAnnotation(Embedded.class);
            if (embedded != null) {
                columnType = -1;
            } else {
                throw new SienaException("Unsupported type for field " + clazz.getName() + "." + field.getName());
            }
        }
        column.setTypeCode(columnType);
        return column;
    }
}

