/*
 * Decompiled with CFR 0.152.
 */
package siena.remote;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import siena.ClassInfo;
import siena.IterableQuery;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.remote.Common;
import siena.remote.RemotePersistenceManager;

public class RemoteQuery<T>
implements Query<T> {
    private Document request;
    private RemotePersistenceManager pm;
    private Class<?> clazz;

    public RemoteQuery(RemotePersistenceManager pm, Class<?> clazz) {
        this.clazz = clazz;
        this.pm = pm;
        this.request = pm.createRequest("query");
        this.request.getRootElement().addAttribute("class", clazz.getName());
    }

    @Override
    public List<T> fetch() {
        Document response = this.pm.send(this.request);
        Element root = response.getRootElement();
        if ("error".equals(root.getName())) {
            throw new SienaException(String.valueOf(root.attributeValue("class")) + " " + root.getText());
        }
        List result = response.getRootElement().elements("object");
        ArrayList<Model> list = new ArrayList<Model>(result.size());
        for (Element element : result) {
            list.add(Common.parseEntity(element, null));
        }
        return list;
    }

    @Override
    public List<T> fetch(int limit) {
        this.request.getRootElement().addAttribute("limit", Integer.toString(limit));
        return this.fetch();
    }

    @Override
    public List<T> fetch(int limit, Object offset) {
        this.request.getRootElement().addAttribute("limit", Integer.toString(limit));
        this.request.getRootElement().addAttribute("offset", offset.toString());
        return this.fetch();
    }

    @Override
    public Query<T> filter(String fieldName, Object value) {
        Element filter = this.request.getRootElement().addElement("filter");
        filter.addAttribute("field", fieldName);
        Field f = null;
        try {
            f = this.clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        if (value != null) {
            if (ClassInfo.isModel(value.getClass())) {
                Common.fillRequestElement((Model)value, filter, true);
            } else {
                filter.setText(Util.toString(f, value));
            }
        }
        return this;
    }

    @Override
    public T get() {
        List<T> list = this.fetch(1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Query<T> order(String fieldName) {
        this.request.getRootElement().addElement("order").addAttribute("field", fieldName);
        return this;
    }

    @Override
    public int count() {
        return this.fetch().size();
    }

    @Override
    public int count(int limit) {
        return this.fetch(limit).size();
    }

    @Override
    public int count(int limit, Object offset) {
        return this.fetch(limit, offset).size();
    }

    @Override
    public Iterable<T> iter(String field, int max) {
        return new IterableQuery(this, max, field);
    }

    @Override
    public Query<T> search(String match, boolean inBooleanMode, String ... fieldNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RemoteQuery<T> clone() {
        RemoteQuery<T> clone = new RemoteQuery<T>(this.pm, this.clazz);
        clone.request = (Document)this.request.clone();
        return clone;
    }

    @Override
    public Object nextOffset() {
        return null;
    }

    @Override
    public int delete() {
        return 0;
    }

    @Override
    public List<T> fetchKeys() {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit) {
        return null;
    }

    @Override
    public List<T> fetchKeys(int limit, Object offset) {
        return null;
    }
}

