/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.db2;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class Db2Builder
extends SqlBuilder {
    public Db2Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("GENERATED BY DEFAULT AS IDENTITY");
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP PRIMARY KEY");
        this.printEndOfStatement();
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn)) && !ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn)) {
            this.printIdentifier(this.getColumnName(sourceColumn));
        } else {
            String type = this.getSqlType(targetColumn);
            if (TypeMap.isNumericType(sourceColumn.getTypeCode()) && "VARCHAR".equalsIgnoreCase(targetNativeType)) {
                Object sizeSpec = targetColumn.getSize();
                if (sizeSpec == null) {
                    sizeSpec = this.getPlatformInfo().getDefaultSize(targetColumn.getTypeCode());
                }
                type = "CHAR(" + sizeSpec.toString() + ")";
            }
            this.print("CAST(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            this.print(type);
            this.print(")");
        }
    }
}

