/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import siena.Column;
import siena.Generator;
import siena.Id;
import siena.Join;
import siena.Json;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Table;
import siena.core.lifecycle.LifeCyclePhase;
import siena.core.lifecycle.LifeCycleUtils;
import siena.embed.Embedded;

public class ClassInfo {
    protected static Map<Class<?>, ClassInfo> infoClasses = new ConcurrentHashMap();
    public Class<?> clazz;
    public String tableName;
    public List<Field> keys = new ArrayList<Field>();
    public List<Field> insertFields = new ArrayList<Field>();
    public List<Field> updateFields = new ArrayList<Field>();
    public List<Field> generatedKeys = new ArrayList<Field>();
    public List<Field> allFields = new ArrayList<Field>();
    public List<Field> joinFields = new ArrayList<Field>();
    public Map<LifeCyclePhase, List<Method>> lifecycleMethods = new HashMap<LifeCyclePhase, List<Method>>();

    protected ClassInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.tableName = this.getTableName(clazz);
        Field[] fields = clazz.getDeclaredFields();
        AccessibleObject[] accessibleObjectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            Class<?> type = field.getType();
            if (type != Class.class && type != Query.class && (field.getModifiers() & 0x80) != 128 && (field.getModifiers() & 8) != 8 && !field.isSynthetic()) {
                Id id = field.getAnnotation(Id.class);
                if (id != null) {
                    if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                        this.generatedKeys.add(field);
                    } else {
                        this.insertFields.add(field);
                    }
                    this.keys.add(field);
                } else {
                    this.updateFields.add(field);
                    this.insertFields.add(field);
                }
                if (field.getAnnotation(Join.class) != null) {
                    if (!ClassInfo.isModel(field.getType())) {
                        throw new SienaException("Join not possible: Field " + field.getName() + " is not a relation field");
                    }
                    this.joinFields.add(field);
                }
                this.allFields.add(field);
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getDeclaredMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject m = accessibleObjectArray[n2];
            List<LifeCyclePhase> lcps = LifeCycleUtils.getMethodLifeCycles((Method)m);
            for (LifeCyclePhase lcp : lcps) {
                List<Method> methods = this.lifecycleMethods.get((Object)lcp);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    this.lifecycleMethods.put(lcp, methods);
                }
                methods.add((Method)m);
            }
            ++n2;
        }
    }

    private String getTableName(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        if (t == null) {
            return clazz.getSimpleName();
        }
        return t.value();
    }

    public List<String> getUpdateFieldsColumnNames() {
        ArrayList<String> strs = new ArrayList<String>(this.updateFields.size());
        for (Field field : this.updateFields) {
            Column c = field.getAnnotation(Column.class);
            if (c != null && c.value().length > 0) {
                strs.add(c.value()[0]);
                continue;
            }
            if (ClassInfo.isModel(field.getType())) {
                ClassInfo ci = ClassInfo.getClassInfo(field.getType());
                for (Field key : ci.keys) {
                    Collections.addAll(strs, ClassInfo.getColumnNames(key));
                }
                continue;
            }
            strs.add(field.getName());
        }
        return strs;
    }

    public static String[] getColumnNames(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{field.getName()};
    }

    public static String[] getColumnNamesWithPrefix(Field field, String prefix) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            String[] cols = c.value();
            int i = 0;
            while (i < cols.length) {
                cols[i] = String.valueOf(prefix) + cols[i];
                ++i;
            }
            return cols;
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(prefix) + field.getName() + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{String.valueOf(prefix) + field.getName()};
    }

    public static String[] getColumnNames(Field field, String tableName) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            if (tableName != null && !"".equals(tableName)) {
                String[] cols = c.value();
                int i = 0;
                while (i < cols.length) {
                    cols[i] = String.valueOf(tableName) + "." + cols[i];
                    ++i;
                }
                return cols;
            }
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            if (ci.keys.size() == 1) {
                return new String[]{field.getName()};
            }
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNamesWithPrefix(key, String.valueOf(field.getName()) + "_")));
            }
            return keys.toArray(new String[keys.size()]);
        }
        if (tableName != null && !"".equals(tableName)) {
            return new String[]{String.valueOf(tableName) + "." + field.getName()};
        }
        return new String[]{field.getName()};
    }

    public static boolean isModel(Class<?> type) {
        if (Model.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.getName().startsWith("java.")) {
            return false;
        }
        if (Json.class.isAssignableFrom(type)) {
            return false;
        }
        return !ClassInfo.getClassInfo(type).keys.isEmpty();
    }

    public static boolean isId(Field field) {
        return field.getAnnotation(Id.class) != null;
    }

    public static boolean isEmbedded(Field field) {
        return field.getAnnotation(Embedded.class) != null;
    }

    public static boolean isGenerated(Field field) {
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            Class<?> type = field.getType();
            if (id.value() == Generator.AUTO_INCREMENT && (Long.TYPE == type || Long.class.isAssignableFrom(type))) {
                return true;
            }
            if (id.value() == Generator.UUID && (String.class.isAssignableFrom(type) || UUID.class.isAssignableFrom(type))) {
                return true;
            }
        }
        return false;
    }

    public static Field getIdField(Class<?> clazz) {
        List<Field> keys = ClassInfo.getClassInfo(clazz).keys;
        if (keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + clazz.getName());
        }
        if (keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + clazz.getName());
        }
        return keys.get(0);
    }

    public Field getIdField() {
        if (this.keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + this.tableName);
        }
        if (this.keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + this.tableName);
        }
        return this.keys.get(0);
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        ClassInfo ci = infoClasses.get(clazz);
        if (ci == null) {
            ci = new ClassInfo(clazz);
            infoClasses.put(clazz, ci);
        }
        return ci;
    }

    public List<Method> getLifeCycleMethod(LifeCyclePhase lcp) {
        return this.lifecycleMethods.get((Object)lcp);
    }
}

