/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import siena.Parser;
import siena.SienaException;

public class Json
implements Iterable<Json> {
    private Object object;
    private Map<String, Json> map;
    private List<Json> list;

    public Json(Object object) {
        if (object == null) {
            this.object = object;
            return;
        }
        Class<?> clazz = object.getClass();
        if (object == null || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            this.object = object;
        } else if (clazz.isEnum()) {
            this.object = ((Enum)object).name();
        } else if (Json.class.isAssignableFrom(clazz)) {
            this.map = ((Json)object).map;
            this.list = ((Json)object).list;
            this.object = ((Json)object).object;
        } else if (Map.class.isAssignableFrom(clazz)) {
            this.map = new HashMap<String, Json>();
            Map m = (Map)object;
            for (Map.Entry entry : m.entrySet()) {
                this.put(entry.getKey().toString(), entry.getValue());
            }
            this.object = null;
        } else {
            if (Collection.class.isAssignableFrom(clazz)) {
                object = ((Collection)object).toArray();
                this.list = new ArrayList<Json>();
                this.add(object);
                this.object = null;
                return;
            }
            if (clazz.isArray()) {
                this.list = new ArrayList<Json>();
                this.add(object);
                this.object = null;
            } else {
                throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
            }
        }
    }

    private Json() {
    }

    public static Json map() {
        Json json = new Json();
        json.map = new HashMap<String, Json>();
        return json;
    }

    public static Json sortedMap() {
        Json json = new Json();
        json.map = new TreeMap<String, Json>();
        return json;
    }

    public static Json list(Object ... objects) {
        Json json = new Json();
        json.list = new ArrayList<Json>();
        json.add(objects);
        return json;
    }

    private Json wrap(Object object) {
        if (object instanceof Json) {
            return (Json)object;
        }
        return new Json(object);
    }

    public Json add(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.list.add(this.wrap(object));
            ++n2;
        }
        return this;
    }

    public Json addAt(int index, Object object) {
        this.list.add(index, this.wrap(object));
        return this;
    }

    public Json removeAt(int index) {
        this.list.remove(index);
        return this;
    }

    public int indexOf(Object value) {
        return this.list.indexOf(this.wrap(value));
    }

    public Json get(String key) {
        return this.map.get(key);
    }

    public Json put(String key, Object value) {
        this.map.put(key, this.wrap(value));
        return this;
    }

    public Json putAll(Json json) {
        Set<String> keys = json.keys();
        for (String key : keys) {
            this.put(key, json.get(key));
        }
        return this;
    }

    public Json addAll(Json json) {
        for (Json js : json) {
            this.add(js);
        }
        return this;
    }

    public Json removeAll(Json json) {
        block3: {
            block2: {
                if (!json.isList()) break block2;
                for (Json js : json) {
                    this.remove(js);
                }
                break block3;
            }
            if (!json.isMap()) break block3;
            for (String key : json.keys()) {
                this.remove(key);
            }
        }
        return this;
    }

    public Json at(int index) {
        if (index >= this.list.size()) {
            return new Json();
        }
        return this.list.get(index);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object obj) {
        return this.map.containsValue(this.wrap(obj));
    }

    public boolean contains(Object obj) {
        return this.list.contains(this.wrap(obj));
    }

    public Collection<Json> values() {
        return this.map.values();
    }

    public boolean remove(Object obj) {
        if (this.list != null) {
            return this.list.remove(this.wrap(obj));
        }
        if (this.map != null) {
            return this.map.remove(obj) != null;
        }
        return false;
    }

    public void sumIntegers(Json other) {
        for (String key : other.keys()) {
            Json value = this.get(key);
            if (value == null) {
                this.put(key, other.get(key));
                continue;
            }
            this.put(key, value.asLong() + other.get(key).asLong());
        }
    }

    public void sumReals(Json other) {
        for (String key : other.keys()) {
            Json value = this.get(key);
            if (value == null) {
                this.put(key, other.get(key));
                continue;
            }
            this.put(key, value.asDouble() + other.get(key).asDouble());
        }
    }

    public void sumInteger(String key, long value) {
        if (this.containsKey(key)) {
            value += this.get(key).asLong();
        }
        this.put(key, value);
    }

    public void sumReal(String key, double value) {
        if (this.containsKey(key)) {
            value += this.get(key).asDouble().doubleValue();
        }
        this.put(key, value);
    }

    public void putDefault(String key, Object value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    public int size() {
        if (this.map != null) {
            return this.map.size();
        }
        if (this.list != null) {
            return this.list.size();
        }
        return 1;
    }

    @Override
    public Iterator<Json> iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        if (this.map != null) {
            return this.map.values().iterator();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void formatString(Writer writer, String s) throws IOException {
        writer.write(34);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    break;
                }
                case '\b': {
                    writer.write("\\b");
                    break;
                }
                case '\f': {
                    writer.write("\\f");
                    break;
                }
                case '\n': {
                    writer.write("\\n");
                    break;
                }
                case '\r': {
                    writer.write("\\r");
                    break;
                }
                case '\t': {
                    writer.write("\\t");
                    break;
                }
                default: {
                    writer.write(c);
                }
            }
            ++i;
        }
        writer.write("\"");
    }

    public void format(Writer writer, Object o) throws IOException {
        if (o instanceof String) {
            this.formatString(writer, (String)o);
        } else {
            writer.write(o.toString());
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer);
        }
        catch (IOException e) {
            throw new SienaException(e);
        }
        return writer.toString();
    }

    public void write(Writer writer) throws IOException {
        if (this.object != null) {
            this.format(writer, this.object);
            return;
        }
        if (this.map != null) {
            if (this.map.isEmpty()) {
                writer.write("{}");
                return;
            }
            writer.write("{");
            boolean first = true;
            for (Map.Entry<String, Json> entry : this.map.entrySet()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                this.formatString(writer, entry.getKey());
                writer.write(": ");
                entry.getValue().write(writer);
            }
            writer.write("}");
            return;
        }
        if (this.list != null) {
            if (this.list.isEmpty()) {
                writer.write("[]");
                return;
            }
            writer.write("[");
            boolean first = true;
            for (Json obj : this.list) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                obj.write(writer);
            }
            writer.write("]");
            return;
        }
        writer.write("null");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Json other = (Json)obj;
        if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
            return false;
        }
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    /*
     * Unable to fully structure code
     */
    public boolean equalsTo(Json other) {
        block12: {
            block11: {
                if (other == null) {
                    return false;
                }
                if (this == other) {
                    return true;
                }
                if (this.object != null) {
                    if (this.isNumber()) {
                        if (!other.isNumber()) {
                            return false;
                        }
                        return Double.doubleToLongBits(this.asDouble()) == Double.doubleToLongBits(other.asDouble());
                    }
                    return this.object.equals(other.object);
                }
                if (this.list == null) break block11;
                if (other.list == null) {
                    return false;
                }
                size = this.list.size();
                if (other.list.size() == size) ** GOTO lbl19
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.list.get(size).equalsTo(other.list.get(size))) continue;
                    return false;
lbl19:
                    // 2 sources

                    ** while (size-- > 0)
                }
lbl20:
                // 1 sources

                break block12;
            }
            if (this.map != null) {
                if (other.map == null) {
                    return false;
                }
                size = this.map.size();
                if (other.map.size() != size) {
                    return false;
                }
                for (String key : this.map.keySet()) {
                    value = this.map.get(key);
                    if (value.equalsTo(other.map.get(key))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String str() {
        return this.asString();
    }

    public String asString() {
        if (this.object == null) {
            return null;
        }
        return this.object.toString();
    }

    public boolean bool() {
        return this.asBoolean();
    }

    public boolean asBoolean() {
        if (this.object == null) {
            return false;
        }
        return (Boolean)this.object;
    }

    public int asInt() {
        if (this.object == null) {
            return 0;
        }
        return ((Number)this.object).intValue();
    }

    public short asShort() {
        if (this.object == null) {
            return 0;
        }
        return ((Number)this.object).shortValue();
    }

    public byte asByte() {
        if (this.object == null) {
            return 0;
        }
        return ((Number)this.object).byteValue();
    }

    public long asLong() {
        if (this.object == null) {
            return 0L;
        }
        return ((Number)this.object).longValue();
    }

    public Double asDouble() {
        if (this.object == null) {
            return 0.0;
        }
        return ((Number)this.object).doubleValue();
    }

    public float asFloat() {
        if (this.object == null) {
            return 0.0f;
        }
        return ((Number)this.object).floatValue();
    }

    public boolean isNull() {
        return this.object == null && this.list == null && this.map == null;
    }

    public boolean isNumber() {
        return this.object != null && this.object instanceof Number;
    }

    public boolean isBoolean() {
        return this.object != null && this.object instanceof Boolean;
    }

    public boolean isString() {
        return this.object != null && this.object instanceof String;
    }

    public boolean isMap() {
        return this.map != null;
    }

    public boolean isList() {
        return this.list != null;
    }

    public Json find(Object ... params) {
        Json data = this;
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String && data.isMap()) {
                if ((data = data.get((String)object)) == null) {
                    return null;
                }
            } else if (object instanceof Integer && data.isList()) {
                int value = (Integer)object;
                if (value >= data.size()) {
                    return null;
                }
                data = data.at(value);
            } else {
                return null;
            }
            ++n2;
        }
        return data;
    }

    public static Json loads(String s) {
        return new Parser(s).parse();
    }

    public static Json load(BufferedReader reader) {
        return new Parser(reader).parse();
    }
}

