/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;
import siena.DateTime;
import siena.Json;
import siena.SienaException;
import siena.SimpleDate;
import siena.Time;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.jdbc.JdbcPersistenceManager;

public class Util {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"){
        private static final long serialVersionUID = 1L;
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd"){
        private static final long serialVersionUID = 1L;
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss"){
        private static final long serialVersionUID = 1L;
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };

    public static String join(Collection<String> s, String delimiter) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        return buffer.toString();
    }

    public static String sha1(String message) {
        try {
            byte[] buffer = message.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(buffer);
            byte[] digest = md.digest();
            char[] hash = new char[40];
            int i = 0;
            int n = 0;
            while (i < digest.length) {
                byte aux = digest[i];
                int b = aux & 0xFF;
                String hex = Integer.toHexString(b);
                if (hex.length() == 1) {
                    hash[n++] = 48;
                    hash[n++] = hex.charAt(0);
                } else {
                    hash[n++] = hex.charAt(0);
                    hash[n++] = hex.charAt(1);
                }
                ++i;
            }
            return new String(hash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object fromString(Class<?> type, String value) {
        if (value == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (type == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            if (type == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (type == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (type == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (type == Double.TYPE) {
                return Double.parseDouble(value);
            }
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == Byte.class) {
            return Byte.valueOf(value);
        }
        if (type == Short.class) {
            return Short.valueOf(value);
        }
        if (type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (type == Long.class) {
            return Long.valueOf(value);
        }
        if (type == Float.class) {
            return Float.valueOf(value);
        }
        if (type == Double.class) {
            return Double.valueOf(value);
        }
        if (type == java.util.Date.class) {
            return Util.timestamp(value);
        }
        if (type == Json.class) {
            return Json.loads(value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, value);
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getName());
    }

    public static Object fromString(Class<?> type, String value, boolean retValueIfNotSupported) {
        if (value == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (type == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            if (type == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (type == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (type == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (type == Double.TYPE) {
                return Double.parseDouble(value);
            }
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == Byte.class) {
            return Byte.valueOf(value);
        }
        if (type == Short.class) {
            return Short.valueOf(value);
        }
        if (type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (type == Long.class) {
            return Long.valueOf(value);
        }
        if (type == Float.class) {
            return Float.valueOf(value);
        }
        if (type == Double.class) {
            return Double.valueOf(value);
        }
        if (type == java.util.Date.class) {
            return Util.timestamp(value);
        }
        if (type == Json.class) {
            return Json.loads(value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, value);
        }
        if (!retValueIfNotSupported) {
            throw new IllegalArgumentException("Unsupported type: " + type.getName());
        }
        return value;
    }

    public static java.util.Date timestamp(String s) {
        try {
            return TIMESTAMP_FORMAT.parse(s);
        }
        catch (ParseException e) {
            throw new SienaException(e);
        }
    }

    public static String timestamp(java.util.Date d) {
        return TIMESTAMP_FORMAT.format(d);
    }

    public static java.util.Date time(String s) {
        try {
            return TIME_FORMAT.parse(s);
        }
        catch (ParseException e) {
            throw new SienaException(e);
        }
    }

    public static String time(java.util.Date d) {
        return TIME_FORMAT.format(d);
    }

    public static java.util.Date date(String s) {
        try {
            return DATE_FORMAT.parse(s);
        }
        catch (ParseException e) {
            throw new SienaException(e);
        }
    }

    public static String date(java.util.Date d) {
        return DATE_FORMAT.format(d);
    }

    public static String toString(Field field, Object value) {
        if (value instanceof java.util.Date) {
            if (field.getAnnotation(DateTime.class) != null) {
                return Util.timestamp((java.util.Date)value);
            }
            if (field.getAnnotation(Time.class) != null) {
                return Util.time((java.util.Date)value);
            }
            if (field.getAnnotation(SimpleDate.class) != null) {
                return Util.date((java.util.Date)value);
            }
            return Util.timestamp((java.util.Date)value);
        }
        return value.toString();
    }

    public static Object fromObject(Field field, Object value) {
        if (value == null) {
            if (field.getType().isPrimitive()) {
                return 0;
            }
            return null;
        }
        Class<?> type = field.getType();
        if (Number.class.isAssignableFrom(value.getClass())) {
            Number number = (Number)value;
            if (Byte.TYPE == type || Byte.class == type) {
                return number.byteValue();
            }
            if (Short.TYPE == type || Short.class == type) {
                return number.shortValue();
            }
            if (Integer.TYPE == type || Integer.class == type) {
                return number.intValue();
            }
            if (Long.TYPE == type || Long.class == type) {
                return number.longValue();
            }
            if (Float.TYPE == type || Float.class == type) {
                return Float.valueOf(number.floatValue());
            }
            if (Double.TYPE == type || Double.class == type) {
                return number.doubleValue();
            }
            if (Boolean.TYPE == type || Boolean.class == type) {
                return number != Integer.valueOf(0);
            }
        } else {
            if (String.class.isAssignableFrom(value.getClass()) && Json.class.isAssignableFrom(type)) {
                return Json.loads((String)value);
            }
            if (field.getAnnotation(Embedded.class) != null && String.class.isAssignableFrom(value.getClass())) {
                Json data = Json.loads((String)value);
                return JsonSerializer.deserialize(field, data);
            }
            if (String.class.isAssignableFrom(value.getClass()) && type.isEnum()) {
                return Enum.valueOf(type, (String)value);
            }
            if (String.class.isAssignableFrom(value.getClass()) && type != String.class) {
                return Util.fromString(field.getType(), (String)value, true);
            }
        }
        return value;
    }

    public static void setField(Object object, Field f, Object value) {
        boolean wasAccess = true;
        if (!f.isAccessible()) {
            f.setAccessible(true);
            wasAccess = false;
        }
        try {
            try {
                f.set(object, value);
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        finally {
            if (!wasAccess) {
                f.setAccessible(false);
            }
        }
    }

    public static void setFromObject(Object object, Field f, Object value) throws IllegalArgumentException, IllegalAccessException {
        Util.setField(object, f, Util.fromObject(f, value));
    }

    public static void setFromString(Object object, Field f, String value) throws IllegalArgumentException, IllegalAccessException {
        Util.setField(object, f, Util.fromString(f.getType(), value));
    }

    public static Object readField(Object object, Field field) {
        boolean wasAccess = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            wasAccess = false;
        }
        try {
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            if (!wasAccess) {
                field.setAccessible(false);
            }
        }
    }

    public static Object translateDate(Field f, java.util.Date value) {
        long t = value.getTime();
        SimpleDate simpleDate = f.getAnnotation(SimpleDate.class);
        if (simpleDate != null) {
            return new Date(t);
        }
        DateTime dateTime = f.getAnnotation(DateTime.class);
        if (dateTime != null) {
            return new Timestamp(t);
        }
        Time time = f.getAnnotation(Time.class);
        if (time != null) {
            return new java.sql.Time(t);
        }
        return new Timestamp(t);
    }

    public static <T> T createObjectInstance(Class<T> clazz) {
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public static void copyObject(Object objFrom, Object objTo) {
        Class<?> clazz = objFrom.getClass();
        for (Field field : JdbcPersistenceManager.JdbcClassInfo.getClassInfo(clazz).allFields) {
            Util.setField(objTo, field, Util.readField(objFrom, field));
        }
    }
}

