/*
 * Decompiled with CFR 0.152.
 */
package siena.core;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import siena.BaseQueryData;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.Query;
import siena.core.async.PersistenceManagerAsync;
import siena.core.batch.Batch;
import siena.core.lifecycle.LifeCyclePhase;
import siena.core.lifecycle.LifeCycleUtils;

public class PersistenceManagerLifeCycleWrapper
implements PersistenceManager {
    PersistenceManager pm;

    public PersistenceManagerLifeCycleWrapper(PersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public void init(Properties p) {
        this.pm.init(p);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return this.pm.createQuery(clazz);
    }

    @Override
    public <T> Query<T> createQuery(BaseQueryData<T> query) {
        return this.pm.createQuery(query);
    }

    @Override
    public <T> Batch<T> createBatch(Class<T> clazz) {
        return this.pm.createBatch(clazz);
    }

    @Override
    public void get(Object obj) {
        ClassInfo ci = ClassInfo.getClassInfo(obj.getClass());
        LifeCycleUtils.executeMethods(LifeCyclePhase.PRE_FETCH, ci, obj);
        this.pm.get(obj);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_FETCH, ci, obj);
    }

    @Override
    public void insert(Object obj) {
        ClassInfo ci = ClassInfo.getClassInfo(obj.getClass());
        LifeCycleUtils.executeMethods(LifeCyclePhase.PRE_INSERT, ci, obj);
        this.pm.insert(obj);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_INSERT, ci, obj);
    }

    @Override
    public void delete(Object obj) {
        ClassInfo ci = ClassInfo.getClassInfo(obj.getClass());
        LifeCycleUtils.executeMethods(LifeCyclePhase.PRE_DELETE, ci, obj);
        this.pm.delete(obj);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_DELETE, ci, obj);
    }

    @Override
    public void update(Object obj) {
        ClassInfo ci = ClassInfo.getClassInfo(obj.getClass());
        LifeCycleUtils.executeMethods(LifeCyclePhase.PRE_UPDATE, ci, obj);
        this.pm.update(obj);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_UPDATE, ci, obj);
    }

    @Override
    public void save(Object obj) {
        ClassInfo ci = ClassInfo.getClassInfo(obj.getClass());
        LifeCycleUtils.executeMethods(LifeCyclePhase.PRE_SAVE, ci, obj);
        this.pm.save(obj);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_SAVE, ci, obj);
    }

    @Override
    public <T> T get(Query<T> query) {
        ClassInfo ci = ClassInfo.getClassInfo(query.getQueriedClass());
        T obj = this.pm.get(query);
        LifeCycleUtils.executeMethods(LifeCyclePhase.POST_FETCH, ci, obj);
        return obj;
    }

    @Override
    public <T> int delete(Query<T> query) {
        return this.pm.delete(query);
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        return this.pm.update(query, fieldValues);
    }

    @Override
    public <T> int count(Query<T> query) {
        return this.pm.count(query);
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        return this.pm.fetch(query);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        return this.pm.fetch(query, limit);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        return this.pm.fetch(query, limit, offset);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        return this.pm.fetchKeys(query);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        return this.pm.fetchKeys(query, limit);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        return this.pm.fetchKeys(query, limit, offset);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        return this.pm.iter(query);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        return this.pm.iter(query, limit);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        return this.pm.iter(query, limit, offset);
    }

    @Override
    public <T> Iterable<T> iterPerPage(Query<T> query, int pageSize) {
        return this.pm.iterPerPage(query, pageSize);
    }

    @Override
    public int save(Object ... objects) {
        return this.pm.save(objects);
    }

    @Override
    public int save(Iterable<?> objects) {
        return this.pm.save(objects);
    }

    @Override
    public int insert(Object ... objects) {
        return this.pm.insert(objects);
    }

    @Override
    public int insert(Iterable<?> objects) {
        return this.pm.insert(objects);
    }

    @Override
    public int delete(Object ... models) {
        return this.pm.delete(models);
    }

    @Override
    public int delete(Iterable<?> models) {
        return this.pm.delete(models);
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        return this.pm.deleteByKeys(clazz, keys);
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        return this.pm.deleteByKeys(clazz, keys);
    }

    @Override
    public int get(Object ... models) {
        return this.pm.get(models);
    }

    @Override
    public <T> int get(Iterable<T> models) {
        return this.pm.get(models);
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        return this.pm.getByKey(clazz, key);
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        return this.pm.getByKeys(clazz, keys);
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        return this.pm.getByKeys(clazz, keys);
    }

    @Override
    public <T> int update(Object ... models) {
        return this.pm.update(models);
    }

    @Override
    public <T> int update(Iterable<T> models) {
        return this.pm.update(models);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
        this.pm.beginTransaction(isolationLevel);
    }

    @Override
    public void commitTransaction() {
        this.pm.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.pm.rollbackTransaction();
    }

    @Override
    public void closeConnection() {
        this.pm.closeConnection();
    }

    @Override
    public <T> void release(Query<T> query) {
        this.pm.release(query);
    }

    @Override
    public <T> void paginate(Query<T> query) {
        this.pm.paginate(query);
    }

    @Override
    public <T> void nextPage(Query<T> query) {
        this.pm.nextPage(query);
    }

    @Override
    public <T> void previousPage(Query<T> query) {
        this.pm.previousPage(query);
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        return this.pm.async();
    }

    @Override
    public String[] supportedOperators() {
        return this.pm.supportedOperators();
    }

    @Override
    @Deprecated
    public <T> int count(Query<T> query, int limit) {
        return this.pm.count(query, limit);
    }

    @Override
    @Deprecated
    public <T> int count(Query<T> query, int limit, Object offset) {
        return this.pm.count(query, limit, offset);
    }
}

