/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.Transaction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.core.async.PersistenceManagerAsync;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.gae.GaeMappingUtils;
import siena.gae.GaePersistenceManagerAsync;
import siena.gae.GaeQueryUtils;
import siena.gae.GaeSienaIterable;
import siena.gae.GaeSienaIterableWithCursor;
import siena.gae.QueryOptionGaeContext;

public class GaePersistenceManager
extends AbstractPersistenceManager {
    private DatastoreService ds;
    private PersistenceManagerAsync asyncPm;
    private Properties props;
    public static final String DB = "GAE";
    private static String[] supportedOperators = GaeQueryUtils.operators.keySet().toArray(new String[0]);

    @Override
    public void init(Properties p) {
        this.ds = DatastoreServiceFactory.getDatastoreService();
        this.props = p;
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        if (this.asyncPm == null) {
            this.asyncPm = new GaePersistenceManagerAsync();
            this.asyncPm.init(this.props);
        }
        return this.asyncPm;
    }

    @Override
    public void beginTransaction(int isolationLevel) {
        this.ds.beginTransaction();
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void commitTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        txn.commit();
    }

    @Override
    public void rollbackTransaction() {
        Transaction txn = this.ds.getCurrentTransaction();
        txn.rollback();
    }

    @Override
    public void delete(Object obj) {
        this.ds.delete(new Key[]{GaeMappingUtils.getKey(obj)});
    }

    @Override
    public void get(Object obj) {
        Key key = GaeMappingUtils.getKey(obj);
        try {
            Entity entity = this.ds.get(key);
            GaeMappingUtils.fillModel(obj, entity);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        Key gkey = GaeMappingUtils.makeKey(clazz, key);
        try {
            Entity entity = this.ds.get(gkey);
            T obj = Util.createObjectInstance(clazz);
            GaeMappingUtils.fillModelAndKey(obj, entity);
            return obj;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void insert(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Entity entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
        GaeMappingUtils.fillEntity(obj, entity);
        this.ds.put(entity);
        GaeMappingUtils.setIdFromKey(idField, obj, entity.getKey());
    }

    @Override
    public void update(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Entity entity = GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
        GaeMappingUtils.fillEntity(obj, entity);
        this.ds.put(entity);
    }

    @Override
    public void save(Object obj) {
        Class<?> clazz = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(clazz);
        Field idField = info.getIdField();
        Object idVal = Util.readField(obj, idField);
        Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
        GaeMappingUtils.fillEntity(obj, entity);
        this.ds.put(entity);
        if (idVal == null) {
            GaeMappingUtils.setIdFromKey(idField, obj, entity.getKey());
        }
    }

    protected DatastoreService getDatastoreService() {
        return this.ds;
    }

    private <T> PreparedQuery prepare(Query<T> query) {
        Class clazz = query.getQueriedClass();
        com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(ClassInfo.getClassInfo(clazz).tableName);
        return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q));
    }

    private <T> PreparedQuery prepareKeysOnly(Query<T> query) {
        Class clazz = query.getQueriedClass();
        com.google.appengine.api.datastore.Query q = new com.google.appengine.api.datastore.Query(ClassInfo.getClassInfo(clazz).tableName);
        return this.ds.prepare(GaeQueryUtils.addFiltersOrders(query, q).setKeysOnly());
    }

    protected <T> T mapJoins(Query<T> query, T model) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (Field field : fieldMap.keySet()) {
                Key key = GaeMappingUtils.getKey(field.get(model));
                List keys = fieldMap.get(field);
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap linkedModels = new HashMap();
            for (Field field : fieldMap.keySet()) {
                Object objVal = field.get(model);
                Key key = GaeMappingUtils.getKey(objVal);
                Object linkedObj = linkedModels.get(key);
                if (linkedObj == null) {
                    Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                    linkedObj = objVal;
                    GaeMappingUtils.fillModel(linkedObj, entity);
                    linkedModels.put(key, linkedObj);
                }
                field.set(model, linkedObj);
            }
            return model;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected <T> List<T> mapJoins(Query<T> query, List<T> models) {
        try {
            Map<Field, ArrayList<Key>> fieldMap = GaeQueryUtils.buildJoinFieldKeysMap(query);
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    List keys = fieldMap.get(field);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
            HashMap<Field, Map> entityMap = new HashMap<Field, Map>();
            try {
                for (Field field : fieldMap.keySet()) {
                    Map entities = this.ds.get((Iterable)fieldMap.get(field));
                    entityMap.put(field, entities);
                }
            }
            catch (Exception ex) {
                throw new SienaException(ex);
            }
            HashMap<Key, Object> linkedModels = new HashMap<Key, Object>();
            for (T model : models) {
                for (Field field : fieldMap.keySet()) {
                    void var6_13;
                    Object objVal = Util.readField(model, field);
                    if (objVal == null) continue;
                    Key key = GaeMappingUtils.getKey(objVal);
                    Object v = linkedModels.get(key);
                    if (v == null) {
                        Entity entity = (Entity)((Map)entityMap.get(field)).get(key);
                        Object object = objVal;
                        GaeMappingUtils.fillModel(object, entity);
                        linkedModels.put(key, object);
                    }
                    field.set(model, var6_13);
                }
            }
            return models;
        }
        catch (IllegalAccessException ex) {
            throw new SienaException(ex);
        }
    }

    protected <T> T map(Query<T> query, Entity entity) {
        Class clazz = query.getQueriedClass();
        Object result = GaeMappingUtils.mapEntity(entity, clazz);
        if (!query.getJoins().isEmpty() || ClassInfo.getClassInfo(clazz).joinFields.size() != 0) {
            return this.mapJoins(query, result);
        }
        return result;
    }

    protected <T> List<T> map(Query<T> query, List<Entity> entities) {
        Class clazz = query.getQueriedClass();
        List result = GaeMappingUtils.mapEntities(entities, clazz);
        if (!query.getJoins().isEmpty() || ClassInfo.getClassInfo(clazz).joinFields.size() != 0) {
            return this.mapJoins(query, result);
        }
        return result;
    }

    private <T> List<T> doFetchList(Query<T> query, int limit, int offset) {
        String cursor;
        QueryResultList entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = 0;
                if (off.isActive()) {
                    gaeCtx.realOffset = off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    List entities2 = this.prepareKeysOnly(query).asList(fetchOptions);
                    if (pag.isPaginating()) {
                        gaeCtx.noMoreDataAfter = entities2.size() == 0;
                    }
                    return GaeMappingUtils.mapEntitiesKeysOnly(entities2, query.getQueriedClass());
                }
            }
            List entities3 = this.prepare(query).asList(fetchOptions);
            if (pag.isPaginating()) {
                gaeCtx.noMoreDataAfter = entities3.size() == 0;
            }
            return this.map(query, entities3);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                case KEYS_ONLY: {
                    PreparedQuery pq = this.prepareKeysOnly(query);
                    if (!gaeCtx.useCursor) {
                        fetchOptions.offset(gaeCtx.realOffset);
                    }
                    QueryResultList entities4 = pq.asQueryResultList(fetchOptions);
                    gaeCtx.activate();
                    if (pag.isPaginating()) {
                        Cursor cursor2 = entities4.getCursor();
                        if (cursor2 != null) {
                            gaeCtx.addCursor(cursor2.toWebSafeString());
                        }
                        gaeCtx.noMoreDataAfter = entities4.size() == 0;
                    } else {
                        Cursor cursor3 = entities4.getCursor();
                        if (cursor3 != null) {
                            gaeCtx.addAndMoveCursor(entities4.getCursor().toWebSafeString());
                        }
                        gaeCtx.realOffset += entities4.size();
                    }
                    return GaeMappingUtils.mapEntitiesKeysOnly((List<Entity>)entities4, query.getQueriedClass());
                }
            }
            PreparedQuery pq = this.prepare(query);
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
            }
            QueryResultList entities5 = pq.asQueryResultList(fetchOptions);
            gaeCtx.activate();
            if (pag.isPaginating()) {
                Cursor cursor4 = entities5.getCursor();
                if (cursor4 != null) {
                    gaeCtx.addCursor(cursor4.toWebSafeString());
                }
                gaeCtx.noMoreDataAfter = entities5.size() == 0;
            } else {
                Cursor cursor5 = entities5.getCursor();
                if (cursor5 != null) {
                    gaeCtx.addAndMoveCursor(entities5.getCursor().toWebSafeString());
                }
                gaeCtx.realOffset += entities5.size();
            }
            return this.map(query, (List<Entity>)entities5);
        }
        switch (fetchType.fetchType) {
            case KEYS_ONLY: {
                String cursor6;
                QueryResultList entities6;
                PreparedQuery pq = this.prepareKeysOnly(query);
                if (!gaeCtx.useCursor) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    entities6 = pq.asQueryResultList(fetchOptions);
                } else {
                    cursor6 = gaeCtx.currentCursor();
                    entities6 = cursor6 != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor6))) : pq.asQueryResultList(fetchOptions);
                }
                if (pag.isPaginating()) {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addCursor(cursor6.toWebSafeString());
                    }
                    gaeCtx.noMoreDataAfter = entities6.size() == 0;
                } else {
                    cursor6 = entities6.getCursor();
                    if (cursor6 != null) {
                        gaeCtx.addAndMoveCursor(entities6.getCursor().toWebSafeString());
                    }
                    gaeCtx.realOffset += entities6.size();
                }
                return GaeMappingUtils.mapEntitiesKeysOnly((List<Entity>)entities6, query.getQueriedClass());
            }
        }
        PreparedQuery pq = this.prepare(query);
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultList(fetchOptions);
        } else {
            cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultList(fetchOptions);
        }
        if (pag.isPaginating()) {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addCursor(cursor.toWebSafeString());
            }
            gaeCtx.noMoreDataAfter = entities.size() == 0;
        } else {
            cursor = entities.getCursor();
            if (cursor != null) {
                gaeCtx.addAndMoveCursor(entities.getCursor().toWebSafeString());
            }
            gaeCtx.realOffset += entities.size();
        }
        return this.map(query, (List<Entity>)entities);
    }

    private <T> Iterable<T> doFetchIterable(Query<T> query, int limit, int offset) {
        QueryResultIterable entities;
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionFetchType fetchType = (QueryOptionFetchType)query.option(4);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.customize(gaeCtx);
        }
        FetchOptions fetchOptions = FetchOptions.Builder.withDefaults();
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (!pag.isPaginating()) {
            if (pag.isActive()) {
                if (limit != Integer.MAX_VALUE) {
                    gaeCtx.realPageSize = limit;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    pag.passivate();
                } else {
                    gaeCtx.realPageSize = pag.pageSize;
                    fetchOptions.limit(gaeCtx.realPageSize);
                    if (state.isStateless()) {
                        pag.passivate();
                    }
                }
            } else if (limit != Integer.MAX_VALUE) {
                gaeCtx.realPageSize = limit;
                fetchOptions.limit(gaeCtx.realPageSize);
            }
        } else {
            gaeCtx.realPageSize = pag.pageSize;
            fetchOptions.limit(gaeCtx.realPageSize);
        }
        QueryOptionOffset off = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            off.activate();
            off.offset = offset;
        }
        if (gaeCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless()) {
            if (pag.isPaginating()) {
                if (off.isActive()) {
                    gaeCtx.realOffset += off.offset;
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                } else {
                    fetchOptions.offset(gaeCtx.realOffset);
                }
            } else {
                gaeCtx.realOffset = off.offset;
                if (off.isActive()) {
                    fetchOptions.offset(gaeCtx.realOffset);
                    off.passivate();
                }
            }
            switch (fetchType.fetchType) {
                default: 
            }
            Iterable entities2 = this.prepare(query).asIterable(fetchOptions);
            return new GaeSienaIterable<T>(this, entities2, query);
        }
        if (off.isActive()) {
            fetchOptions.offset(off.offset);
            gaeCtx.realOffset += off.offset;
            off.passivate();
        }
        if (!gaeCtx.isActive()) {
            switch (fetchType.fetchType) {
                default: 
            }
            PreparedQuery pq = this.prepare(query);
            if (pag.isPaginating()) {
                QueryResultList entities3 = pq.asQueryResultList(fetchOptions);
                gaeCtx.activate();
                Cursor cursor = entities3.getCursor();
                if (cursor != null) {
                    gaeCtx.addCursor(cursor.toWebSafeString());
                }
                return new GaeSienaIterable<T>(this, (Iterable<Entity>)entities3, query);
            }
            QueryResultIterable entities4 = pq.asQueryResultIterable(fetchOptions);
            gaeCtx.activate();
            return new GaeSienaIterableWithCursor<T>(this, (QueryResultIterable<Entity>)entities4, query);
        }
        switch (fetchType.fetchType) {
            default: 
        }
        PreparedQuery pq = this.prepare(query);
        if (pag.isPaginating()) {
            QueryResultList entities5;
            if (!gaeCtx.useCursor) {
                fetchOptions.offset(gaeCtx.realOffset);
                entities5 = pq.asQueryResultList(fetchOptions);
            } else {
                String cursor = gaeCtx.currentCursor();
                entities5 = cursor != null ? pq.asQueryResultList(fetchOptions.startCursor(Cursor.fromWebSafeString((String)cursor))) : pq.asQueryResultList(fetchOptions);
                gaeCtx.addCursor(entities5.getCursor().toWebSafeString());
            }
            return new GaeSienaIterable<T>(this, (Iterable<Entity>)entities5, query);
        }
        if (!gaeCtx.useCursor) {
            fetchOptions.offset(gaeCtx.realOffset);
            entities = pq.asQueryResultIterable(fetchOptions);
        } else {
            String cursor = gaeCtx.currentCursor();
            entities = cursor != null ? pq.asQueryResultIterable(fetchOptions.startCursor(Cursor.fromWebSafeString((String)gaeCtx.currentCursor()))) : pq.asQueryResultIterable(fetchOptions);
        }
        return new GaeSienaIterableWithCursor<T>(this, (QueryResultIterable<Entity>)entities, query);
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.NORMAL;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> int count(Query<T> query) {
        return this.prepare(query).countEntities(FetchOptions.Builder.withDefaults());
    }

    @Override
    public <T> int delete(Query<T> query) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Entity entity : this.prepareKeysOnly(query).asIterable(FetchOptions.Builder.withDefaults())) {
            keys.add(entity.getKey());
        }
        this.ds.delete(keys);
        return keys.size();
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, 0);
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        return this.doFetchList(query, limit, (Integer)offset);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doFetchIterable(query, limit, (Integer)offset);
    }

    @Override
    public <T> void release(Query<T> query) {
        super.release(query);
        GaeQueryUtils.release(query);
    }

    @Override
    public <T> void paginate(Query<T> query) {
        GaeQueryUtils.paginate(query);
    }

    @Override
    public <T> void nextPage(Query<T> query) {
        GaeQueryUtils.nextPage(query);
    }

    @Override
    public <T> void previousPage(Query<T> query) {
        GaeQueryUtils.previousPage(query);
    }

    @Override
    public int insert(Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Class<?> clazz = objects[i].getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstance(idField, info, objects[i]);
            GaeMappingUtils.fillEntity(objects[i], entity);
            entities.add(entity);
            ++i;
        }
        List generatedKeys = this.ds.put(entities);
        int i2 = 0;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i2++));
            ++n2;
        }
        return generatedKeys.size();
    }

    @Override
    public int insert(Iterable<?> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstance(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        List generatedKeys = this.ds.put(entities);
        int i = 0;
        for (Object obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i++));
        }
        return generatedKeys.size();
    }

    @Override
    public int delete(Object ... models) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Object[] objectArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            keys.add(GaeMappingUtils.getKey(obj));
            ++n2;
        }
        this.ds.delete(keys);
        return keys.size();
    }

    @Override
    public int delete(Iterable<?> models) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Object obj : models) {
            keys.add(GaeMappingUtils.getKey(obj));
        }
        this.ds.delete(keys);
        return keys.size();
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
            ++n2;
        }
        this.ds.delete(gaeKeys);
        return gaeKeys.size();
    }

    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
        }
        this.ds.delete(gaeKeys);
        return gaeKeys.size();
    }

    @Override
    public int get(Object ... objects) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            keys.add(GaeMappingUtils.getKey(obj));
            ++n2;
        }
        Map entityMap = this.ds.get(keys);
        Object[] objectArray2 = objects;
        int n3 = objects.length;
        n = 0;
        while (n < n3) {
            Object obj = objectArray2[n];
            GaeMappingUtils.fillModel(obj, (Entity)entityMap.get(GaeMappingUtils.getKey(obj)));
            ++n;
        }
        return entityMap.size();
    }

    @Override
    public <T> int get(Iterable<T> objects) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (T obj : objects) {
            keys.add(GaeMappingUtils.getKey(obj));
        }
        Map entityMap = this.ds.get(keys);
        for (T obj : objects) {
            GaeMappingUtils.fillModel(obj, (Entity)entityMap.get(GaeMappingUtils.getKey(obj)));
        }
        return entityMap.size();
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
            ++n2;
        }
        Map entityMap = this.ds.get(gaeKeys);
        ArrayList<T> models = new ArrayList<T>(entityMap.size());
        Object[] objectArray2 = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            Object key = objectArray2[n4];
            models.add(GaeMappingUtils.mapEntity((Entity)entityMap.get(GaeMappingUtils.makeKey(clazz, key)), clazz));
            ++n4;
        }
        return models;
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        ArrayList<Key> gaeKeys = new ArrayList<Key>();
        for (Object key : keys) {
            gaeKeys.add(GaeMappingUtils.makeKey(clazz, key));
        }
        Map entityMap = this.ds.get(gaeKeys);
        ArrayList<T> models = new ArrayList<T>(entityMap.size());
        for (Object key : keys) {
            models.add(GaeMappingUtils.mapEntity((Entity)entityMap.get(GaeMappingUtils.makeKey(clazz, key)), clazz));
        }
        return models;
    }

    @Override
    public <T> int update(Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
            ++n2;
        }
        List generatedKeys = this.ds.put(entities);
        return generatedKeys.size();
    }

    @Override
    public <T> int update(Iterable<T> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (T obj : objects) {
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Entity entity = GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        List generatedKeys = this.ds.put(entities);
        return generatedKeys.size();
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        throw new NotImplementedException("update not implemented for GAE yet");
    }

    @Override
    public int save(Object ... objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Object idVal = Util.readField(obj, idField);
            Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
            ++n2;
        }
        List generatedKeys = this.ds.put(entities);
        int i = 0;
        Object[] objectArray2 = objects;
        int n3 = objects.length;
        int n4 = 0;
        while (n4 < n3) {
            Object obj = objectArray2[n4];
            Class<?> clazz = obj.getClass();
            ClassInfo info = ClassInfo.getClassInfo(clazz);
            Field idField = info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null) {
                GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i++));
            }
            ++n4;
        }
        return generatedKeys.size();
    }

    @Override
    public int save(Iterable<?> objects) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : objects) {
            Class<?> clazz;
            ClassInfo info;
            Field idField;
            Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
            Entity entity = idVal == null ? GaeMappingUtils.createEntityInstance(idField, info, obj) : GaeMappingUtils.createEntityInstanceForUpdate(idField, info, obj);
            GaeMappingUtils.fillEntity(obj, entity);
            entities.add(entity);
        }
        List generatedKeys = this.ds.put(entities);
        int i = 0;
        for (Object obj : objects) {
            Class<?> clazz;
            ClassInfo info;
            Field idField;
            Object idVal = Util.readField(obj, idField = (info = ClassInfo.getClassInfo(clazz = obj.getClass())).getIdField());
            if (idVal != null) continue;
            GaeMappingUtils.setIdFromKey(idField, obj, (Key)generatedKeys.get(i++));
        }
        return generatedKeys.size();
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }
}

