/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Entity;
import java.lang.reflect.Field;
import java.util.Iterator;
import siena.ClassInfo;
import siena.Query;
import siena.core.options.QueryOptionPage;
import siena.gae.GaePersistenceManager;
import siena.gae.QueryOptionGaeContext;

public class GaeSienaIterable<Model>
implements Iterable<Model> {
    Iterable<Entity> gaeIterable;
    Query<Model> query;
    GaePersistenceManager pm;

    GaeSienaIterable(GaePersistenceManager pm, Iterable<Entity> gaeIterable, Query<Model> query) {
        this.gaeIterable = gaeIterable;
        this.query = query;
        this.pm = pm;
    }

    @Override
    public Iterator<Model> iterator() {
        return new SienaGaeIterator<Model>(this.query, this.gaeIterable);
    }

    public class SienaGaeIterator<T>
    implements Iterator<T> {
        Field id;
        Query<T> query;
        Iterator<Entity> gaeIterator;

        SienaGaeIterator(Query<T> query, Iterable<Entity> gaeIterable) {
            this.query = query;
            this.id = ClassInfo.getIdField(query.getQueriedClass());
            this.gaeIterator = gaeIterable.iterator();
            QueryOptionPage pag = (QueryOptionPage)query.option(1);
            QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
            if (pag.isPaginating()) {
                gaeCtx.noMoreDataAfter = !this.gaeIterator.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.gaeIterator.hasNext();
        }

        @Override
        public T next() {
            Entity entity = this.gaeIterator.next();
            T obj = GaeSienaIterable.this.pm.map(this.query, entity);
            return obj;
        }

        @Override
        public void remove() {
            this.gaeIterator.remove();
        }
    }
}

