/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.NotImplementedException;
import siena.AbstractPersistenceManager;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.Json;
import siena.Query;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryFilterSimple;
import siena.SienaException;
import siena.SienaRestrictedApiException;
import siena.Util;
import siena.core.Polymorphic;
import siena.core.async.PersistenceManagerAsync;
import siena.core.options.QueryOption;
import siena.core.options.QueryOptionFetchType;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.embed.Embedded;
import siena.embed.JsonSerializer;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcMappingUtils;
import siena.jdbc.JdbcSienaIterable;
import siena.jdbc.QueryOptionJdbcContext;
import siena.jdbc.QueryOptionJdbcSearch;
import siena.jdbc.ThreadedConnectionManager;

public class JdbcPersistenceManager
extends AbstractPersistenceManager {
    private static final String DB = "JDBC";
    private ConnectionManager connectionManager;
    private static final String[] supportedOperators = new String[]{"<", ">", ">=", "<=", "!=", "=", "IN"};

    public JdbcPersistenceManager() {
    }

    public JdbcPersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void init(Properties p) {
        if (p != null) {
            String cm = p.getProperty("transactions");
            if (cm != null) {
                try {
                    this.connectionManager = (ConnectionManager)Class.forName(cm).newInstance();
                }
                catch (Exception e) {
                    throw new SienaException(e);
                }
            } else {
                this.connectionManager = new ThreadedConnectionManager();
            }
        }
        if (this.connectionManager == null) {
            this.connectionManager = new ThreadedConnectionManager();
        }
        this.connectionManager.init(p);
    }

    protected Connection getConnection() throws SQLException {
        return this.connectionManager.getConnection();
    }

    @Override
    public void delete(Object obj) {
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
                this.addParameters(obj, classInfo.keys, ps, 1);
                int n = ps.executeUpdate();
                if (n == 0) {
                    throw new SienaException("No updated rows");
                }
                if (n > 1) {
                    throw new SienaException(String.valueOf(n) + " rows deleted");
                }
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatement(ps);
    }

    @Override
    public void get(Object obj) {
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.selectSQL);
                this.addParameters(obj, classInfo.keys, ps, 1);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new SienaException("No such object");
                }
                JdbcMappingUtils.mapObject(obj, rs, null, null);
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeResultSet(rs);
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeResultSet(rs);
        JdbcDBUtils.closeStatement(ps);
    }

    @Override
    public void insert(Object obj) {
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                for (Field field : classInfo.keys) {
                    Id id = field.getAnnotation(Id.class);
                    if (id.value() != Generator.UUID) continue;
                    field.set(obj, UUID.randomUUID().toString());
                }
                if (!classInfo.generatedKeys.isEmpty()) {
                    this.insertWithAutoIncrementKey(classInfo, obj);
                } else {
                    ps = this.getConnection().prepareStatement(classInfo.insertSQL);
                    this.addParameters(obj, classInfo.insertFields, ps, 1);
                    ps.executeUpdate();
                }
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatement(ps);
    }

    @Override
    public void update(Object obj) {
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                ps = this.getConnection().prepareStatement(classInfo.updateSQL);
                int i = 1;
                i = this.addParameters(obj, classInfo.updateFields, ps, i);
                this.addParameters(obj, classInfo.keys, ps, i);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatement(ps);
    }

    @Override
    public void save(Object obj) {
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
        PreparedStatement ps = null;
        try {
            try {
                Field idField = classInfo.info.getIdField();
                Object idVal = Util.readField(obj, idField);
                if (idVal == null) {
                    for (Field field : classInfo.keys) {
                        Id id = field.getAnnotation(Id.class);
                        if (id.value() != Generator.UUID) continue;
                        field.set(obj, UUID.randomUUID().toString());
                    }
                }
                ps = idVal == null && !classInfo.generatedKeys.isEmpty() ? this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL, 1) : this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL);
                int i = 1;
                i = this.addParameters(obj, classInfo.allFields, ps, i);
                this.addParameters(obj, classInfo.updateFields, ps, i);
                ps.executeUpdate();
                if (idVal == null && !classInfo.generatedKeys.isEmpty()) {
                    ResultSet gk = ps.getGeneratedKeys();
                    if (!gk.next()) {
                        throw new SienaException("No such generated keys");
                    }
                    i = 1;
                    for (Field field : classInfo.generatedKeys) {
                        field.setAccessible(true);
                        JdbcMappingUtils.setFromObject(obj, field, gk.getObject(i));
                        ++i;
                    }
                }
            }
            catch (SienaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatement(ps);
    }

    @Override
    public void beginTransaction(int isolationLevel) {
        this.connectionManager.beginTransaction(isolationLevel);
    }

    @Override
    public void commitTransaction() {
        this.connectionManager.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.connectionManager.rollbackTransaction();
    }

    @Override
    public void closeConnection() {
        this.connectionManager.closeConnection();
    }

    private PreparedStatement createStatement(String sql, List<Object> parameters) throws SQLException {
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        if (parameters != null) {
            int i = 1;
            for (Object parameter : parameters) {
                this.setParameter(statement, i++, parameter);
            }
        }
        return statement;
    }

    protected void insertWithAutoIncrementKey(JdbcClassInfo classInfo, Object obj) throws SQLException, IllegalAccessException {
        ResultSet gk = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(classInfo.insertSQL, 1);
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            ps.executeUpdate();
            gk = ps.getGeneratedKeys();
            if (!gk.next()) {
                throw new SienaException("No such generated keys");
            }
            int i = 1;
            for (Field field : classInfo.generatedKeys) {
                field.setAccessible(true);
                JdbcMappingUtils.setFromObject(obj, field, gk.getObject(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeResultSet(gk);
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeResultSet(gk);
        JdbcDBUtils.closeStatement(ps);
    }

    protected int insertBatchWithAutoIncrementKey(JdbcClassInfo classInfo, Map<JdbcClassInfo, List<Object>> objMap) throws SQLException, IllegalAccessException {
        PreparedStatement ps = null;
        ps = this.getConnection().prepareStatement(classInfo.insertSQL, 1);
        for (Object obj : objMap.get(classInfo)) {
            for (Field field : classInfo.keys) {
                Id id = field.getAnnotation(Id.class);
                if (id.value() != Generator.UUID) continue;
                field.set(obj, UUID.randomUUID().toString());
            }
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            ps.addBatch();
        }
        int[] res = ps.executeBatch();
        if (!classInfo.generatedKeys.isEmpty()) {
            ResultSet gk = ps.getGeneratedKeys();
            int idx = 0;
            while (gk.next()) {
                int i = 1;
                for (Field field : classInfo.generatedKeys) {
                    field.setAccessible(true);
                    JdbcMappingUtils.setFromObject(objMap.get(classInfo).get(idx++), field, gk.getObject(i++));
                }
            }
        }
        return res.length;
    }

    protected int addParameters(Object obj, List<Field> fields, PreparedStatement ps, int i) throws SQLException {
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (ClassInfo.isModel(type) && !ClassInfo.isEmbedded(field)) {
                JdbcClassInfo ci = JdbcClassInfo.getClassInfo(type);
                Object rel = Util.readField(obj, field);
                for (Field f : ci.keys) {
                    if (rel != null) {
                        Object value = Util.readField(rel, f);
                        if (value instanceof Json) {
                            value = ((Json)value).toString();
                        }
                        this.setParameter(ps, i++, value);
                        continue;
                    }
                    this.setParameter(ps, i++, null);
                }
                continue;
            }
            Object value = Util.readField(obj, field);
            if (value != null) {
                if (Json.class.isAssignableFrom(field.getType())) {
                    value = ((Json)value).toString();
                } else if (field.getAnnotation(Embedded.class) != null) {
                    value = JsonSerializer.serialize(value).toString();
                } else if (field.getAnnotation(Polymorphic.class) != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream out = new ObjectOutputStream(bos);
                        out.writeObject(value);
                        out.close();
                    }
                    catch (IOException e) {
                        throw new SienaException(e);
                    }
                    value = bos.toByteArray();
                } else if (Enum.class.isAssignableFrom(field.getType())) {
                    value = value.toString();
                }
            }
            this.setParameter(ps, i++, value);
        }
        return i;
    }

    protected void setParameter(PreparedStatement ps, int index, Object value) throws SQLException {
        ps.setObject(index, value);
    }

    public <T> void appendSqlSearch(QueryFilterSearch qf, Class<?> clazz, JdbcClassInfo info, StringBuilder sql, List<Object> parameters) {
        ArrayList<String> cols = new ArrayList<String>();
        try {
            String[] stringArray = qf.fields;
            int n = qf.fields.length;
            int n2 = 0;
            while (n2 < n) {
                String[] columns;
                String field = stringArray[n2];
                Field f = clazz.getDeclaredField(field);
                String[] stringArray2 = columns = ClassInfo.getColumnNames(f, info.tableName);
                int n3 = columns.length;
                int n4 = 0;
                while (n4 < n3) {
                    String col = stringArray2[n4];
                    cols.add(col);
                    ++n4;
                }
                ++n2;
            }
            QueryOption opt = qf.option;
            if (opt != null) {
                if (QueryOptionJdbcSearch.class.isAssignableFrom(opt.getClass())) {
                    if (((QueryOptionJdbcSearch)opt).booleanMode) {
                        sql.append("MATCH(" + Util.join(cols, ",") + ") AGAINST(? IN BOOLEAN MODE)");
                    }
                } else {
                    sql.append("MATCH(" + Util.join(cols, ",") + ") AGAINST(?)");
                }
            } else {
                sql.append("MATCH(" + Util.join(cols, ",") + ") AGAINST(? IN BOOLEAN MODE)");
            }
            parameters.add(qf.match);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    public <T> void appendSqlWhere(Query<T> query, StringBuilder sql, List<Object> parameters) {
        Class clazz = query.getQueriedClass();
        JdbcClassInfo info = JdbcClassInfo.getClassInfo(clazz);
        List<QueryFilter> filters = query.getFilters();
        if (filters.isEmpty()) {
            return;
        }
        sql.append(" WHERE ");
        boolean first = true;
        for (QueryFilter filter : filters) {
            QueryFilter qf;
            if (QueryFilterSimple.class.isAssignableFrom(filter.getClass())) {
                qf = (QueryFilterSimple)filter;
                String op = qf.operator;
                Object value = qf.value;
                Field f = qf.field;
                if (!first) {
                    sql.append(" AND ");
                }
                first = false;
                String[] columns = ClassInfo.getColumnNames(f, info.tableName);
                if ("IN".equals(op)) {
                    if (!Collection.class.isAssignableFrom(value.getClass())) {
                        throw new SienaException("Collection needed when using IN operator in filter() query");
                    }
                    StringBuilder s = new StringBuilder();
                    Collection col = (Collection)value;
                    for (Object object : col) {
                        parameters.add(object);
                        s.append(",?");
                    }
                    sql.append(String.valueOf(columns[0]) + " IN(" + s.toString().substring(1) + ")");
                    continue;
                }
                if (ClassInfo.isModel(f.getType())) {
                    if (!op.equals("=")) {
                        throw new SienaException("Unsupported operator for relationship: " + op);
                    }
                    JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(f.getType());
                    int i = 0;
                    JdbcMappingUtils.checkForeignKeyMapping(classInfo.keys, columns, query.getQueriedClass(), f);
                    for (Field key : classInfo.keys) {
                        if (value == null) {
                            sql.append(String.valueOf(columns[i++]) + " IS NULL");
                            continue;
                        }
                        sql.append(String.valueOf(columns[i++]) + "=?");
                        key.setAccessible(true);
                        try {
                            Object o = key.get(value);
                            parameters.add(o);
                        }
                        catch (Exception e) {
                            throw new SienaException(e);
                        }
                    }
                    continue;
                }
                if (value == null && op.equals("=")) {
                    sql.append(String.valueOf(columns[0]) + " IS NULL");
                    continue;
                }
                if (value == null && op.equals("!=")) {
                    sql.append(String.valueOf(columns[0]) + " IS NOT NULL");
                    continue;
                }
                sql.append(String.valueOf(columns[0]) + op + "?");
                if (value == null) {
                    parameters.add(0);
                    continue;
                }
                if (value instanceof Date) {
                    value = Util.translateDate(f, (Date)value);
                }
                parameters.add(value);
                continue;
            }
            if (!QueryFilterSearch.class.isAssignableFrom(filter.getClass())) continue;
            if (query.getSearches().size() > 1) {
                throw new SienaRestrictedApiException(DB, "search", "MySQL implementation manages only on single search at a time in a query");
            }
            qf = (QueryFilterSearch)filter;
            this.appendSqlSearch((QueryFilterSearch)qf, clazz, info, sql, parameters);
        }
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private <T> List<T> doFetch(Query<T> query, int limit, int offset) {
        QueryOptionPage pag;
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        jdbcCtx.realPageSize = !(pag = (QueryOptionPage)query.option(1)).isPaginating() ? (pag.isActive() ? (limit != Integer.MAX_VALUE ? limit : pag.pageSize) : limit) : pag.pageSize;
        QueryOptionOffset offsetOpt = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            offsetOpt.activate();
            offsetOpt.offset = offset;
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (jdbcCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless() || state.isStateful() && !jdbcCtx.isActive()) {
            if (state.isStateless()) {
                if (pag.isPaginating()) {
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset += offsetOpt.offset;
                        offsetOpt.passivate();
                    }
                } else {
                    if (pag.isActive()) {
                        pag.passivate();
                    }
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset = offsetOpt.offset;
                        offsetOpt.passivate();
                    } else {
                        jdbcCtx.realOffset = 0;
                    }
                }
            } else if (offsetOpt.isActive()) {
                jdbcCtx.realOffset += offsetOpt.offset;
                offsetOpt.passivate();
            }
            Class clazz = query.getQueriedClass();
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuilder sql = JdbcDBUtils.buildSqlSelect(query);
            this.appendSqlWhere(query, sql, parameters);
            JdbcDBUtils.appendSqlOrder(query, sql);
            JdbcDBUtils.appendSqlLimitOffset(query, sql, parameters);
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                statement = this.createStatement(sql.toString(), parameters);
                if (pag.isPaginating()) {
                    statement.setFetchSize(jdbcCtx.realPageSize);
                }
                rs = statement.executeQuery();
                List result = JdbcMappingUtils.mapList(clazz, rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(query), jdbcCtx.realPageSize);
                if (pag.isPaginating()) {
                    jdbcCtx.noMoreDataAfter = result.size() == 0;
                } else if (state.isStateful()) {
                    jdbcCtx.realOffset += result.size();
                }
                if (state.isStateless()) {
                    JdbcDBUtils.closeResultSet(rs);
                    JdbcDBUtils.closeStatement(statement);
                } else {
                    Integer offsetParamIdx = parameters.size();
                    Integer limitParamIdx = offsetParamIdx - 1;
                    jdbcCtx.activate();
                    jdbcCtx.statement = statement;
                    jdbcCtx.limitParamIdx = limitParamIdx;
                    jdbcCtx.offsetParamIdx = offsetParamIdx;
                }
                return result;
            }
            catch (SQLException e) {
                JdbcDBUtils.closeResultSet(rs);
                JdbcDBUtils.closeStatement(statement);
                throw new SienaException(e);
            }
        }
        Class clazz = query.getQueriedClass();
        if (offsetOpt.isActive()) {
            jdbcCtx.realOffset += offsetOpt.offset;
            offsetOpt.passivate();
        }
        try {
            jdbcCtx.statement.setObject(jdbcCtx.limitParamIdx, jdbcCtx.realPageSize);
            jdbcCtx.statement.setObject(jdbcCtx.offsetParamIdx, jdbcCtx.realOffset);
            ResultSet rs = jdbcCtx.statement.executeQuery();
            List result = JdbcMappingUtils.mapList(clazz, rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(query), jdbcCtx.realPageSize);
            if (pag.isPaginating()) {
                jdbcCtx.noMoreDataAfter = result.size() == 0;
            } else {
                jdbcCtx.realOffset += result.size();
            }
            return result;
        }
        catch (SQLException ex) {
            JdbcDBUtils.closeStatement(jdbcCtx.statement);
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> List<T> fetch(Query<T> query) {
        List<T> result = this.doFetch(query, Integer.MAX_VALUE, 0);
        return result;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit) {
        List<T> result = this.doFetch(query, limit, 0);
        return result;
    }

    @Override
    public <T> List<T> fetch(Query<T> query, int limit, Object offset) {
        List<T> result = this.doFetch(query, limit, (Integer)offset);
        return result;
    }

    @Override
    public <T> int count(Query<T> query) {
        int n;
        ClassInfo info = ClassInfo.getClassInfo(query.getQueriedClass());
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM ");
        sql.append(info.tableName);
        this.appendSqlWhere(query, sql, parameters);
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.createStatement(sql.toString(), parameters);
            rs = statement.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw new SienaException(e);
            }
            catch (Throwable throwable) {
                JdbcDBUtils.closeResultSet(rs);
                JdbcDBUtils.closeStatement(statement);
                throw throwable;
            }
        }
        JdbcDBUtils.closeResultSet(rs);
        JdbcDBUtils.closeStatement(statement);
        return n;
    }

    @Override
    public <T> int delete(Query<T> query) {
        ClassInfo info = ClassInfo.getClassInfo(query.getQueriedClass());
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("DELETE FROM ");
        sql.append(info.tableName);
        this.appendSqlWhere(query, sql, parameters);
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.createStatement(sql.toString(), parameters);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeResultSet(rs);
            JdbcDBUtils.closeStatement(statement);
        }
    }

    private <T> List<T> doFetchKeys(Query<T> query, int limit, int offset) {
        QueryOptionPage pag;
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        jdbcCtx.realPageSize = !(pag = (QueryOptionPage)query.option(1)).isPaginating() ? (pag.isActive() ? (limit != Integer.MAX_VALUE ? limit : pag.pageSize) : limit) : pag.pageSize;
        QueryOptionOffset offsetOpt = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            offsetOpt.activate();
            offsetOpt.offset = offset;
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (jdbcCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless() || state.isStateful() && !jdbcCtx.isActive()) {
            if (state.isStateless()) {
                if (pag.isPaginating()) {
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset += offsetOpt.offset;
                        offsetOpt.passivate();
                    }
                } else {
                    if (pag.isActive()) {
                        pag.passivate();
                    }
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset = offsetOpt.offset;
                        offsetOpt.passivate();
                    } else {
                        jdbcCtx.realOffset = 0;
                    }
                }
            } else if (offsetOpt.isActive()) {
                jdbcCtx.realOffset += offsetOpt.offset;
                offsetOpt.passivate();
            }
            Class clazz = query.getQueriedClass();
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuilder sql = JdbcDBUtils.buildSqlSelect(query);
            this.appendSqlWhere(query, sql, parameters);
            JdbcDBUtils.appendSqlOrder(query, sql);
            JdbcDBUtils.appendSqlLimitOffset(query, sql, parameters);
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                statement = this.createStatement(sql.toString(), parameters);
                if (pag.isActive()) {
                    statement.setFetchSize(jdbcCtx.realPageSize);
                }
                rs = statement.executeQuery();
                List result = JdbcMappingUtils.mapListKeys(clazz, rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(query), jdbcCtx.realPageSize);
                if (pag.isPaginating()) {
                    jdbcCtx.noMoreDataAfter = result.size() == 0;
                } else if (state.isStateful()) {
                    jdbcCtx.realOffset += result.size();
                }
                if (state.isStateless()) {
                    JdbcDBUtils.closeResultSet(rs);
                    JdbcDBUtils.closeStatement(statement);
                } else {
                    Integer offsetParamIdx = parameters.size();
                    Integer limitParamIdx = offsetParamIdx - 1;
                    jdbcCtx.activate();
                    jdbcCtx.statement = statement;
                    jdbcCtx.limitParamIdx = limitParamIdx;
                    jdbcCtx.offsetParamIdx = offsetParamIdx;
                }
                return result;
            }
            catch (SQLException e) {
                JdbcDBUtils.closeResultSet(rs);
                JdbcDBUtils.closeStatement(statement);
                throw new SienaException(e);
            }
        }
        Class clazz = query.getQueriedClass();
        if (offsetOpt.isActive()) {
            jdbcCtx.realOffset += offsetOpt.offset;
            offsetOpt.passivate();
        }
        try {
            jdbcCtx.statement.setObject(jdbcCtx.limitParamIdx, jdbcCtx.realPageSize);
            jdbcCtx.statement.setObject(jdbcCtx.offsetParamIdx, jdbcCtx.realOffset);
            ResultSet rs = jdbcCtx.statement.executeQuery();
            List result = JdbcMappingUtils.mapListKeys(clazz, rs, ClassInfo.getClassInfo(clazz).tableName, JdbcMappingUtils.getJoinFields(query), jdbcCtx.realPageSize);
            if (pag.isPaginating()) {
                jdbcCtx.noMoreDataAfter = result.size() == 0;
            } else {
                jdbcCtx.realOffset += result.size();
            }
            return result;
        }
        catch (SQLException ex) {
            JdbcDBUtils.closeStatement(jdbcCtx.statement);
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        List<T> result = this.doFetchKeys(query, Integer.MAX_VALUE, 0);
        return result;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        List<T> result = this.doFetchKeys(query, limit, 0);
        return result;
    }

    @Override
    public <T> List<T> fetchKeys(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.KEYS_ONLY;
        List<T> result = this.doFetchKeys(query, limit, (Integer)offset);
        return result;
    }

    private <T> Iterable<T> doIter(Query<T> query, int limit, int offset) {
        QueryOptionPage pag;
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        jdbcCtx.realPageSize = !(pag = (QueryOptionPage)query.option(1)).isPaginating() ? (pag.isActive() ? (limit != Integer.MAX_VALUE ? limit : pag.pageSize) : limit) : pag.pageSize;
        QueryOptionOffset offsetOpt = (QueryOptionOffset)query.option(2);
        if (offset != 0) {
            offsetOpt.activate();
            offsetOpt.offset = offset;
        }
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (jdbcCtx.noMoreDataBefore) {
            return new ArrayList();
        }
        if (state.isStateless() || state.isStateful() && !jdbcCtx.isActive()) {
            if (state.isStateless()) {
                if (pag.isPaginating()) {
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset += offsetOpt.offset;
                        offsetOpt.passivate();
                    }
                } else {
                    if (pag.isActive()) {
                        pag.passivate();
                    }
                    if (offsetOpt.isActive()) {
                        jdbcCtx.realOffset = offsetOpt.offset;
                        offsetOpt.passivate();
                    } else {
                        jdbcCtx.realOffset = 0;
                    }
                }
            } else if (offsetOpt.isActive()) {
                jdbcCtx.realOffset += offsetOpt.offset;
                offsetOpt.passivate();
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuilder sql = JdbcDBUtils.buildSqlSelect(query);
            this.appendSqlWhere(query, sql, parameters);
            JdbcDBUtils.appendSqlOrder(query, sql);
            JdbcDBUtils.appendSqlLimitOffset(query, sql, parameters);
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                statement = this.createStatement(sql.toString(), parameters);
                if (pag.isActive()) {
                    statement.setFetchSize(jdbcCtx.realPageSize);
                }
                rs = statement.executeQuery();
                if (!state.isStateless()) {
                    Integer offsetParamIdx = parameters.size();
                    Integer limitParamIdx = offsetParamIdx - 1;
                    jdbcCtx.activate();
                    jdbcCtx.statement = statement;
                    jdbcCtx.limitParamIdx = limitParamIdx;
                    jdbcCtx.offsetParamIdx = offsetParamIdx;
                }
                return new JdbcSienaIterable<T>(statement, rs, query);
            }
            catch (SQLException e) {
                JdbcDBUtils.closeResultSet(rs);
                JdbcDBUtils.closeStatement(statement);
                throw new SienaException(e);
            }
        }
        if (offsetOpt.isActive()) {
            jdbcCtx.realOffset += offsetOpt.offset;
            offsetOpt.passivate();
        }
        try {
            jdbcCtx.statement.setObject(jdbcCtx.limitParamIdx, jdbcCtx.realPageSize);
            jdbcCtx.statement.setObject(jdbcCtx.offsetParamIdx, jdbcCtx.realOffset);
            ResultSet rs = jdbcCtx.statement.executeQuery();
            return new JdbcSienaIterable<T>(jdbcCtx.statement, rs, query);
        }
        catch (SQLException ex) {
            JdbcDBUtils.closeStatement(jdbcCtx.statement);
            throw new SienaException(ex);
        }
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doIter(query, Integer.MAX_VALUE, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doIter(query, limit, 0);
    }

    @Override
    public <T> Iterable<T> iter(Query<T> query, int limit, Object offset) {
        ((QueryOptionFetchType)query.option((int)4)).fetchType = QueryOptionFetchType.Type.ITER;
        return this.doIter(query, limit, (Integer)offset);
    }

    @Override
    public <T> void release(Query<T> query) {
        super.release(query);
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx != null && jdbcCtx.isActive()) {
            JdbcDBUtils.closeStatement(jdbcCtx.statement);
            jdbcCtx.statement = null;
            jdbcCtx.passivate();
        }
    }

    @Override
    public <T> void paginate(Query<T> query) {
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        if (state.isStateless()) {
            jdbcCtx.realOffset = 0;
        }
    }

    @Override
    public <T> void previousPage(Query<T> query) {
        QueryOptionPage pag;
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        if (jdbcCtx.noMoreDataBefore) {
            return;
        }
        if (jdbcCtx.noMoreDataAfter) {
            jdbcCtx.noMoreDataAfter = false;
        }
        if ((pag = (QueryOptionPage)query.option(1)).isPaginating()) {
            jdbcCtx.realPageSize = pag.pageSize;
            if (jdbcCtx.realOffset >= pag.pageSize) {
                jdbcCtx.realOffset -= pag.pageSize;
            } else {
                jdbcCtx.realOffset = 0;
                jdbcCtx.noMoreDataBefore = true;
            }
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }

    @Override
    public <T> void nextPage(Query<T> query) {
        QueryOptionJdbcContext jdbcCtx = (QueryOptionJdbcContext)query.option(4097);
        if (jdbcCtx == null) {
            jdbcCtx = new QueryOptionJdbcContext();
            query.customize(jdbcCtx);
        }
        if (jdbcCtx.noMoreDataAfter) {
            return;
        }
        if (jdbcCtx.noMoreDataBefore) {
            jdbcCtx.noMoreDataBefore = false;
            return;
        }
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        if (pag.isPaginating()) {
            jdbcCtx.realPageSize = pag.pageSize;
            jdbcCtx.realOffset += pag.pageSize;
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }

    @Override
    public int get(Object ... objects) {
        HashMap objMap = new HashMap();
        Statement ps = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
            } else {
                ((List)objMap.get(classInfo)).add(obj);
            }
            ++n2;
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                if (classInfo.keys.size() > 1) {
                    throw new SienaException("Can't batch select multiple keys objects");
                }
                Field f = classInfo.keys.get(0);
                HashMap keyObj = new HashMap();
                for (Object obj : (List)objMap.get(classInfo)) {
                    Object key = Util.readField(obj, f);
                    keyObj.put(key, obj);
                }
                Query<?> q = this.createQuery(classInfo.info.clazz);
                List<?> results = q.filter(String.valueOf(f.getName()) + " IN", keyObj.keySet()).fetch();
                for (Object res : results) {
                    Object resKey = Util.readField(res, f);
                    Util.copyObject(res, keyObj.get(resKey));
                }
                total += results.size();
            }
            int n3 = total;
            return n3;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> int get(Iterable<T> objects) {
        HashMap objMap = new HashMap();
        Statement ps = null;
        for (T obj : objects) {
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<T> l = new ArrayList<T>();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                if (classInfo.keys.size() > 1) {
                    throw new SienaException("Can't batch select multiple keys objects");
                }
                Field f = classInfo.keys.get(0);
                HashMap keyObj = new HashMap();
                for (Object obj : (List)objMap.get(classInfo)) {
                    Object key = Util.readField(obj, f);
                    keyObj.put(key, obj);
                }
                Query<?> q = this.createQuery(classInfo.info.clazz);
                List<?> results = q.filter(String.valueOf(f.getName()) + " IN", keyObj.keySet()).fetch();
                for (Object res : results) {
                    Object resKey = Util.readField(res, f);
                    Util.copyObject(res, keyObj.get(resKey));
                }
                total += results.size();
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Object key) {
        Statement ps = null;
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(clazz);
        try {
            if (classInfo.keys.size() > 1) {
                throw new SienaException("Can't batch select multiple keys objects");
            }
            Query<T> q = this.createQuery(clazz);
            T t = q.filter(String.valueOf(classInfo.info.getIdField().getName()) + "=", key).get();
            return t;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Object ... keys) {
        Statement ps = null;
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(clazz);
        try {
            if (classInfo.keys.size() > 1) {
                throw new SienaException("Can't batch select multiple keys objects");
            }
            Field f = classInfo.keys.get(0);
            ArrayList keyList = new ArrayList();
            Collections.addAll(keyList, keys);
            Query<T> q = this.createQuery(clazz);
            List<T> results = q.filter(String.valueOf(f.getName()) + " IN", keyList).fetch();
            ArrayList realResults = new ArrayList();
            HashMap<Object, T> keyObj = new HashMap<Object, T>();
            Object[] objectArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                if (!keyObj.containsKey(key)) {
                    int i = 0;
                    while (i < results.size()) {
                        T res = results.get(i);
                        Object resKey = Util.readField(res, f);
                        Object fromKey = Util.fromObject(f, key);
                        if (fromKey.equals(resKey)) {
                            keyObj.put(key, res);
                            results.remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                realResults.add(keyObj.get(key));
                ++n2;
            }
            ArrayList arrayList = realResults;
            return arrayList;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<?> keys) {
        Statement ps = null;
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(clazz);
        try {
            if (classInfo.keys.size() > 1) {
                throw new SienaException("Can't batch select multiple keys objects");
            }
            Field f = classInfo.keys.get(0);
            ArrayList keyList = new ArrayList();
            for (Object key : keys) {
                keyList.add(key);
            }
            Query<T> q = this.createQuery(clazz);
            List<T> results = q.filter(String.valueOf(f.getName()) + " IN", keyList).fetch();
            ArrayList realResults = new ArrayList();
            HashMap keyObj = new HashMap();
            for (Object key : keys) {
                if (!keyObj.containsKey(key)) {
                    int i = 0;
                    while (i < results.size()) {
                        T res = results.get(i);
                        Object resKey = Util.readField(res, f);
                        if (key.equals(resKey)) {
                            keyObj.put(key, res);
                            results.remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                realResults.add(keyObj.get(key));
            }
            ArrayList arrayList = realResults;
            return arrayList;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> PersistenceManagerAsync async() {
        throw new NotImplementedException();
    }

    @Override
    public int insert(Object ... objects) {
        HashMap<JdbcClassInfo, List<Object>> objMap = new HashMap<JdbcClassInfo, List<Object>>();
        PreparedStatement ps = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
            } else {
                ((List)objMap.get(classInfo)).add(obj);
            }
            ++n2;
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                if (classInfo.generatedKeys.isEmpty()) {
                    ps = this.getConnection().prepareStatement(classInfo.insertSQL);
                    for (Object obj : (List)objMap.get(classInfo)) {
                        for (Field field : classInfo.keys) {
                            Id id = field.getAnnotation(Id.class);
                            if (id.value() != Generator.UUID) continue;
                            field.set(obj, UUID.randomUUID().toString());
                        }
                        this.addParameters(obj, classInfo.insertFields, ps, 1);
                        ps.addBatch();
                    }
                    int[] res = ps.executeBatch();
                    total += res.length;
                    continue;
                }
                total += this.insertBatchWithAutoIncrementKey(classInfo, objMap);
            }
            int n3 = total;
            return n3;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int insert(Iterable<?> objects) {
        HashMap<JdbcClassInfo, List<Object>> objMap = new HashMap<JdbcClassInfo, List<Object>>();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                if (classInfo.generatedKeys.isEmpty()) {
                    ps = this.getConnection().prepareStatement(classInfo.insertSQL);
                    for (Object obj : (List)objMap.get(classInfo)) {
                        for (Field field : classInfo.keys) {
                            Id id = field.getAnnotation(Id.class);
                            if (id.value() != Generator.UUID) continue;
                            field.set(obj, UUID.randomUUID().toString());
                        }
                        this.addParameters(obj, classInfo.insertFields, ps, 1);
                        ps.addBatch();
                    }
                    int[] res = ps.executeBatch();
                    total += res.length;
                    continue;
                }
                total += this.insertBatchWithAutoIncrementKey(classInfo, objMap);
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int delete(Object ... objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
            } else {
                ((List)objMap.get(classInfo)).add(obj);
            }
            ++n2;
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    this.addParameters(obj, classInfo.keys, ps, 1);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                total += res.length;
            }
            int n3 = total;
            return n3;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int delete(Iterable<?> objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    this.addParameters(obj, classInfo.keys, ps, 1);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                total += res.length;
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> int deleteByKeys(Class<T> clazz, Object ... keys) {
        int n;
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(clazz);
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
            Object[] objectArray = keys;
            int n2 = keys.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    int[] res = ps.executeBatch();
                    n = res.length;
                    break;
                }
                Object key = objectArray[n3];
                this.setParameter(ps, 1, key);
                ps.addBatch();
                ++n3;
            }
        }
        catch (SienaException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new SienaException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcDBUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcDBUtils.closeStatement(ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> int deleteByKeys(Class<T> clazz, Iterable<?> keys) {
        int n;
        JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(clazz);
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(classInfo.deleteSQL);
            Iterator<?> iterator = keys.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    int[] res = ps.executeBatch();
                    n = res.length;
                    break;
                }
                Object key = iterator.next();
                this.setParameter(ps, 1, key);
                ps.addBatch();
            }
        }
        catch (SienaException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new SienaException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcDBUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcDBUtils.closeStatement(ps);
        return n;
    }

    @Override
    public <T> int update(Object ... objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
            } else {
                ((List)objMap.get(classInfo)).add(obj);
            }
            ++n2;
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = this.getConnection().prepareStatement(classInfo.updateSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                total += res.length;
            }
            int n3 = total;
            return n3;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> int update(Iterable<T> objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (T obj : objects) {
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<T> l = new ArrayList<T>();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = this.getConnection().prepareStatement(classInfo.updateSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                total += res.length;
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public <T> int update(Query<T> query, Map<String, ?> fieldValues) {
        throw new NotImplementedException("update not implemented for JDBC yet");
    }

    @Override
    public int save(Object ... objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
            } else {
                ((List)objMap.get(classInfo)).add(obj);
            }
            ++n2;
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = !classInfo.generatedKeys.isEmpty() ? this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL, 1) : this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    Field idField;
                    Object idVal = Util.readField(obj, idField = classInfo.info.getIdField());
                    if (idVal == null) {
                        for (Field field : classInfo.keys) {
                            Id id = field.getAnnotation(Id.class);
                            if (id.value() != Generator.UUID) continue;
                            field.set(obj, UUID.randomUUID().toString());
                        }
                    }
                    int i = 1;
                    i = this.addParameters(obj, classInfo.allFields, ps, i);
                    this.addParameters(obj, classInfo.updateFields, ps, i);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                if (!classInfo.generatedKeys.isEmpty()) {
                    ResultSet gk = ps.getGeneratedKeys();
                    int idx = 0;
                    int sz = ((List)objMap.get(classInfo)).size();
                    while (gk.next() && idx < sz) {
                        int i = 1;
                        for (Field field : classInfo.generatedKeys) {
                            field.setAccessible(true);
                            JdbcMappingUtils.setFromObject(((List)objMap.get(classInfo)).get(idx++), field, gk.getObject(i++));
                        }
                    }
                }
                total += res.length;
            }
            int n3 = total;
            return n3;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int save(Iterable<?> objects) {
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            JdbcClassInfo classInfo = JdbcClassInfo.getClassInfo(obj.getClass());
            if (!objMap.containsKey(classInfo)) {
                ArrayList l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcClassInfo classInfo : objMap.keySet()) {
                ps = !classInfo.generatedKeys.isEmpty() ? this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL, 1) : this.getConnection().prepareStatement(classInfo.insertOrUpdateSQL);
                for (Object obj : (List)objMap.get(classInfo)) {
                    Field idField;
                    Object idVal = Util.readField(obj, idField = classInfo.info.getIdField());
                    if (idVal == null) {
                        for (Field field : classInfo.keys) {
                            Id id = field.getAnnotation(Id.class);
                            if (id.value() != Generator.UUID) continue;
                            field.set(obj, UUID.randomUUID().toString());
                        }
                    }
                    int i = 1;
                    i = this.addParameters(obj, classInfo.allFields, ps, i);
                    this.addParameters(obj, classInfo.updateFields, ps, i);
                    ps.addBatch();
                }
                int[] res = ps.executeBatch();
                if (!classInfo.generatedKeys.isEmpty()) {
                    ResultSet gk = ps.getGeneratedKeys();
                    int idx = 0;
                    int sz = ((List)objMap.get(classInfo)).size();
                    while (gk.next() && idx < sz) {
                        int i = 1;
                        for (Field field : classInfo.generatedKeys) {
                            field.setAccessible(true);
                            JdbcMappingUtils.setFromObject(((List)objMap.get(classInfo)).get(idx++), field, gk.getObject(i++));
                        }
                    }
                }
                total += res.length;
            }
            int n = total;
            return n;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public String[] supportedOperators() {
        return supportedOperators;
    }

    public static class JdbcClassInfo {
        protected static Map<Class<?>, JdbcClassInfo> infoClasses = new ConcurrentHashMap();
        public ClassInfo info;
        public String tableName;
        public String insertSQL;
        public String updateSQL;
        public String insertOrUpdateSQL;
        public String deleteSQL;
        public String selectSQL;
        public String baseSelectSQL;
        public String keySelectSQL;
        public String baseKeySelectSQL;
        public List<Field> keys = null;
        public List<Field> insertFields = null;
        public List<Field> updateFields = null;
        public List<Field> generatedKeys = null;
        public List<Field> allFields = null;
        public List<Field> joinFields = null;
        public Map<String, String> joinFieldAliases = new HashMap<String, String>();

        public JdbcClassInfo(ClassInfo info) {
            this.info = info;
            this.keys = info.keys;
            this.insertFields = info.insertFields;
            this.updateFields = info.updateFields;
            this.generatedKeys = info.generatedKeys;
            this.allFields = info.allFields;
            this.tableName = info.tableName;
            this.joinFields = info.joinFields;
            ArrayList<String> keyColumns = new ArrayList<String>();
            ArrayList<String> keyWhereColumns = new ArrayList<String>();
            ArrayList<String> insertColumns = new ArrayList<String>();
            ArrayList<String> updateColumns = new ArrayList<String>();
            ArrayList<String> allColumns = new ArrayList<String>();
            JdbcClassInfo.calculateColumns(info.insertFields, insertColumns, null, "");
            JdbcClassInfo.calculateColumns(info.updateFields, updateColumns, null, "=?");
            JdbcClassInfo.calculateColumns(info.keys, keyColumns, null, "");
            JdbcClassInfo.calculateColumns(info.keys, keyWhereColumns, null, "=?");
            JdbcClassInfo.calculateColumns(info.allFields, allColumns, null, "");
            this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + Util.join(keyWhereColumns, " AND ");
            Object[] is = new String[insertColumns.size()];
            Arrays.fill(is, "?");
            this.insertSQL = "INSERT INTO " + this.tableName + " (" + Util.join(insertColumns, ", ") + ")" + " VALUES(" + Util.join(Arrays.asList(is), ", ") + ")";
            this.updateSQL = "UPDATE " + this.tableName + " SET " + Util.join(updateColumns, ", ") + " WHERE " + Util.join(keyWhereColumns, " AND ");
            Object[] as = new String[allColumns.size()];
            Arrays.fill(as, "?");
            this.insertOrUpdateSQL = "INSERT INTO " + this.tableName + " (" + Util.join(allColumns, ", ") + ")" + " VALUES(" + Util.join(Arrays.asList(as), ", ") + ")" + " ON DUPLICATE KEY UPDATE " + Util.join(updateColumns, ", ");
            this.baseSelectSQL = "SELECT " + Util.join(allColumns, ", ") + " FROM " + this.tableName;
            this.baseKeySelectSQL = "SELECT " + Util.join(keyColumns, ", ") + " FROM " + this.tableName;
            this.selectSQL = String.valueOf(this.baseSelectSQL) + " WHERE " + Util.join(keyWhereColumns, " AND ");
            this.keySelectSQL = String.valueOf(this.baseKeySelectSQL) + " WHERE " + Util.join(keyWhereColumns, " AND ");
        }

        public static void calculateColumns(List<Field> fields, List<String> columns, String tableName, String suffix) {
            for (Field field : fields) {
                String[] columnNames;
                String[] stringArray = columnNames = ClassInfo.getColumnNames(field, tableName);
                int n = columnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String columnName = stringArray[n2];
                    columns.add(String.valueOf(columnName) + suffix);
                    ++n2;
                }
            }
        }

        public static void calculateColumnsAliases(List<Field> fields, List<String> columns, String tableName, String suffix) {
            for (Field field : fields) {
                String[] columnNames;
                String[] stringArray = columnNames = ClassInfo.getColumnNames(field, tableName);
                int n = columnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String columnName = stringArray[n2];
                    columns.add(String.valueOf(columnName) + suffix + " AS " + JdbcClassInfo.aliasFromCol(String.valueOf(columnName) + suffix));
                    ++n2;
                }
            }
        }

        public static String aliasFromCol(String col) {
            return col.replace('.', '_');
        }

        public static JdbcClassInfo getClassInfo(Class<?> clazz) {
            JdbcClassInfo ci = infoClasses.get(clazz);
            if (ci == null) {
                ci = new JdbcClassInfo(ClassInfo.getClassInfo(clazz));
                infoClasses.put(clazz, ci);
            }
            return ci;
        }
    }
}

