/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import siena.ClassInfo;
import siena.Generator;
import siena.Id;
import siena.QueryFilterSearch;
import siena.SienaException;
import siena.Util;
import siena.core.options.QueryOption;
import siena.jdbc.ConnectionManager;
import siena.jdbc.JdbcDBUtils;
import siena.jdbc.JdbcPersistenceManager;
import siena.jdbc.QueryOptionPostgresqlSearch;

public class PostgresqlPersistenceManager
extends JdbcPersistenceManager {
    private static final String DB = "POSTGRES";

    public PostgresqlPersistenceManager() {
    }

    public PostgresqlPersistenceManager(ConnectionManager connectionManager, Class<?> listener) {
        super(connectionManager, listener);
    }

    @Override
    protected void setParameter(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value != null && value instanceof Date) {
            Date date = (Date)value;
            ps.setTimestamp(index, new Timestamp(date.getTime()));
        } else {
            ps.setObject(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Object obj) throws SQLException, IllegalAccessException {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.generatedKeys) {
            keyNames.add(field.getName());
        }
        ResultSet gk = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(classInfo.insertSQL + " RETURNING " + Util.join(keyNames, ","));
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            gk = ps.executeQuery();
            if (!gk.next()) {
                throw new SienaException("No such generated keys");
            }
            int i = 1;
            for (Field field : classInfo.generatedKeys) {
                Util.setFromObject(obj, field, gk.getObject(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeResultSet(gk);
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeResultSet(gk);
        JdbcDBUtils.closeStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int insertBatchWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Map<JdbcPersistenceManager.JdbcClassInfo, List<Object>> objMap) throws SQLException, IllegalAccessException {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.generatedKeys) {
            keyNames.add(field.getName());
        }
        PreparedStatement ps = null;
        ResultSet gk = null;
        int res = 0;
        try {
            ps = this.getConnection().prepareStatement(classInfo.insertSQL + " RETURNING " + Util.join(keyNames, ","));
            for (Object obj : objMap.get(classInfo)) {
                for (Field field : classInfo.keys) {
                    Id id = field.getAnnotation(Id.class);
                    if (id.value() != Generator.UUID) continue;
                    field.set(obj, UUID.randomUUID().toString());
                }
                this.addParameters(obj, classInfo.insertFields, ps, 1);
                gk = ps.executeQuery();
                if (!gk.next()) {
                    throw new SienaException("No such generated keys");
                }
                int i = 1;
                for (Field field : classInfo.generatedKeys) {
                    Util.setFromObject(obj, field, gk.getObject(i));
                    ++i;
                }
                JdbcDBUtils.closeResultSet(gk);
                ++res;
            }
        }
        catch (Throwable throwable) {
            JdbcDBUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcDBUtils.closeStatement(ps);
        return res;
    }

    @Override
    public <T> void appendSqlSearch(QueryFilterSearch qf, Class<?> clazz, JdbcPersistenceManager.JdbcClassInfo info, StringBuilder sql, List<Object> parameters) {
        ArrayList<String> cols = new ArrayList<String>();
        try {
            for (String field : qf.fields) {
                String[] columns;
                Field f = clazz.getDeclaredField(field);
                Class<?> cl = f.getType();
                if (Number.class.isAssignableFrom(cl) || Date.class.isAssignableFrom(cl)) {
                    for (String col : columns = ClassInfo.getColumnNames(f, info.tableName)) {
                        cols.add(col);
                    }
                    continue;
                }
                if (ClassInfo.isModel(cl)) {
                    ClassInfo ci = ClassInfo.getClassInfo(cl);
                    if (ci.keys.size() == 1) {
                        Field key = ci.keys.get(0);
                        if (Number.class.isAssignableFrom(key.getType()) || Date.class.isAssignableFrom(key.getType())) {
                            cols.add(f.getName());
                            continue;
                        }
                        cols.add("coalesce(" + f.getName() + ", '')");
                        continue;
                    }
                    for (Field key : ci.keys) {
                        String[] columns2 = ClassInfo.getColumnNamesWithPrefix(key, f.getName() + "_");
                        if (Number.class.isAssignableFrom(key.getType()) || Date.class.isAssignableFrom(key.getType())) {
                            for (String col : columns2) {
                                cols.add(col);
                            }
                            continue;
                        }
                        for (String col : columns2) {
                            cols.add("coalesce(" + col + ", '')");
                        }
                    }
                    continue;
                }
                for (String col : columns = ClassInfo.getColumnNames(f, info.tableName)) {
                    cols.add("coalesce(" + col + ", '')");
                }
            }
            QueryOption opt = qf.option;
            if (opt != null) {
                if (QueryOptionPostgresqlSearch.class.isAssignableFrom(opt.getClass())) {
                    String lang = ((QueryOptionPostgresqlSearch)opt).language;
                    if (lang != null && !"".equals(lang)) {
                        sql.append("to_tsvector('" + lang + "', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
                    } else {
                        sql.append("to_tsvector('english', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
                    }
                }
            } else {
                sql.append("to_tsvector('english', " + Util.join(cols, " || ' ' || ") + ") @@ to_tsquery(?)");
            }
            parameters.add(qf.match);
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
    }

    @Override
    public void save(Object obj) {
        JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.keys) {
            keyNames.add(field.getName());
        }
        PreparedStatement ps = null;
        try {
            Field idField = classInfo.info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null) {
                this.insert(obj);
            } else {
                ps = this.getConnection().prepareStatement("INSERT INTO " + classInfo.tableName + " (" + Util.join(keyNames, ",") + ") " + "SELECT ? WHERE ? NOT IN (SELECT " + Util.join(keyNames, ",") + " FROM " + classInfo.tableName + ");" + classInfo.updateSQL);
                int i = 1;
                i = this.addParameters(obj, classInfo.keys, ps, i);
                i = this.addParameters(obj, classInfo.keys, ps, i);
                i = this.addParameters(obj, classInfo.updateFields, ps, i);
                this.addParameters(obj, classInfo.keys, ps, i);
                ps.executeUpdate();
            }
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int save(Object ... objects) {
        HashMap generatedObjMap = new HashMap();
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            ArrayList<Object> l;
            JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
            Field idField = classInfo.info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null && !classInfo.generatedKeys.isEmpty()) {
                if (!generatedObjMap.containsKey(classInfo)) {
                    l = new ArrayList();
                    l.add(obj);
                    generatedObjMap.put(classInfo, l);
                    continue;
                }
                ((List)generatedObjMap.get(classInfo)).add(obj);
                continue;
            }
            if (!objMap.containsKey(classInfo)) {
                l = new ArrayList<Object>();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : generatedObjMap.keySet()) {
                total += this.insert((Iterable)generatedObjMap.get(classInfo));
            }
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : objMap.keySet()) {
                ArrayList<String> keyNames = new ArrayList<String>();
                for (Field field : classInfo.keys) {
                    keyNames.add(field.getName());
                }
                ps = this.getConnection().prepareStatement("INSERT INTO " + classInfo.tableName + " (" + Util.join(keyNames, ",") + ") " + "SELECT ? WHERE ? NOT IN (SELECT " + Util.join(keyNames, ",") + " FROM " + classInfo.tableName + ");" + classInfo.updateSQL);
                for (Field obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.executeUpdate();
                    ++total;
                }
            }
            int i$ = total;
            return i$;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }

    @Override
    public int save(Iterable<?> objects) {
        HashMap generatedObjMap = new HashMap();
        HashMap objMap = new HashMap();
        PreparedStatement ps = null;
        for (Object obj : objects) {
            ArrayList l;
            JdbcPersistenceManager.JdbcClassInfo classInfo = JdbcPersistenceManager.JdbcClassInfo.getClassInfo(obj.getClass());
            Field idField = classInfo.info.getIdField();
            Object idVal = Util.readField(obj, idField);
            if (idVal == null && !classInfo.generatedKeys.isEmpty()) {
                if (!generatedObjMap.containsKey(classInfo)) {
                    l = new ArrayList();
                    l.add(obj);
                    generatedObjMap.put(classInfo, l);
                    continue;
                }
                ((List)generatedObjMap.get(classInfo)).add(obj);
                continue;
            }
            if (!objMap.containsKey(classInfo)) {
                l = new ArrayList();
                l.add(obj);
                objMap.put(classInfo, l);
                continue;
            }
            ((List)objMap.get(classInfo)).add(obj);
        }
        int total = 0;
        try {
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : generatedObjMap.keySet()) {
                total += this.insert((Iterable)generatedObjMap.get(classInfo));
            }
            for (JdbcPersistenceManager.JdbcClassInfo classInfo : objMap.keySet()) {
                ArrayList<String> keyNames = new ArrayList<String>();
                for (Field field : classInfo.keys) {
                    keyNames.add(field.getName());
                }
                ps = this.getConnection().prepareStatement("INSERT INTO " + classInfo.tableName + " (" + Util.join(keyNames, ",") + ") " + "SELECT ? WHERE ? NOT IN (SELECT " + Util.join(keyNames, ",") + " FROM " + classInfo.tableName + ");" + classInfo.updateSQL);
                for (Field obj : (List)objMap.get(classInfo)) {
                    int i = 1;
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.keys, ps, i);
                    i = this.addParameters(obj, classInfo.updateFields, ps, i);
                    this.addParameters(obj, classInfo.keys, ps, i);
                    ps.executeUpdate();
                    ++total;
                }
            }
            int i$ = total;
            return i$;
        }
        catch (SienaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SienaException(e);
        }
        finally {
            JdbcDBUtils.closeStatement(ps);
        }
    }
}

