/*
 * Decompiled with CFR 0.152.
 */
package siena.gae;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import siena.ClassInfo;
import siena.Id;
import siena.QueryData;
import siena.QueryFilter;
import siena.QueryFilterSearch;
import siena.QueryFilterSimple;
import siena.QueryJoin;
import siena.QueryOrder;
import siena.SienaException;
import siena.SienaRestrictedApiException;
import siena.Util;
import siena.core.options.QueryOptionOffset;
import siena.core.options.QueryOptionPage;
import siena.core.options.QueryOptionState;
import siena.gae.GaeMappingUtils;
import siena.gae.QueryOptionGaeContext;
import siena.gae.Unindexed;

public class GaeQueryUtils {
    public static final Map<String, Query.FilterOperator> operators = new HashMap<String, Query.FilterOperator>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("=", Query.FilterOperator.EQUAL);
            this.put("!=", Query.FilterOperator.NOT_EQUAL);
            this.put("<", Query.FilterOperator.LESS_THAN);
            this.put(">", Query.FilterOperator.GREATER_THAN);
            this.put("<=", Query.FilterOperator.LESS_THAN_OR_EQUAL);
            this.put(">=", Query.FilterOperator.GREATER_THAN_OR_EQUAL);
            this.put(" IN", Query.FilterOperator.IN);
        }
    };

    public static <T> Query addFiltersOrders(QueryData<T> query, Query q) {
        Field f;
        List<QueryFilter> filters = query.getFilters();
        block7: for (QueryFilter filter : filters) {
            if (QueryFilterSimple.class.isAssignableFrom(filter.getClass())) {
                QueryFilterSimple qf = (QueryFilterSimple)filter;
                f = qf.field;
                String propertyName = ClassInfo.getColumnNames(f)[0];
                Object value = qf.value;
                Query.FilterOperator op = operators.get(qf.operator);
                if (op == Query.FilterOperator.IN || op == Query.FilterOperator.NOT_EQUAL) {
                    QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
                    gaeCtx.useCursor = false;
                    query.option(2).activate();
                }
                if (value != null && ClassInfo.isModel(value.getClass())) {
                    Key key = GaeMappingUtils.getKey(value);
                    q.addFilter(propertyName, op, (Object)key);
                    continue;
                }
                if (ClassInfo.isId(f)) {
                    Id id = f.getAnnotation(Id.class);
                    switch (id.value()) {
                        case NONE: {
                            Key key;
                            if (value == null) continue block7;
                            if (!Collection.class.isAssignableFrom(value.getClass())) {
                                key = KeyFactory.createKey((String)q.getKind(), (String)value.toString());
                                q.addFilter("__key__", op, (Object)key);
                                continue block7;
                            }
                            ArrayList<Key> keys = new ArrayList<Key>();
                            for (Object val : (Collection)value) {
                                keys.add(KeyFactory.createKey((String)q.getKind(), (String)val.toString()));
                            }
                            q.addFilter("__key__", op, keys);
                            continue block7;
                        }
                        case AUTO_INCREMENT: {
                            Key key;
                            if (value == null) continue block7;
                            if (!Collection.class.isAssignableFrom(value.getClass())) {
                                Class<?> type = f.getType();
                                key = Long.TYPE == type || Long.class.isAssignableFrom(type) ? KeyFactory.createKey((String)q.getKind(), (long)((Long)value)) : KeyFactory.createKey((String)q.getKind(), (String)value.toString());
                                q.addFilter("__key__", op, (Object)key);
                                continue block7;
                            }
                            ArrayList<Key> keys = new ArrayList();
                            for (Object val : (Collection)value) {
                                if (value instanceof String) {
                                    val = Long.parseLong((String)val);
                                }
                                keys.add(KeyFactory.createKey((String)q.getKind(), (long)((Long)val)));
                            }
                            q.addFilter("__key__", op, keys);
                            continue block7;
                        }
                        case UUID: {
                            Key key;
                            if (value == null) continue block7;
                            if (!Collection.class.isAssignableFrom(value.getClass())) {
                                key = KeyFactory.createKey((String)q.getKind(), (String)value.toString());
                                q.addFilter("__key__", op, (Object)key);
                                continue block7;
                            }
                            ArrayList<Key> keys = new ArrayList();
                            for (Object val : (Collection)value) {
                                keys.add(KeyFactory.createKey((String)q.getKind(), (String)val.toString()));
                            }
                            q.addFilter("__key__", op, keys);
                            continue block7;
                        }
                        default: {
                            throw new SienaException("Id Generator " + (Object)((Object)id.value()) + " not supported");
                        }
                    }
                }
                if (Enum.class.isAssignableFrom(f.getType())) {
                    value = value.toString();
                    q.addFilter(propertyName, op, value);
                    continue;
                }
                q.addFilter(propertyName, op, value);
                continue;
            }
            if (!QueryFilterSearch.class.isAssignableFrom(filter.getClass())) continue;
            Class<T> clazz = query.getQueriedClass();
            QueryFilterSearch qf = (QueryFilterSearch)filter;
            if (qf.fields.length > 1) {
                throw new SienaException("Search not possible for several fields in GAE: only one field");
            }
            try {
                String word;
                Field field = Util.getField(clazz, qf.fields[0]);
                if (field.isAnnotationPresent(Unindexed.class)) {
                    throw new SienaException("Cannot search the @Unindexed field " + field.getName());
                }
                String[] words = qf.match.split("\\s");
                Pattern pNormal = Pattern.compile("[^\\*](\\w+)[^\\*]");
                if (words.length > 1) {
                    String[] stringArray = words;
                    int val = words.length;
                    int keys = 0;
                    while (keys < val) {
                        String word2 = stringArray[keys];
                        if (!pNormal.matcher(word2).matches()) {
                            throw new SienaException("Cannot do a multiwords search with the * operator");
                        }
                        ++keys;
                    }
                    ArrayList<String> wordList = new ArrayList<String>();
                    Collections.addAll(wordList, words);
                    GaeQueryUtils.addSearchFilterIn(q, field, wordList);
                    break;
                }
                Pattern pStart = Pattern.compile("(\\w+)\\*");
                Matcher matcher = pStart.matcher(word = words[0]);
                if (matcher.matches()) {
                    String realWord = matcher.group(1);
                    GaeQueryUtils.addSearchFilterBeginsWith(q, field, realWord);
                    continue;
                }
                matcher = pNormal.matcher(word);
                if (matcher.matches()) {
                    GaeQueryUtils.addSearchFilterEquals(q, field, word);
                    continue;
                }
                Pattern pEnd = Pattern.compile("\\*(\\w+)");
                matcher = pEnd.matcher(word);
                if (!matcher.matches()) break;
                throw new SienaException("Cannot do a \"*word\" search in GAE");
            }
            catch (Exception e) {
                throw new SienaException(e);
            }
        }
        List<QueryOrder> orders = query.getOrders();
        for (QueryOrder order : orders) {
            f = order.field;
            if (ClassInfo.isId(f)) {
                q.addSort("__key__", order.ascending ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING);
                continue;
            }
            q.addSort(ClassInfo.getColumnNames(f)[0], order.ascending ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING);
        }
        return q;
    }

    public static void addSearchFilterBeginsWith(Query q, Field field, String match) {
        String[] columns = ClassInfo.getColumnNames(field);
        if (columns.length > 1) {
            throw new SienaException("Search not possible for multi-column fields in GAE: only one field with one column");
        }
        q.addFilter(columns[0], Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)match);
        q.addFilter(columns[0], Query.FilterOperator.LESS_THAN, (Object)(String.valueOf(match) + "\ufffd"));
    }

    public static void addSearchFilterEquals(Query q, Field field, String match) {
        String[] columns = ClassInfo.getColumnNames(field);
        if (columns.length > 1) {
            throw new SienaException("Search not possible for multi-column fields in GAE: only one field with one column");
        }
        q.addFilter(columns[0], Query.FilterOperator.EQUAL, (Object)match);
    }

    public static void addSearchFilterIn(Query q, Field field, List<String> matches) {
        String[] columns = ClassInfo.getColumnNames(field);
        if (columns.length > 1) {
            throw new SienaException("Search not possible for multi-column fields in GAE: only one field with one column");
        }
        q.addFilter(columns[0], Query.FilterOperator.IN, matches);
    }

    public static <T> Map<Field, ArrayList<Key>> buildJoinFieldKeysMap(QueryData<T> query) {
        List<QueryJoin> joins = query.getJoins();
        HashMap<Field, ArrayList<Key>> fieldMap = new HashMap<Field, ArrayList<Key>>();
        for (QueryJoin join : joins) {
            Field field = join.field;
            if (!ClassInfo.isModel(field.getType())) {
                throw new SienaRestrictedApiException("GAE", "join", "Join not possible: Field " + field.getName() + " is not a relation field");
            }
            if (join.sortFields != null && join.sortFields.length != 0) {
                throw new SienaRestrictedApiException("GAE", "join", "Join not allowed with sort fields");
            }
            fieldMap.put(field, new ArrayList());
        }
        for (Field field : ClassInfo.getClassInfo(query.getQueriedClass()).joinFields) {
            fieldMap.put(field, new ArrayList());
        }
        return fieldMap;
    }

    public static <T> void paginate(QueryData<T> query) {
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        QueryOptionState state = (QueryOptionState)query.option(3);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.options().put(gaeCtx.type, gaeCtx);
        }
        if (state.isStateless()) {
            gaeCtx.realOffset = 0;
        }
    }

    public static <T> void nextPage(QueryData<T> query) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.options().put(gaeCtx.type, gaeCtx);
        }
        if (gaeCtx.noMoreDataAfter) {
            return;
        }
        if (gaeCtx.noMoreDataBefore) {
            gaeCtx.noMoreDataBefore = false;
            return;
        }
        if (pag.isPaginating()) {
            gaeCtx.realPageSize = pag.pageSize;
            if (state.isStateless()) {
                gaeCtx.realOffset += pag.pageSize;
            } else if (!gaeCtx.isActive()) {
                QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                if (!gaeCtx.useCursor) {
                    gaeCtx.realOffset += pag.pageSize;
                } else {
                    offset.passivate();
                    gaeCtx.realOffset += pag.pageSize;
                }
            } else {
                QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                if (!gaeCtx.useCursor && !gaeCtx.hasNextCursor()) {
                    gaeCtx.realOffset += pag.pageSize;
                } else {
                    gaeCtx.useCursor = true;
                    String cursor = gaeCtx.nextCursor();
                    gaeCtx.realOffset += pag.pageSize;
                    if (cursor == null) {
                        offset.activate();
                    } else {
                        offset.passivate();
                    }
                }
            }
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }

    public static <T> void previousPage(QueryData<T> query) {
        QueryOptionPage pag = (QueryOptionPage)query.option(1);
        QueryOptionState state = (QueryOptionState)query.option(3);
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx == null) {
            gaeCtx = new QueryOptionGaeContext();
            query.options().put(gaeCtx.type, gaeCtx);
        }
        if (gaeCtx.noMoreDataBefore) {
            return;
        }
        if (gaeCtx.noMoreDataAfter) {
            gaeCtx.noMoreDataAfter = false;
        }
        if (pag.isPaginating()) {
            gaeCtx.realPageSize = pag.pageSize;
            if (state.isStateless()) {
                if (gaeCtx.realOffset >= pag.pageSize) {
                    gaeCtx.realOffset -= pag.pageSize;
                } else {
                    gaeCtx.realOffset = 0;
                    gaeCtx.noMoreDataBefore = true;
                }
            } else if (!gaeCtx.isActive()) {
                if (!gaeCtx.useCursor) {
                    if (gaeCtx.realOffset >= pag.pageSize) {
                        gaeCtx.realOffset -= pag.pageSize;
                    } else {
                        gaeCtx.realOffset = 0;
                        gaeCtx.noMoreDataBefore = true;
                    }
                } else if (gaeCtx.realOffset == 0) {
                    gaeCtx.noMoreDataBefore = true;
                }
            } else {
                QueryOptionOffset offset = (QueryOptionOffset)query.option(2);
                if (!gaeCtx.useCursor) {
                    if (gaeCtx.realOffset >= pag.pageSize) {
                        gaeCtx.realOffset -= pag.pageSize;
                    } else {
                        offset.passivate();
                        gaeCtx.noMoreDataBefore = true;
                        GaeQueryUtils.previousPage(query);
                    }
                } else {
                    String cursor = gaeCtx.previousCursor();
                    if (cursor == null) {
                        offset.activate();
                        gaeCtx.useCursor = false;
                        GaeQueryUtils.previousPage(query);
                    } else {
                        offset.passivate();
                        gaeCtx.useCursor = true;
                        if (gaeCtx.realOffset >= pag.pageSize) {
                            gaeCtx.realOffset -= pag.pageSize;
                        } else {
                            gaeCtx.noMoreDataBefore = true;
                            GaeQueryUtils.previousPage(query);
                        }
                    }
                }
            }
        } else {
            throw new SienaException("Can't use nextPage after pagination has been interrupted...");
        }
    }

    public static <T> void release(QueryData<T> query) {
        QueryOptionGaeContext gaeCtx = (QueryOptionGaeContext)query.option(8193);
        if (gaeCtx != null) {
            gaeCtx.cursors.clear();
            gaeCtx.passivate();
        }
    }
}

